/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraftforge.fml.IModStateTransition;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ThreadSelector;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ModStateTransitionHelper {
    static final IModStateTransition NOOP = new NoopTransition();

    ModStateTransitionHelper() {
    }

    static <V> CompletionStage<Void> completableFutureFromExceptionList(List<FutureResult<V>> t) {
        if (t.stream().noneMatch(e -> e.exception() != null)) {
            return CompletableFuture.completedFuture(null);
        }
        List<Throwable> throwables = t.stream().map(FutureResult::exception).filter(Objects::nonNull).toList();
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        RuntimeException accumulator = new RuntimeException();
        cf.completeExceptionally(accumulator);
        for (Throwable exception : throwables) {
            if (exception instanceof CompletionException) {
                exception = exception.getCause();
            }
            if (exception.getSuppressed().length != 0) {
                for (Throwable throwable : exception.getSuppressed()) {
                    accumulator.addSuppressed(throwable);
                }
                continue;
            }
            accumulator.addSuppressed(exception);
        }
        return cf;
    }

    static <V> CompletableFuture<List<FutureResult<V>>> gather(Collection<? extends CompletableFuture<? extends V>> futures) {
        ArrayList list = new ArrayList(futures.size());
        CompletableFuture[] results = new CompletableFuture[futures.size()];
        for (CompletableFuture<V> future : futures) {
            int i = list.size();
            list.add(null);
            CompletableFuture<V> raw = future;
            results[i] = raw.whenComplete((result, exception) -> list.set(i, new FutureResult<Object>(result, (Throwable)exception)));
        }
        return ((CompletableFuture)CompletableFuture.allOf(results).handle((r, th) -> null)).thenApply(res -> list);
    }

    private static <T extends IModBusEvent> void addCompletableFutureTaskForModDispatch(IModStateTransition transition, Executor executor, List<CompletableFuture<Void>> completableFutures, ProgressMeter progressBar, IModStateTransition.EventGenerator<T> eventGenerator, BiFunction<ModLoadingStage, Throwable, ModLoadingStage> nextState) {
        CompletableFuture<Void> preDispatchHook = ModStateTransitionHelper.getHook(transition.preDispatchHook(), executor, eventGenerator);
        if (preDispatchHook != null) {
            completableFutures.add(preDispatchHook);
        }
        LinkedHashMap<String, CompletionStage> modFutures = new LinkedHashMap<String, CompletionStage>();
        for (ModContainer mod : ModList.get().getLoadedMods()) {
            CompletableFuture<Void> parent = null;
            if (mod.dependencies.isEmpty()) {
                parent = CompletableFuture.allOf(new CompletableFuture[0]);
            } else {
                CompletableFuture[] deps = new CompletableFuture[mod.dependencies.size()];
                int idx = 0;
                for (ModContainer depContainer : mod.dependencies) {
                    CompletableFuture future = (CompletableFuture)modFutures.get(depContainer.getModId());
                    if (future == null) {
                        throw new IllegalStateException("Could not find dependency future " + depContainer.getModId() + " for " + mod.getModId());
                    }
                    deps[idx++] = future;
                }
                parent = CompletableFuture.allOf(deps);
            }
            CompletionStage dispatch = ((CompletableFuture)parent.thenRunAsync(() -> {
                ModLoadingContext.get().setActiveContainer(mod);
                Runnable handler = mod.activityMap.get((Object)mod.modLoadingStage);
                if (handler != null) {
                    handler.run();
                }
                mod.acceptEvent((IModBusEvent)eventGenerator.apply(mod));
            }, executor)).whenComplete((mc, exception) -> {
                mod.modLoadingStage = (ModLoadingStage)((Object)((Object)nextState.apply(mod.modLoadingStage, (Throwable)exception)));
                progressBar.increment();
                ModLoadingContext.get().setActiveContainer(null);
            });
            modFutures.put(mod.getModId(), dispatch);
        }
        CompletionStage dispatch = ModStateTransitionHelper.gather(modFutures.values()).thenComposeAsync(ModStateTransitionHelper::completableFutureFromExceptionList, executor);
        completableFutures.add((CompletableFuture<Void>)dispatch);
        CompletableFuture<Void> postDispatchHook = ModStateTransitionHelper.getHook(transition.preDispatchHook(), executor, eventGenerator);
        if (postDispatchHook != null) {
            completableFutures.add(postDispatchHook);
        }
    }

    private static <T extends IModBusEvent> CompletableFuture<Void> getHook(BiFunction<Executor, ? extends IModStateTransition.EventGenerator<?>, CompletableFuture<Void>> hook, Executor executor, IModStateTransition.EventGenerator<T> eventGenerator) {
        if (hook == null || hook == IModStateTransition.NULL_HOOK) {
            return null;
        }
        BiFunction<Executor, IModStateTransition.EventGenerator<?>, CompletableFuture<Void>> hookTyped = hook;
        return hookTyped.apply(executor, eventGenerator);
    }

    static <T extends IModBusEvent> CompletableFuture<Void> build(IModStateTransition transition, String name, Executor syncExecutor, Executor parallelExecutor, ProgressMeter progressBar, Function<Executor, CompletableFuture<Void>> preSyncTask, Function<Executor, CompletableFuture<Void>> postSyncTask) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        Executor executor = transition.threadSelector().apply(syncExecutor, parallelExecutor);
        List<IModStateTransition.EventGenerator> events = transition.eventFunctionStream().get().map(f -> f).toList();
        for (int x = 0; x < events.size(); ++x) {
            IModStateTransition.EventGenerator gen = events.get(x);
            BiFunction<ModLoadingStage, Throwable, ModLoadingStage> state = x == events.size() - 1 ? transition.nextModLoadingStage() : ModLoadingStage::currentState;
            ModStateTransitionHelper.addCompletableFutureTaskForModDispatch(transition, executor, futures, progressBar, gen, state);
        }
        CompletableFuture<Void> preSyncTaskCF = preSyncTask.apply(syncExecutor);
        CompletionStage eventDispatchCF = ModStateTransitionHelper.gather(futures).thenCompose(ModStateTransitionHelper::completableFutureFromExceptionList);
        CompletionStage postEventDispatchCF = ((CompletableFuture)((CompletableFuture)preSyncTaskCF.thenApplyAsync(n -> {
            progressBar.label(progressBar.name() + ": dispatching " + name);
            return null;
        }, parallelExecutor)).thenComposeAsync(arg_0 -> ModStateTransitionHelper.lambda$build$8((CompletableFuture)eventDispatchCF, arg_0), parallelExecutor)).thenApply(r -> {
            postSyncTask.apply(syncExecutor);
            return null;
        });
        return transition.finalActivityGenerator().apply(syncExecutor, (CompletableFuture<Void>)postEventDispatchCF);
    }

    private static /* synthetic */ CompletionStage lambda$build$8(CompletableFuture eventDispatchCF, Object n) {
        return eventDispatchCF;
    }

    record FutureResult<V>(V value, Throwable exception) {
    }

    record NoopTransition() implements IModStateTransition
    {
        @Override
        public ThreadSelector threadSelector() {
            return ThreadSelector.SYNC;
        }

        @Override
        public BiFunction<Executor, CompletableFuture<Void>, CompletableFuture<Void>> finalActivityGenerator() {
            return (e, t) -> t.thenApplyAsync(Function.identity(), (Executor)e);
        }
    }
}

