/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm;

import cpw.mods.modlauncher.serviceapi.ILaunchPluginService;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public final class CapabilityTokenSubclass
implements ILaunchPluginService {
    private static final String FUNC_NAME = "getType";
    private static final String FUNC_DESC = "()Ljava/lang/String;";
    private static final String CAP_INJECT = "net/minecraftforge/common/capabilities/CapabilityToken";
    private static final EnumSet<ILaunchPluginService.Phase> YAY = EnumSet.of(ILaunchPluginService.Phase.AFTER);
    private static final EnumSet<ILaunchPluginService.Phase> NAY = EnumSet.noneOf(ILaunchPluginService.Phase.class);

    public String name() {
        return "capability_token_subclass";
    }

    public EnumSet<ILaunchPluginService.Phase> handlesClass(Type classType, boolean isEmpty) {
        if (isEmpty) {
            return NAY;
        }
        String internalName = classType.getInternalName();
        if (internalName.startsWith("net/minecraft/") || internalName.startsWith("com/mojang/")) {
            return NAY;
        }
        if (internalName.startsWith("net/minecraftforge/common/capabilities/")) {
            return YAY;
        }
        return internalName.contains("$") ? YAY : NAY;
    }

    public int processClassWithFlags(ILaunchPluginService.Phase phase, ClassNode classNode, Type classType, String reason) {
        if (CAP_INJECT.equals(classNode.name)) {
            for (MethodNode mtd : classNode.methods) {
                if (!FUNC_NAME.equals(mtd.name) || !FUNC_DESC.equals(mtd.desc)) continue;
                mtd.access &= 0xFFFFFFEF;
            }
            return 256;
        }
        if (CAP_INJECT.equals(classNode.superName)) {
            final var cls = new Object(this){
                String value = null;
            };
            SignatureReader reader = new SignatureReader(classNode.signature);
            reader.accept(new SignatureVisitor(this, 589824){
                final Deque<String> stack;
                {
                    super(api);
                    this.stack = new ArrayDeque<String>();
                }

                public void visitClassType(String name) {
                    this.stack.push(name);
                }

                public void visitInnerClassType(String name) {
                    this.stack.push(this.stack.pop() + "$" + name);
                }

                public void visitEnd() {
                    String val = this.stack.pop();
                    if (!this.stack.isEmpty() && CapabilityTokenSubclass.CAP_INJECT.equals(this.stack.peek())) {
                        cls.value = val;
                    }
                }
            });
            if (cls.value == null) {
                throw new IllegalStateException("Could not find signature for CapabilityToken on " + classNode.name + " from " + classNode.signature);
            }
            MethodVisitor mtd = classNode.visitMethod(1, FUNC_NAME, FUNC_DESC, null, new String[0]);
            mtd.visitLdcInsn((Object)cls.value);
            mtd.visitInsn(176);
            mtd.visitEnd();
            return 1;
        }
        return 0;
    }
}

