/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.UniqueModListBuilder;
import net.minecraftforge.fml.loading.VersionSupportMatrix;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.loading.toposort.CyclePresentException;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class ModSorter {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ArtifactVersion NULL_VERSION = new DefaultArtifactVersion("null");

    private ModSorter() {
    }

    public static LoadingModList sort(List<ModFile> mods, List<EarlyLoadingException.ExceptionData> errors) {
        List<ModFile> modFiles;
        State systemMods = ModSorter.detectSystemMods(mods);
        try {
            modFiles = UniqueModListBuilder.buildUniqueList(mods).modFiles();
        }
        catch (EarlyLoadingException e) {
            return LoadingModList.of(systemMods.files(), systemMods.mods(), e);
        }
        HashMap<String, ModInfo> named = new HashMap<String, ModInfo>();
        for (ModFile file : modFiles) {
            for (IModInfo info : file.getModInfos()) {
                named.put(info.getModId(), (ModInfo)info);
            }
        }
        List<EarlyLoadingException.ExceptionData> failedList = Stream.concat(ModSorter.verifyDependencyVersions(modFiles).stream(), errors.stream()).toList();
        if (!failedList.isEmpty()) {
            return LoadingModList.of(systemMods.files(), systemMods.mods(), new EarlyLoadingException("failure to validate mod list", null, failedList));
        }
        try {
            State sorted = ModSorter.sort(modFiles, named);
            return LoadingModList.of(sorted.files(), sorted.mods(), null);
        }
        catch (EarlyLoadingException e) {
            return LoadingModList.of(systemMods.files(), systemMods.mods(), e);
        }
    }

    private static State sort(List<ModFile> modFiles, Map<String, ModInfo> named) {
        List<ModInfo> sorted;
        MutableGraph graph = GraphBuilder.directed().build();
        int counter = 0;
        HashMap<ModInfo, Integer> infos = new HashMap<ModInfo, Integer>();
        for (ModFile file : modFiles) {
            IModFileInfo iModFileInfo = file.getModFileInfo();
            if (!(iModFileInfo instanceof ModFileInfo)) continue;
            ModFileInfo info = (ModFileInfo)iModFileInfo;
            for (IModInfo iModInfo : info.getMods()) {
                ModInfo mod = (ModInfo)iModInfo;
                infos.put(mod, counter++);
                graph.addNode((Object)mod);
            }
        }
        for (ModFile file : modFiles) {
            for (IModInfo info : file.getModInfos()) {
                for (IModInfo.ModVersion dep2 : info.getDependencies()) {
                    ModInfo target = named.get(dep2.getModId());
                    if (target == null) continue;
                    ModInfo self = (ModInfo)dep2.getOwner();
                    switch (dep2.getOrdering()) {
                        case BEFORE: {
                            graph.putEdge((Object)self, (Object)target);
                            break;
                        }
                        case AFTER: {
                            graph.putEdge((Object)target, (Object)self);
                            break;
                        }
                    }
                }
            }
        }
        try {
            sorted = TopologicalSort.topologicalSort(graph, Comparator.comparing(infos::get));
        }
        catch (CyclePresentException e) {
            Set cycles = e.getCycles();
            StringBuilder buf = new StringBuilder();
            buf.append("Mod Sorting failed - Detected Cycles: \n");
            ArrayList<EarlyLoadingException.ExceptionData> arrayList = new ArrayList<EarlyLoadingException.ExceptionData>();
            for (Set cycle : cycles) {
                buf.append("\tCycle:\n");
                for (ModInfo mod : cycle) {
                    StringBuilder modDeps = new StringBuilder().append(mod.getModId()).append(' ').append(mod.getDependencies().stream().filter(v -> cycle.stream().anyMatch(m -> m.getModId().equals(v.getModId()))).map(dep -> dep.getOrdering().name() + " " + dep.getModId()).collect(Collectors.joining(", ")));
                    arrayList.add(new EarlyLoadingException.ExceptionData("fml.modloading.cycle", modDeps.toString()));
                    buf.append("\t\tMod: ").append(modDeps.toString()).append('\n');
                }
            }
            LOGGER.error(LogMarkers.LOADING, buf.toString());
            throw new EarlyLoadingException("Sorting error", e, arrayList);
        }
        LinkedHashSet<ModFile> files = new LinkedHashSet<ModFile>();
        ArrayList<ModInfo> list = new ArrayList<ModInfo>();
        for (ModInfo modInfo : sorted) {
            files.add(modInfo.getOwningFile().getFile());
            list.add(modInfo);
        }
        return new State(files.stream().toList(), list);
    }

    private static State detectSystemMods(List<ModFile> modFiles) {
        List<String> systemMods = List.of("minecraft", "forge");
        LOGGER.debug("Configured system mods: {}", systemMods);
        ArrayList<ModInfo> mods = new ArrayList<ModInfo>();
        ArrayList<ModFile> files = new ArrayList<ModFile>();
        for (String systemMod : systemMods) {
            ModPair mod = ModSorter.findMod(modFiles, systemMod);
            if (mod == null) {
                throw new IllegalStateException("Failed to find system mod: " + systemMod);
            }
            LOGGER.debug("Found system mod: {}", (Object)systemMod);
            mods.add(mod.info());
            files.add(mod.file());
        }
        return new State(files, mods);
    }

    private static ModPair findMod(List<ModFile> modFiles, String name) {
        for (ModFile file : modFiles) {
            for (IModInfo mod : file.getModFileInfo().getMods()) {
                if (!name.equals(mod.getModId())) continue;
                return new ModPair(file, (ModInfo)mod);
            }
        }
        return null;
    }

    private static List<EarlyLoadingException.ExceptionData> verifyDependencyVersions(List<ModFile> files) {
        HashMap<String, ArtifactVersion> modVersions = new HashMap<String, ArtifactVersion>();
        HashSet<IModInfo.ModVersion> modRequirements = new HashSet<IModInfo.ModVersion>();
        int mandatoryRequired = 0;
        for (ModFile file : files) {
            for (IModInfo info : file.getModInfos()) {
                modVersions.put(info.getModId(), info.getVersion());
                for (IModInfo.ModVersion dep : info.getDependencies()) {
                    if (!dep.getSide().isCorrectSide() || !modRequirements.add(dep) || !dep.isMandatory()) continue;
                    ++mandatoryRequired;
                }
            }
        }
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements ({} mandatory, {} optional)", new Object[]{modRequirements.size(), mandatoryRequired, modRequirements.size() - mandatoryRequired});
        HashSet<IModInfo.ModVersion> missingMandatory = new HashSet<IModInfo.ModVersion>();
        HashSet missingOptional = new HashSet();
        for (IModInfo.ModVersion dep : modRequirements) {
            String modId = dep.getModId();
            ArtifactVersion existing = (ArtifactVersion)modVersions.get(modId);
            if (!dep.isMandatory() && existing == null) continue;
            VersionRange range = dep.getVersionRange();
            if (existing != null && (range.containsVersion(existing) || "0.0NONE".equals(existing.toString())) || VersionSupportMatrix.testVersionSupportMatrix(range, modId, "mod")) continue;
            (dep.isMandatory() ? missingMandatory : missingOptional).add(dep);
        }
        LOGGER.debug(LogMarkers.LOADING, "Found {} mod requirements missing ({} mandatory, {} optional)", new Object[]{missingMandatory.size() + missingOptional.size(), missingMandatory.size(), missingOptional.size()});
        ArrayList<EarlyLoadingException.ExceptionData> ret = new ArrayList<EarlyLoadingException.ExceptionData>();
        if (!missingMandatory.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Missing or unsupported mandatory dependencies:\n{}", (Object)ModSorter.formatDependencyError(missingMandatory, modVersions));
            for (IModInfo.ModVersion mv : missingMandatory) {
                ret.add(ModSorter.data(mv, modVersions, "fml.modloading.missingdependency"));
            }
        }
        if (!missingOptional.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Unsupported installed optional dependencies:\n{}", (Object)ModSorter.formatDependencyError(missingMandatory, modVersions));
            for (IModInfo.ModVersion mv : missingMandatory) {
                ret.add(ModSorter.data(mv, modVersions, "fml.modloading.missingdependency.optional"));
            }
        }
        return ret;
    }

    private static String formatDependencyError(Collection<IModInfo.ModVersion> missing, Map<String, ArtifactVersion> modVersions) {
        ArrayList<String> ret = new ArrayList<String>();
        for (IModInfo.ModVersion dep : missing) {
            ArtifactVersion installed = modVersions.get(dep.getModId());
            ret.add(String.format("\tMod ID: '%s', Requested by: '%s', Expected range: '%s', Actual version: '%s'", dep.getModId(), dep.getOwner().getModId(), dep.getVersionRange(), installed != null ? installed.toString() : "[MISSING]"));
        }
        return String.join((CharSequence)"\n", ret);
    }

    private static EarlyLoadingException.ExceptionData data(IModInfo.ModVersion mv, Map<String, ArtifactVersion> modVersions, String key) {
        return new EarlyLoadingException.ExceptionData(key, mv.getOwner(), new Object[]{mv.getModId(), mv.getOwner().getModId(), mv.getVersionRange(), modVersions.getOrDefault(mv.getModId(), NULL_VERSION)});
    }

    private record State(List<ModFile> files, List<ModInfo> mods) {
    }

    private record ModPair(ModFile file, ModInfo info) {
    }
}

