/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.TypesafeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.EarlyLoadingException;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.AbstractModProvider;
import net.minecraftforge.fml.loading.moddiscovery.ClasspathLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IDependencyLocator;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;
import net.minecraftforge.jarjar.metadata.Metadata;
import net.minecraftforge.jarjar.metadata.MetadataIOHandler;
import net.minecraftforge.jarjar.selection.JarSelector;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ApiStatus.Internal
public class JarInJarDependencyLocator
extends AbstractModProvider
implements IDependencyLocator {
    private static final String ROIMFS = "roimfs";
    private static final String COLOR_CODE = "\u00a7";
    private static final String RESET = "\u00a7r";
    private static final String YELLOW = "\u00a7e";
    private static final String RED = "\u00a74";
    private static final String GREEN = "\u00a72";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Marker MARKER = MarkerFactory.getMarker((String)"JAR-JAR");
    private static final Map<Path, Option> OPTIONS = new HashMap<Path, Option>();
    private static volatile boolean optionsLoaded = false;
    private static final Attributes.Name MIXIN_CONFIGS_ATTR = new Attributes.Name("MixinConfigs");
    private static final Attributes.Name MIXIN_CONNECTOR_ATTR = new Attributes.Name("MixinConnector");
    private static final ContainedJarMetadata MIXIN_EXTRAS_DEPENDENCY = JarInJarDependencyLocator.makeMixinExtraDependency();
    private int fsID = 0;
    private static Boolean anyMixinsLoaded = null;
    private static final Entry FAILED = new Entry("FAILED ENTRY", Path.of("", new String[0]), IModFile.Type.LIBRARY, null);

    private static ContainedJarMetadata makeMixinExtraDependency() {
        VersionRange range = null;
        try {
            range = VersionRange.createFromVersionSpec((String)"[0,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException("Failed to create version range for mixinextras-forge dependency", e);
        }
        return new ContainedJarMetadata(new ContainedJarIdentifier("io.github.llamalad7", "mixinextras-forge"), new ContainedVersion(range, null), null, false);
    }

    public String name() {
        return "JarInJar";
    }

    private synchronized int nextId() {
        return this.fsID++;
    }

    public List<IModFile> scanMods(Iterable<IModFile> loadedMods) {
        ArrayList<IModFile> mods = new ArrayList<IModFile>();
        loadedMods.forEach(mods::add);
        Selector selector = new Selector(mods);
        if (JarInJarDependencyLocator.anyMixinsLoaded(mods)) {
            if (!selector.isRequired(MIXIN_EXTRAS_DEPENDENCY.identifier())) {
                selector.addRequirement(MIXIN_EXTRAS_DEPENDENCY);
            }
        } else if (selector.entries.size() == mods.size()) {
            LOGGER.info("No dependencies to load found. Skipping!");
            return Collections.emptyList();
        }
        JarInJarDependencyLocator.loadOptions();
        HashSet<Option> seen = new HashSet<Option>();
        boolean added = false;
        do {
            added = false;
            for (Option entry : OPTIONS.values()) {
                if (seen.contains(entry) || !selector.isRequired(entry.meta.identifier())) continue;
                seen.add(entry);
                entry.addTo(selector);
                if (entry.deps == null || entry.deps.isEmpty()) continue;
                added = true;
                for (ContainedJarMetadata containedJarMetadata : entry.deps) {
                    selector.addRequirement(containedJarMetadata);
                }
            }
        } while (added);
        List selected = selector.select();
        if (LOGGER.isDebugEnabled()) {
            TreeMap<String, List> ids = new TreeMap<String, List>();
            for (Entry entry : selector.entries.values()) {
                if (entry == FAILED || entry.coord == null) continue;
                ids.computeIfAbsent(entry.coord, id -> new ArrayList()).add(entry);
            }
            for (Map.Entry entry : ids.entrySet()) {
                LOGGER.info(MARKER, "JarJar Candidated for {}", entry.getKey());
                Collections.sort((List)entry.getValue());
                for (Entry option : (List)entry.getValue()) {
                    LOGGER.info(MARKER, "\t{}{}", (Object)Character.valueOf(selected.contains(option) ? (char)'*' : ' '), (Object)option);
                }
            }
        }
        if (selected.isEmpty()) {
            LOGGER.info("No dependencies to load found. Skipping!");
            return Collections.emptyList();
        }
        HashSet wasSelected = new HashSet(selected);
        for (Entry entry : selector.entries.values()) {
            entry.cleanup(wasSelected.contains(entry));
        }
        LOGGER.info(MARKER, "Found {} dependencies adding them to mods collection", (Object)selected.size());
        ArrayList<IModFile> ret = new ArrayList<IModFile>(selected.size());
        for (Entry entry : selected) {
            try {
                Path root = entry.getFinalPath();
                IModLocator.ModFileOrException mod = this.createMod(root, false, entry.type.name());
                if (mod.ex() != null) {
                    throw JarInJarDependencyLocator.fail("Failed to load JarInJar file " + String.valueOf(entry), (Throwable)mod.ex());
                }
                ret.add(mod.file());
            }
            catch (EarlyLoadingException e) {
                throw e;
            }
            catch (Throwable e) {
                throw JarInJarDependencyLocator.fail("Failed to load JarInJar file " + String.valueOf(entry), e);
            }
        }
        return ret;
    }

    private static boolean anyMixinsLoaded(List<IModFile> mods) {
        Boolean ret = anyMixinsLoaded;
        if (ret != null) {
            return ret;
        }
        if (!FMLEnvironment.production && Launcher.INSTANCE.blackboard().get(TypesafeMap.Key.getOrCreate((TypesafeMap)Launcher.INSTANCE.blackboard(), (String)"isMixinEnabledInDev", Boolean.class)).orElse(false).booleanValue()) {
            anyMixinsLoaded = true;
            return true;
        }
        for (IModFile mod : mods) {
            Attributes attributes = mod.getSecureJar().moduleDataProvider().getManifest().getMainAttributes();
            if (attributes.getValue(MIXIN_CONFIGS_ATTR) == null && attributes.getValue(MIXIN_CONNECTOR_ATTR) == null) continue;
            anyMixinsLoaded = true;
            return true;
        }
        anyMixinsLoaded = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadOptions() {
        if (optionsLoaded) {
            return;
        }
        Map<Path, Option> map = OPTIONS;
        synchronized (map) {
            if (optionsLoaded) {
                return;
            }
            optionsLoaded = true;
            Class<JarInJarDependencyLocator> self = JarInJarDependencyLocator.class;
            try (InputStream stream = self.getModule().getResourceAsStream("/jarjar_options.json");){
                if (stream == null) {
                    LOGGER.error(MARKER, "Failed to find jarjar_options.json");
                    return;
                }
                Options meta = (Options)MetadataIOHandler.getGson().fromJson((Reader)new InputStreamReader(stream), Options.class);
                if (meta == null) {
                    LOGGER.error(MARKER, "Corrupted jarjar_options.json");
                    return;
                }
                Iterator<OptionMetadata> iterator = meta.options().iterator();
                while (iterator.hasNext()) {
                    OptionMetadata jar = iterator.next();
                    Path path = ClasspathLocator.getPathFromResource(self.getClassLoader(), jar.resource());
                    if (path == null) {
                        LOGGER.error(MARKER, "Failed to find JarJar option for {}", (Object)jar.resource());
                        continue;
                    }
                    LOGGER.debug(MARKER, "Found JarJar Option: {}", (Object)path.toAbsolutePath());
                    if (jar.nested()) {
                        OPTIONS.put(path, new NestedOption(jar.id(), path, jar.layer(), jar.meta(), jar.deps()));
                        continue;
                    }
                    OPTIONS.put(path, new Option(jar.id(), path, jar.layer(), jar.meta(), jar.deps()));
                }
                return;
            }
            catch (Throwable e) {
                LOGGER.error(MARKER, "Failed to read JarJar Options file", e);
            }
            return;
        }
    }

    static boolean isOption(Path path) {
        JarInJarDependencyLocator.loadOptions();
        return OPTIONS.containsKey(path);
    }

    private static EarlyLoadingException fail(String message, @Nullable Throwable cause) {
        LOGGER.error(MARKER, message);
        return new EarlyLoadingException(message, cause, Collections.emptyList());
    }

    @Override
    protected String getDefaultJarModType() {
        return IModFile.Type.GAMELIBRARY.name();
    }

    protected static String identifyMod(IModFile modFile) {
        if (modFile.getModFileInfo() != null && !modFile.getModInfos().isEmpty()) {
            return modFile.getModInfos().stream().map(IModInfo::getModId).collect(Collectors.joining());
        }
        String module = modFile.getSecureJar().moduleDataProvider().name();
        if (module != null && !module.isEmpty()) {
            return module;
        }
        return modFile.getFileName();
    }

    private final class Selector
    extends JarSelector<Entry> {
        private final HashMap<Key, Entry> entries = new HashMap();
        private final HashMap<Entry, HashMap<String, String>> children = new HashMap();

        private Selector(Iterable<IModFile> mods) {
            for (IModFile mod : mods) {
                this.force(new ModEntry(mod));
            }
        }

        public void force(Entry entry) {
            super.force((Object)entry);
            this.entries.put(new Key(entry, ""), entry);
        }

        public void option(Entry entry, ContainedJarMetadata meta) {
            super.option((Object)entry, meta);
            this.entries.put(new Key(entry, ""), entry);
        }

        public void add(Entry entry) {
            super.add((Object)entry);
            this.entries.put(new Key(entry, ""), entry);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        protected InputStream getResource(Entry source, String path) {
            try {
                Path target = source.getResource(path);
                if (target == null || !Files.exists(target, new LinkOption[0])) {
                    LOGGER.debug(MARKER, "Failed to load resource {} from {}, it does not contain dependency information.", (Object)path, (Object)source);
                    return null;
                }
                if (!"META-INF/jarjar/metadata.json".equals(path)) return Files.newInputStream(target, new OpenOption[0]);
                try (InputStream is = Files.newInputStream(target, new OpenOption[0]);){
                    Metadata meta = MetadataIOHandler.fromStream((InputStream)is).orElse(null);
                    if (meta == null) {
                        InputStream inputStream = Files.newInputStream(target, new OpenOption[0]);
                        return inputStream;
                    }
                    HashMap<String, CallSite> children = new HashMap<String, CallSite>();
                    for (ContainedJarMetadata child : meta.jars()) {
                        children.put(child.path().replace('\\', '/'), (CallSite)((Object)(child.identifier().group() + ":" + child.identifier().artifact())));
                    }
                    this.children.put(source, children);
                    return Files.newInputStream(target, new OpenOption[0]);
                }
            }
            catch (Exception e) {
                LOGGER.error(MARKER, "Failed to load resource {} from {}, cause {}", new Object[]{path, source, e});
                return null;
            }
        }

        protected Entry getNested(Entry source, String path) {
            String cleaned = path.replace('\\', '/');
            Key key = new Key(source, cleaned);
            Entry entry = this.entries.get(key);
            if (entry == null) {
                entry = this.createNested(source, path, cleaned);
                if (entry == null) {
                    entry = FAILED;
                }
                this.entries.put(key, entry);
            }
            return entry == FAILED ? null : entry;
        }

        private Entry createNested(Entry source, String path, String cleaned) {
            Path modulePath;
            Path targetPath = source.getResource(path);
            if (targetPath == null || !Files.isRegularFile(targetPath, new LinkOption[0])) {
                return null;
            }
            Path roimfsPath = null;
            Path zipPath = null;
            try {
                byte[] data = Files.readAllBytes(targetPath);
                String filename = targetPath.getFileName().toString();
                URI uri = new URI(JarInJarDependencyLocator.ROIMFS, "jar-jar-" + JarInJarDependencyLocator.this.nextId() + "/" + filename, null);
                FileSystem roimfs = FileSystems.newFileSystem(uri, Collections.singletonMap("data", data));
                roimfsPath = roimfs.getPath(filename, new String[0]);
                FileSystem zip = FileSystems.newFileSystem(new URI("jar:" + String.valueOf(roimfsPath.toUri())), Collections.emptyMap());
                zipPath = zip.getRootDirectories().iterator().next();
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.error(MARKER, "Failed to create FileSystem for nested jar {}", (Object)source, (Object)e);
                return null;
            }
            Manifest mf = new Manifest();
            Path mfPath = zipPath.resolve("META-INF/MANIFEST.MF");
            if (Files.exists(mfPath, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(mfPath, new OpenOption[0]);){
                    mf = new Manifest(is);
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to read manifest from {}", (Object)source, (Object)e);
                }
            }
            IModFile.Type type = null;
            String id = null;
            Path tomlPath = zipPath.resolve("META-INF/mods.toml");
            if (Files.exists(tomlPath, new LinkOption[0])) {
                String value;
                UnmodifiableConfig first;
                Object modId;
                Collection collection;
                Collection mods;
                FileConfig cfg = FileConfig.builder((Path)tomlPath).build();
                cfg.load();
                cfg.close();
                Object object = cfg.getOrElse("mods", null);
                if (object instanceof Collection && !(mods = (collection = (Collection)object)).isEmpty() && (modId = (first = (UnmodifiableConfig)mods.iterator().next()).getOrElse("modId", null)) instanceof String) {
                    String str;
                    id = str = (String)modId;
                }
                type = (value = mf.getMainAttributes().getValue(ModFile.TYPE)) != null ? IModFile.Type.valueOf((String)value) : IModFile.Type.MOD;
            } else {
                String value = mf.getMainAttributes().getValue(ModFile.TYPE);
                type = value != null ? IModFile.Type.valueOf((String)value) : (source.type == IModFile.Type.LIBRARY || source.type == IModFile.Type.LANGPROVIDER ? IModFile.Type.LIBRARY : IModFile.Type.GAMELIBRARY);
            }
            if (id == null && Files.exists(modulePath = zipPath.resolve("module-info.class"), new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(modulePath, new OpenOption[0]);){
                    ModuleDescriptor module = ModuleDescriptor.read(is);
                    id = module.name();
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to read module-info.class from {}", (Object)source, (Object)e);
                }
            }
            if (id == null) {
                id = mf.getMainAttributes().getValue("Automatic-Module-Name");
            }
            if (id == null) {
                id = Path.of(path, new String[0]).getFileName().toString();
            }
            String coords = null;
            HashMap<String, String> child = this.children.get(source);
            if (child != null) {
                coords = child.get(cleaned);
            }
            return new Nested(id, roimfsPath, type, coords, source, cleaned, zipPath);
        }

        protected String getIdentifier(Entry entry) {
            return entry.id;
        }

        protected Throwable getFailureException(Collection<JarSelector.ResolutionFailureInformation<Entry>> failures) {
            ArrayList<EarlyLoadingException.ExceptionData> errors = new ArrayList<EarlyLoadingException.ExceptionData>();
            for (JarSelector.ResolutionFailureInformation<Entry> failure : failures) {
                String message = failure.failureReason() == JarSelector.FailureReason.VERSION_RESOLUTION_FAILED ? "fml.dependencyloading.conflictingdependencies" : "fml.dependencyloading.mismatchedcontaineddependencies";
                StringJoiner joiner = new StringJoiner(", ");
                for (JarSelector.SourceWithRequestedVersionRange source : failure.sources()) {
                    String paths = null;
                    if (source.sources().size() == 0) {
                        paths = "[No Sources]";
                    } else if (source.sources().size() == 1) {
                        Entry entry = (Entry)source.sources().iterator().next();
                        paths = entry.toString();
                    } else {
                        StringJoiner j = new StringJoiner(", ", "[", "]");
                        for (Entry entry : source.sources()) {
                            j.add(entry.toString());
                        }
                        paths = j.toString();
                    }
                    String error = JarInJarDependencyLocator.YELLOW + paths + "\u00a7r - \u00a74" + String.valueOf(source.requestedVersionRange()) + "\u00a7r - \u00a72" + String.valueOf(source.includedVersion()) + JarInJarDependencyLocator.RESET;
                    joiner.add(error);
                }
                errors.add(new EarlyLoadingException.ExceptionData(message, failure.identifier().group() + ":" + failure.identifier().artifact(), joiner.toString()));
            }
            return new EarlyLoadingException(failures.size() + " Dependency restrictions were not met.", null, errors);
        }
    }

    private static sealed class Option
    extends Entry
    permits NestedOption {
        final ContainedJarMetadata meta;
        final List<ContainedJarMetadata> deps;

        private Option(String id, Path path, IModFile.Type type, ContainedJarMetadata meta, List<ContainedJarMetadata> deps) {
            super(id, path, type, meta.identifier().group() + ":" + meta.identifier().artifact());
            this.meta = meta;
            this.deps = deps;
        }

        public void addTo(Selector selector) {
            selector.option(this, this.meta);
        }
    }

    private static sealed class Entry
    implements Comparable<Entry>
    permits ModEntry, Option, Nested {
        final String id;
        final Path path;
        final IModFile.Type type;
        @Nullable
        final String coord;

        private Entry(String id, Path path, IModFile.Type type, @Nullable String coord) {
            this.id = id;
            this.path = path;
            this.type = type;
            this.coord = coord;
        }

        Path getFinalPath() {
            return this.path;
        }

        void cleanup(boolean selected) {
        }

        public String toString() {
            if (this.path.getFileName() == null) {
                return this.path.toUri().toString();
            }
            return this.path.getFileName().toString();
        }

        @Nullable
        Path getResource(String path) {
            return null;
        }

        @Override
        public int compareTo(Entry o) {
            return o.toString().compareTo(this.toString());
        }
    }

    private record Options(List<OptionMetadata> options) {
    }

    private record OptionMetadata(String resource, IModFile.Type layer, String id, List<ContainedJarMetadata> deps, ContainedJarMetadata meta, boolean nested) {
    }

    private static final class NestedOption
    extends Option {
        private FileSystem zip;
        private Path root;

        private NestedOption(String id, Path path, IModFile.Type type, ContainedJarMetadata meta, List<ContainedJarMetadata> deps) {
            super(id, path, type, meta, deps);
        }

        @Override
        public void addTo(Selector selector) {
            super.addTo(selector);
            selector.add(this);
        }

        @Override
        void cleanup(boolean selected) {
            if (this.zip != null) {
                try {
                    this.zip.close();
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to close unselected FileSystem {}", (Object)this, (Object)e);
                }
            }
        }

        @Override
        @Nullable
        Path getResource(String path) {
            Path target;
            if (this.zip == null) {
                try {
                    this.zip = FileSystems.newFileSystem(this.path);
                    this.root = this.zip.getRootDirectories().iterator().next();
                }
                catch (IOException e) {
                    LOGGER.error(MARKER, "Failed to open FileSystem for option root {}", (Object)this, (Object)e);
                    return null;
                }
            }
            if (Files.exists(target = this.root.resolve(path), new LinkOption[0])) {
                return target;
            }
            return null;
        }
    }

    private record Key(Entry parent, String path) {
    }

    private static final class Nested
    extends Entry {
        private final Entry parent;
        private final String nestedPath;
        private final Path zipPath;

        Nested(String id, Path path, IModFile.Type type, String coords, Entry parent, String nestedPath, Path zipPath) {
            super(id, path, type, coords);
            this.parent = parent;
            this.nestedPath = nestedPath;
            this.zipPath = zipPath;
        }

        @Override
        public Path getFinalPath() {
            return this.zipPath;
        }

        @Override
        void cleanup(boolean selected) {
            if (selected) {
                return;
            }
            LOGGER.info(MARKER, "Closeing unselected FileSystem {}", (Object)this);
            try {
                this.zipPath.getFileSystem().close();
                this.path.getFileSystem().close();
            }
            catch (IOException e) {
                LOGGER.error(MARKER, "Failed to close unselected FileSystem {}", (Object)this, (Object)e);
            }
        }

        @Override
        @Nullable
        Path getResource(String path) {
            return this.zipPath.resolve(path);
        }

        @Override
        public String toString() {
            return String.valueOf(this.parent) + "!/" + this.nestedPath;
        }
    }

    private static final class ModEntry
    extends Entry {
        private final IModFile mod;

        ModEntry(IModFile mod) {
            super(JarInJarDependencyLocator.identifyMod(mod), mod.getFilePath(), mod.getType(), null);
            this.mod = mod;
        }

        @Override
        @Nullable
        Path getResource(String path) {
            return this.mod.findResource(new String[]{path});
        }
    }
}

