/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.google.common.base.MoreObjects;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.jetbrains.annotations.ApiStatus;
import org.objectweb.asm.Type;

@ApiStatus.Internal
class ModAnnotation {
    private final ElementType type;
    private final Type asmType;
    private final String member;
    private final Map<String, Object> values = new HashMap<String, Object>();
    private ArrayList<Object> arrayList;
    private String arrayName;

    public static ModFileScanData.AnnotationData fromModAnnotation(Type clazz, ModAnnotation annotation) {
        return new ModFileScanData.AnnotationData(annotation.asmType, annotation.type, clazz, annotation.member, annotation.values);
    }

    public ModAnnotation(ElementType type, Type asmType, String member) {
        this.type = type;
        this.asmType = asmType;
        this.member = member;
    }

    public ModAnnotation(Type asmType, ModAnnotation parent) {
        this(parent.type, asmType, parent.member);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Annotation").add("type", (Object)this.type).add("name", (Object)this.asmType.getClassName()).add("member", (Object)this.member).add("values", this.values).toString();
    }

    public ElementType getType() {
        return this.type;
    }

    public Type getASMType() {
        return this.asmType;
    }

    public String getMember() {
        return this.member;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void addArray(String name) {
        this.arrayList = new ArrayList();
        this.arrayName = name;
    }

    public void addProperty(String key, Object value) {
        if (this.arrayList != null) {
            this.arrayList.add(value);
        } else {
            this.values.put(key, value);
        }
    }

    public void addEnumProperty(String key, String enumName, String value) {
        this.addProperty(key, new ModFileScanData.EnumData(Type.getType((String)enumName), value));
    }

    public void endArray() {
        this.values.put(this.arrayName, this.arrayList);
        this.arrayList = null;
    }

    public ModAnnotation addChildAnnotation(String name, String desc) {
        ModAnnotation child = new ModAnnotation(Type.getType((String)desc), this);
        this.addProperty(name, child.getValues());
        return child;
    }
}

