/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsError;
import com.mojang.realmsclient.exception.RealmsServiceException;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.TextAlignment;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.Style;
import net.minecraft.realms.RealmsScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RealmsGenericErrorScreen
extends RealmsScreen {
    private static final Component GENERIC_TITLE = Component.translatable("mco.errorMessage.generic");
    private final Screen nextScreen;
    private final Component detail;
    private MultiLineLabel splitDetail = MultiLineLabel.EMPTY;

    public RealmsGenericErrorScreen(RealmsServiceException p_88669_, Screen p_88670_) {
        this(ErrorMessage.forServiceError(p_88669_), p_88670_);
    }

    public RealmsGenericErrorScreen(Component p_88672_, Screen p_88673_) {
        this(new ErrorMessage(GENERIC_TITLE, p_88672_), p_88673_);
    }

    public RealmsGenericErrorScreen(Component p_88675_, Component p_88676_, Screen p_88677_) {
        this(new ErrorMessage(p_88675_, p_88676_), p_88677_);
    }

    private RealmsGenericErrorScreen(ErrorMessage p_451864_, Screen p_458976_) {
        super(p_451864_.title);
        this.nextScreen = p_458976_;
        this.detail = ComponentUtils.mergeStyles(p_451864_.detail, Style.EMPTY.withColor(-2142128));
    }

    public void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder(CommonComponents.GUI_OK, p_325126_ -> this.onClose()).bounds(this.width / 2 - 100, this.height - 52, 200, 20).build());
        this.splitDetail = MultiLineLabel.create((Font)this.font, (Component)this.detail, (int)(this.width * 3 / 4));
    }

    public void onClose() {
        this.minecraft.setScreen(this.nextScreen);
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration(super.getNarrationMessage(), this.detail);
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 256) {
            this.minecraft.setScreen(this.nextScreen);
            return true;
        }
        return super.keyPressed(event);
    }

    public void render(GuiGraphics p_283497_, int p_88680_, int p_88681_, float p_88682_) {
        super.render(p_283497_, p_88680_, p_88681_, p_88682_);
        p_283497_.drawCenteredString(this.font, this.title, this.width / 2, 80, -1);
        ActiveTextCollector activetextcollector = p_283497_.textRenderer();
        this.splitDetail.visitLines(TextAlignment.CENTER, this.width / 2, 100, 9, activetextcollector);
    }

    @OnlyIn(value=Dist.CLIENT)
    record ErrorMessage(Component title, Component detail) {
        static ErrorMessage forServiceError(RealmsServiceException p_455496_) {
            RealmsError realmserror = p_455496_.realmsError;
            return new ErrorMessage(Component.translatable("mco.errorMessage.realmsService.realmsError", realmserror.errorCode()), realmserror.errorMessage());
        }
    }
}

