/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.IForgeKeyMapping;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyMappingLookup;
import net.minecraftforge.client.settings.KeyModifier;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class KeyMapping
implements Comparable<KeyMapping>,
IForgeKeyMapping {
    private static final Map<String, KeyMapping> ALL = Maps.newHashMap();
    private static final KeyMappingLookup MAP = new KeyMappingLookup();
    private final String name;
    private final InputConstants.Key defaultKey;
    private final Category category;
    protected InputConstants.Key key;
    boolean isDown;
    private int clickCount;
    private final int order;
    private KeyModifier keyModifierDefault = KeyModifier.NONE;
    private KeyModifier keyModifier = KeyModifier.NONE;
    private IKeyConflictContext keyConflictContext = KeyConflictContext.UNIVERSAL;

    public static void click(InputConstants.Key p_90836_) {
        KeyMapping.forAllKeyMappings(p_90836_, p_420622_ -> ++p_420622_.clickCount);
    }

    public static void set(InputConstants.Key p_90838_, boolean p_90839_) {
        KeyMapping.forAllKeyMappings(p_90838_, p_420621_ -> p_420621_.setDown(p_90839_));
    }

    private static void forAllKeyMappings(InputConstants.Key p_424096_, Consumer<KeyMapping> p_427756_) {
        List list = MAP.getAll(p_424096_);
        if (list != null && !list.isEmpty()) {
            for (KeyMapping keymapping : list) {
                p_427756_.accept(keymapping);
            }
        }
    }

    public static void setAll() {
        Window window = Minecraft.getInstance().getWindow();
        for (KeyMapping keymapping : ALL.values()) {
            if (!keymapping.shouldSetOnIngameFocus()) continue;
            keymapping.setDown(InputConstants.isKeyDown((Window)window, (int)keymapping.key.getValue()));
        }
    }

    public static void releaseAll() {
        for (KeyMapping keymapping : ALL.values()) {
            keymapping.release();
        }
    }

    public static void restoreToggleStatesOnScreenClosed() {
        for (KeyMapping keymapping : ALL.values()) {
            ToggleKeyMapping togglekeymapping;
            if (!(keymapping instanceof ToggleKeyMapping) || !(togglekeymapping = (ToggleKeyMapping)keymapping).shouldRestoreStateOnScreenClosed()) continue;
            togglekeymapping.setDown(true);
        }
    }

    public static void resetToggleKeys() {
        for (KeyMapping keymapping : ALL.values()) {
            if (!(keymapping instanceof ToggleKeyMapping)) continue;
            ToggleKeyMapping togglekeymapping = (ToggleKeyMapping)keymapping;
            togglekeymapping.reset();
        }
    }

    public static void resetMapping() {
        MAP.clear();
        for (KeyMapping keymapping : ALL.values()) {
            keymapping.registerMapping(keymapping.key);
        }
    }

    public KeyMapping(String p_90821_, int p_90822_, Category p_426799_) {
        this(p_90821_, InputConstants.Type.KEYSYM, p_90822_, p_426799_);
    }

    public KeyMapping(String p_90825_, InputConstants.Type p_90826_, int p_90827_, Category p_427928_) {
        this(p_90825_, p_90826_, p_90827_, p_427928_, 0);
    }

    public KeyMapping(String p_455154_, InputConstants.Type p_460964_, int p_457112_, Category p_455367_, int p_460901_) {
        this.name = p_455154_;
        this.defaultKey = this.key = p_460964_.getOrCreate(p_457112_);
        this.category = p_455367_;
        this.order = p_460901_;
        ALL.put(p_455154_, this);
        this.registerMapping(this.key);
    }

    public boolean isDown() {
        return this.isDown && this.isConflictContextAndModifierActive();
    }

    public Category getCategory() {
        return this.category;
    }

    public boolean consumeClick() {
        if (this.clickCount == 0) {
            return false;
        }
        --this.clickCount;
        return true;
    }

    protected void release() {
        this.clickCount = 0;
        this.setDown(false);
    }

    protected boolean shouldSetOnIngameFocus() {
        return this.key.getType() == InputConstants.Type.KEYSYM && this.key.getValue() != InputConstants.UNKNOWN.getValue();
    }

    public String getName() {
        return this.name;
    }

    public InputConstants.Key getDefaultKey() {
        return this.defaultKey;
    }

    public void setKey(InputConstants.Key p_90849_) {
        this.key = p_90849_;
    }

    @Override
    public int compareTo(KeyMapping p_90841_) {
        if (this.category == p_90841_.category) {
            return this.order == p_90841_.order ? I18n.get(this.name, new Object[0]).compareTo(I18n.get(p_90841_.name, new Object[0])) : Integer.compare(this.order, p_90841_.order);
        }
        return KeyMapping.compareSort(this.category, p_90841_.category);
    }

    private static int compareSort(Category c1, Category c2) {
        int o1 = Category.SORT_ORDER.indexOf(c1);
        int o2 = Category.SORT_ORDER.indexOf(c2);
        if (o1 == -1 && o2 != -1) {
            return 1;
        }
        if (o1 != -1 && o2 == -1) {
            return -1;
        }
        if (o1 == -1 && o2 == -1) {
            return I18n.get(c1.id().toLanguageKey("key.category"), new Object[0]).compareTo(I18n.get(c1.id().toLanguageKey("key.category"), new Object[0]));
        }
        return o1 - o2;
    }

    public static Supplier<Component> createNameSupplier(String p_90843_) {
        KeyMapping keymapping = ALL.get(p_90843_);
        return keymapping == null ? () -> Component.translatable(p_90843_) : keymapping::getTranslatedKeyMessage;
    }

    public boolean same(KeyMapping p_90851_) {
        if (this.getKeyConflictContext().conflicts(p_90851_.getKeyConflictContext()) || p_90851_.getKeyConflictContext().conflicts(this.getKeyConflictContext())) {
            KeyModifier keyModifier = this.getKeyModifier();
            KeyModifier otherKeyModifier = p_90851_.getKeyModifier();
            if (keyModifier.matches(p_90851_.getKey()) || otherKeyModifier.matches(this.getKey())) {
                return true;
            }
            if (this.getKey().equals((Object)p_90851_.getKey())) {
                return keyModifier == otherKeyModifier || this.getKeyConflictContext().conflicts((IKeyConflictContext)KeyConflictContext.IN_GAME) && (keyModifier == KeyModifier.NONE || otherKeyModifier == KeyModifier.NONE);
            }
        }
        return this.key.equals((Object)p_90851_.key);
    }

    public boolean isUnbound() {
        return this.key.equals((Object)InputConstants.UNKNOWN);
    }

    public boolean matches(KeyEvent p_425821_) {
        return p_425821_.key() == InputConstants.UNKNOWN.getValue() ? this.key.getType() == InputConstants.Type.SCANCODE && this.key.getValue() == p_425821_.scancode() : this.key.getType() == InputConstants.Type.KEYSYM && this.key.getValue() == p_425821_.key();
    }

    public boolean matchesMouse(MouseButtonEvent p_424724_) {
        return this.key.getType() == InputConstants.Type.MOUSE && this.key.getValue() == p_424724_.button();
    }

    public Component getTranslatedKeyMessage() {
        return this.getKeyModifier().getCombinedName(this.key, () -> this.key.getDisplayName());
    }

    public boolean isDefault() {
        return this.key.equals((Object)this.defaultKey) && this.getKeyModifier() == this.getDefaultKeyModifier();
    }

    public String saveString() {
        return this.key.getName();
    }

    public void setDown(boolean p_90846_) {
        this.isDown = p_90846_;
    }

    private void registerMapping(InputConstants.Key p_423386_) {
        MAP.put(p_423386_, this);
    }

    public static @org.jspecify.annotations.Nullable KeyMapping get(String p_378660_) {
        return ALL.get(p_378660_);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, InputConstants.Type inputType, int keyCode, Category category, int order) {
        this(description, keyConflictContext, inputType.getOrCreate(keyCode), category, order);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, InputConstants.Key keyCode, Category category, int order) {
        this(description, keyConflictContext, KeyModifier.NONE, keyCode, category, order);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Type inputType, int keyCode, Category category, int order) {
        this(description, keyConflictContext, keyModifier, inputType.getOrCreate(keyCode), category, order);
    }

    public KeyMapping(String description, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, InputConstants.Key keyCode, Category category, int order) {
        this.name = description;
        this.key = keyCode;
        this.defaultKey = keyCode;
        this.category = category;
        this.keyConflictContext = keyConflictContext;
        this.keyModifier = keyModifier;
        this.keyModifierDefault = keyModifier;
        this.order = order;
        if (this.keyModifier.matches(keyCode)) {
            this.keyModifier = KeyModifier.NONE;
        }
        ALL.put(description, this);
        MAP.put(keyCode, this);
    }

    public InputConstants.Key getKey() {
        return this.key;
    }

    public void setKeyConflictContext(IKeyConflictContext keyConflictContext) {
        this.keyConflictContext = keyConflictContext;
    }

    public IKeyConflictContext getKeyConflictContext() {
        return this.keyConflictContext;
    }

    public KeyModifier getDefaultKeyModifier() {
        return this.keyModifierDefault;
    }

    public KeyModifier getKeyModifier() {
        return this.keyModifier;
    }

    public void setKeyModifierAndCode(@Nullable KeyModifier keyModifier, InputConstants.Key keyCode) {
        MAP.remove(this);
        if (keyModifier == null) {
            keyModifier = KeyModifier.getModifier((InputConstants.Key)this.key);
        }
        if (keyModifier == null || keyCode == InputConstants.UNKNOWN || KeyModifier.isKeyCodeModifier((InputConstants.Key)keyCode)) {
            keyModifier = KeyModifier.NONE;
        }
        this.key = keyCode;
        this.keyModifier = keyModifier;
        MAP.put(keyCode, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Category(Identifier id) {
        static final List<Category> SORT_ORDER = new ArrayList<Category>();
        public static final Category MOVEMENT = Category.register("movement");
        public static final Category MISC = Category.register("misc");
        public static final Category MULTIPLAYER = Category.register("multiplayer");
        public static final Category GAMEPLAY = Category.register("gameplay");
        public static final Category INVENTORY = Category.register("inventory");
        public static final Category CREATIVE = Category.register("creative");
        public static final Category SPECTATOR = Category.register("spectator");
        public static final Category DEBUG = Category.register("debug");

        private static Category register(String p_426561_) {
            return Category.register(Identifier.withDefaultNamespace(p_426561_));
        }

        public static Category register(Identifier p_451176_) {
            Category keymapping$category = new Category(p_451176_);
            if (SORT_ORDER.contains(keymapping$category)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Category '%s' is already registered.", p_451176_));
            }
            SORT_ORDER.add(keymapping$category);
            return keymapping$category;
        }

        public Component label() {
            return Component.translatable(this.id.toLanguageKey("key.category"));
        }
    }
}

