/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.client.ClientBootstrap;
import net.minecraft.client.data.AtlasProvider;
import net.minecraft.client.data.models.EquipmentAssetProvider;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.WaypointStyleProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.data.loading.DatagenModLoader;

@OnlyIn(value=Dist.CLIENT)
public class Main {
    @DontObfuscate
    @SuppressForbidden(reason="System.out needed before bootstrap")
    public static void main(String[] p_375526_) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        AbstractOptionSpec optionspec = optionparser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionspec1 = optionparser.accepts("client", "Include client generators");
        OptionSpecBuilder optionspec2 = optionparser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec inputSpec = optionparser.accepts("input", "Input folder").withRequiredArg();
        DatagenModLoader loader = DatagenModLoader.setup((OptionParser)optionparser, (boolean)true);
        OptionSet optionset = optionparser.parse(p_375526_);
        if (!optionset.has((OptionSpec)optionspec) && optionset.hasOptions() && loader.hasArgs(optionset)) {
            List<Path> input = optionset.valuesOf((OptionSpec)inputSpec).stream().map(x$0 -> Paths.get(x$0, new String[0])).toList();
            Path path = Paths.get((String)optionspec3.value(optionset), new String[0]);
            boolean flag = optionset.has((OptionSpec)optionspec2);
            boolean flag1 = flag || optionset.has((OptionSpec)optionspec1);
            Bootstrap.bootStrap();
            ClientBootstrap.bootstrap();
            if (!loader.run(optionset, path, input, flag, flag1, flag, flag, true)) {
                return;
            }
            DataGenerator datagenerator = new DataGenerator(path, SharedConstants.getCurrentVersion(), true);
            Main.addClientProviders(datagenerator, flag1);
            datagenerator.run();
            Util.shutdownExecutors();
        } else {
            optionparser.printHelpOn((OutputStream)System.out);
        }
    }

    public static void addClientProviders(DataGenerator p_377181_, boolean p_375717_) {
        DataGenerator.PackGenerator datagenerator$packgenerator = p_377181_.getVanillaPack(p_375717_);
        datagenerator$packgenerator.addProvider(ModelProvider::new);
        datagenerator$packgenerator.addProvider(EquipmentAssetProvider::new);
        datagenerator$packgenerator.addProvider(WaypointStyleProvider::new);
        datagenerator$packgenerator.addProvider(AtlasProvider::new);
    }
}

