/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.MipmapStrategy;
import net.minecraft.client.renderer.texture.ReloadableTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LoadingOverlay
extends Overlay {
    public static final Identifier MOJANG_STUDIOS_LOGO_LOCATION = Identifier.withDefaultNamespace("textures/gui/title/mojangstudios.png");
    private static final int LOGO_BACKGROUND_COLOR = ARGB.color(255, 239, 50, 61);
    private static final int LOGO_BACKGROUND_COLOR_DARK = ARGB.color(255, 0, 0, 0);
    private static final IntSupplier BRAND_BACKGROUND = () -> (Boolean)Minecraft.getInstance().options.darkMojangStudiosBackground().get() != false ? LOGO_BACKGROUND_COLOR_DARK : LOGO_BACKGROUND_COLOR;
    private static final int LOGO_SCALE = 240;
    private static final float LOGO_QUARTER_FLOAT = 60.0f;
    private static final int LOGO_QUARTER = 60;
    private static final int LOGO_HALF = 120;
    private static final float LOGO_OVERLAP = 0.0625f;
    private static final float SMOOTHING = 0.95f;
    public static final long FADE_OUT_TIME = 1000L;
    public static final long FADE_IN_TIME = 500L;
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final Consumer<Optional<Throwable>> onFinish;
    private final boolean fadeIn;
    private float currentProgress;
    private long fadeOutStart = -1L;
    private long fadeInStart = -1L;

    public LoadingOverlay(Minecraft p_96172_, ReloadInstance p_96173_, Consumer<Optional<Throwable>> p_96174_, boolean p_96175_) {
        this.minecraft = p_96172_;
        this.reload = p_96173_;
        this.onFinish = p_96174_;
        this.fadeIn = p_96175_;
    }

    public static void registerTextures(TextureManager p_377842_) {
        p_377842_.registerAndLoad(MOJANG_STUDIOS_LOGO_LOCATION, (ReloadableTexture)new LogoTexture());
    }

    private static int replaceAlpha(int p_169325_, int p_169326_) {
        return p_169325_ & 0xFFFFFF | p_169326_ << 24;
    }

    protected boolean renderContents(GuiGraphics gui, float alpha) {
        return true;
    }

    public void render(GuiGraphics p_281839_, int p_282704_, int p_283650_, float p_283394_) {
        float f2;
        float f1;
        int i = p_281839_.guiWidth();
        int j = p_281839_.guiHeight();
        long k = Util.getMillis();
        if (this.fadeIn && this.fadeInStart == -1L) {
            this.fadeInStart = k;
        }
        float f = this.fadeOutStart > -1L ? (float)(k - this.fadeOutStart) / 1000.0f : -1.0f;
        float f3 = f1 = this.fadeInStart > -1L ? (float)(k - this.fadeInStart) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            if (this.minecraft.screen != null) {
                this.minecraft.screen.renderWithTooltipAndSubtitles(p_281839_, 0, 0, p_283394_);
            } else {
                this.minecraft.gui.renderDeferredSubtitles();
            }
            int l = Mth.ceil((1.0f - Mth.clamp(f - 1.0f, 0.0f, 1.0f)) * 255.0f);
            p_281839_.nextStratum();
            p_281839_.fill(0, 0, i, j, LoadingOverlay.replaceAlpha(BRAND_BACKGROUND.getAsInt(), l));
            f2 = 1.0f - Mth.clamp(f - 1.0f, 0.0f, 1.0f);
        } else if (this.fadeIn) {
            if (this.minecraft.screen != null && f1 < 1.0f) {
                this.minecraft.screen.renderWithTooltipAndSubtitles(p_281839_, p_282704_, p_283650_, p_283394_);
            } else {
                this.minecraft.gui.renderDeferredSubtitles();
            }
            int j2 = Mth.ceil(Mth.clamp((double)f1, 0.15, 1.0) * 255.0);
            p_281839_.nextStratum();
            p_281839_.fill(0, 0, i, j, LoadingOverlay.replaceAlpha(BRAND_BACKGROUND.getAsInt(), j2));
            f2 = Mth.clamp(f1, 0.0f, 1.0f);
        } else {
            int k2 = BRAND_BACKGROUND.getAsInt();
            RenderSystem.getDevice().createCommandEncoder().clearColorTexture(this.minecraft.getMainRenderTarget().getColorTexture(), k2);
            f2 = 1.0f;
        }
        if (this.renderContents(p_281839_, f2)) {
            int l2 = (int)((double)p_281839_.guiWidth() * 0.5);
            int i1 = (int)((double)p_281839_.guiHeight() * 0.5);
            double d0 = Math.min((double)p_281839_.guiWidth() * 0.75, (double)p_281839_.guiHeight()) * 0.25;
            int j1 = (int)(d0 * 0.5);
            double d1 = d0 * 4.0;
            int k1 = (int)(d1 * 0.5);
            int l1 = ARGB.white(f2);
            p_281839_.blit(RenderPipelines.MOJANG_LOGO, MOJANG_STUDIOS_LOGO_LOCATION, l2 - k1, i1 - j1, -0.0625f, 0.0f, k1, (int)d0, 120, 60, 120, 120, l1);
            p_281839_.blit(RenderPipelines.MOJANG_LOGO, MOJANG_STUDIOS_LOGO_LOCATION, l2, i1 - j1, 0.0625f, 60.0f, k1, (int)d0, 120, 60, 120, 120, l1);
            int i2 = (int)((double)p_281839_.guiHeight() * 0.8325);
            float f32 = this.reload.getActualProgress();
            this.currentProgress = Mth.clamp(this.currentProgress * 0.95f + f32 * 0.050000012f, 0.0f, 1.0f);
            if (f < 1.0f) {
                this.drawProgressBar(p_281839_, i / 2 - k1, i2 - 5, i / 2 + k1, i2 + 5, 1.0f - Mth.clamp(f, 0.0f, 1.0f));
            }
        }
        if (f >= 2.0f) {
            this.minecraft.setOverlay(null);
        }
    }

    public void tick() {
        if (this.fadeOutStart == -1L && this.reload.isDone() && this.isReadyToFadeOut()) {
            this.fadeOutStart = Util.getMillis();
            try {
                this.reload.checkExceptions();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.onFinish.accept(Optional.of(throwable));
            }
            if (this.minecraft.screen != null) {
                Window window = this.minecraft.getWindow();
                this.minecraft.screen.init(window.getGuiScaledWidth(), window.getGuiScaledHeight());
            }
        }
    }

    private boolean isReadyToFadeOut() {
        return !this.fadeIn || this.fadeInStart > -1L && Util.getMillis() - this.fadeInStart >= 1000L;
    }

    private void drawProgressBar(GuiGraphics p_283125_, int p_96184_, int p_96185_, int p_96186_, int p_96187_, float p_96188_) {
        int i = Mth.ceil((float)(p_96186_ - p_96184_ - 2) * this.currentProgress);
        int j = Math.round(p_96188_ * 255.0f);
        int k = ARGB.color(j, 255, 255, 255);
        p_283125_.fill(p_96184_ + 2, p_96185_ + 2, p_96184_ + i, p_96187_ - 2, k);
        p_283125_.fill(p_96184_ + 1, p_96185_, p_96186_ - 1, p_96185_ + 1, k);
        p_283125_.fill(p_96184_ + 1, p_96187_, p_96186_ - 1, p_96187_ - 1, k);
        p_283125_.fill(p_96184_, p_96185_, p_96184_ + 1, p_96187_, k);
        p_283125_.fill(p_96186_, p_96185_, p_96186_ - 1, p_96187_, k);
    }

    public boolean isPauseScreen() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LogoTexture
    extends ReloadableTexture {
        public LogoTexture() {
            super(MOJANG_STUDIOS_LOGO_LOCATION);
        }

        public TextureContents loadContents(ResourceManager p_376459_) throws IOException {
            TextureContents texturecontents;
            ResourceProvider resourceprovider = Minecraft.getInstance().getVanillaPackResources().asProvider();
            try (InputStream inputstream = resourceprovider.open(MOJANG_STUDIOS_LOGO_LOCATION);){
                texturecontents = new TextureContents(NativeImage.read((InputStream)inputstream), new TextureMetadataSection(true, true, MipmapStrategy.MEAN, 0.0f));
            }
            return texturecontents;
        }
    }
}

