/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.ClientAvatarEntity;
import net.minecraft.client.entity.ClientAvatarState;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.parrot.Parrot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractClientPlayer
extends Player
implements ClientAvatarEntity {
    private @Nullable PlayerInfo playerInfo;
    private final boolean showExtraEars;
    private final ClientAvatarState clientAvatarState = new ClientAvatarState();

    public AbstractClientPlayer(ClientLevel p_250460_, GameProfile p_249912_) {
        super(p_250460_, p_249912_);
        this.showExtraEars = "deadmau5".equals(this.getGameProfile().name());
    }

    @Override
    public @Nullable GameType gameMode() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo != null ? playerinfo.getGameMode() : null;
    }

    protected @Nullable PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getUUID());
        }
        return this.playerInfo;
    }

    @Override
    public void tick() {
        this.clientAvatarState.tick(this.position(), this.getDeltaMovement());
        super.tick();
    }

    protected void addWalkedDistance(float p_423097_) {
        this.clientAvatarState.addWalkDistance(p_423097_);
    }

    public ClientAvatarState avatarState() {
        return this.clientAvatarState;
    }

    public @Nullable Component belowNameDisplay() {
        Scoreboard scoreboard = this.level().getScoreboard();
        Objective objective = scoreboard.getDisplayObjective(DisplaySlot.BELOW_NAME);
        if (objective != null) {
            ReadOnlyScoreInfo readonlyscoreinfo = scoreboard.getPlayerScoreInfo(this, objective);
            MutableComponent component = ReadOnlyScoreInfo.safeFormatValue(readonlyscoreinfo, objective.numberFormatOrDefault(StyledFormat.NO_STYLE));
            return Component.empty().append(component).append(CommonComponents.SPACE).append(objective.getDisplayName());
        }
        return null;
    }

    public PlayerSkin getSkin() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.get((UUID)this.getUUID()) : playerinfo.getSkin();
    }

    public @Nullable Parrot.Variant getParrotVariantOnShoulder(boolean p_422582_) {
        return (p_422582_ ? this.getShoulderParrotLeft() : this.getShoulderParrotRight()).orElse(null);
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.avatarState().resetBob();
    }

    @Override
    public void aiStep() {
        this.updateBob();
        super.aiStep();
    }

    protected void updateBob() {
        float f = this.onGround() && !this.isDeadOrDying() && !this.isSwimming() ? Math.min(0.1f, (float)this.getDeltaMovement().horizontalDistance()) : 0.0f;
        this.avatarState().updateBob(f);
    }

    public float getFieldOfViewModifier(boolean p_361176_, float p_362521_) {
        float f1;
        float f = 1.0f;
        if (this.getAbilities().flying) {
            f *= 1.1f;
        }
        if ((f1 = this.getAbilities().getWalkingSpeed()) != 0.0f) {
            float f2 = (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) / f1;
            f *= (f2 + 1.0f) / 2.0f;
        }
        if (this.isUsingItem()) {
            if (this.getUseItem().is(Items.BOW)) {
                float f3 = Math.min((float)this.getTicksUsingItem() / 20.0f, 1.0f);
                f *= 1.0f - Mth.square(f3) * 0.15f;
            } else if (p_361176_ && this.isScoping()) {
                return 0.1f;
            }
        }
        return ForgeEventFactoryClient.fireFovModifierEvent((Player)this, (float)f, (float)p_362521_).getNewFovModifier();
    }

    public boolean showExtraEars() {
        return this.showExtraEars;
    }
}

