/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.Holder;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.loading.ClientModLoader;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class ItemBlockRenderTypes {
    @Deprecated
    private static final Map<Block, ChunkSectionLayer> TYPE_BY_BLOCK = Util.make(Maps.newHashMap(), p_448152_ -> {
        ChunkSectionLayer chunksectionlayer = ChunkSectionLayer.TRIPWIRE;
        p_448152_.put(Blocks.TRIPWIRE, chunksectionlayer);
        ChunkSectionLayer chunksectionlayer1 = ChunkSectionLayer.CUTOUT;
        p_448152_.put(Blocks.GRASS_BLOCK, chunksectionlayer1);
        p_448152_.put(Blocks.IRON_BARS, chunksectionlayer1);
        Blocks.COPPER_BARS.forEach(p_420873_ -> p_448152_.put(p_420873_, chunksectionlayer1));
        p_448152_.put(Blocks.TRIPWIRE_HOOK, chunksectionlayer1);
        p_448152_.put(Blocks.HOPPER, chunksectionlayer1);
        p_448152_.put(Blocks.IRON_CHAIN, chunksectionlayer1);
        Blocks.COPPER_CHAIN.forEach(p_420866_ -> p_448152_.put(p_420866_, chunksectionlayer1));
        p_448152_.put(Blocks.JUNGLE_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.OAK_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.SPRUCE_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.ACACIA_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.CHERRY_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.BIRCH_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.DARK_OAK_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_OAK_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.AZALEA_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.FLOWERING_AZALEA_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.MANGROVE_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.MANGROVE_LEAVES, chunksectionlayer1);
        p_448152_.put(Blocks.OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.SPRUCE_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.BIRCH_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.JUNGLE_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.ACACIA_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.CHERRY_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.DARK_OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.WHITE_BED, chunksectionlayer1);
        p_448152_.put(Blocks.ORANGE_BED, chunksectionlayer1);
        p_448152_.put(Blocks.MAGENTA_BED, chunksectionlayer1);
        p_448152_.put(Blocks.LIGHT_BLUE_BED, chunksectionlayer1);
        p_448152_.put(Blocks.YELLOW_BED, chunksectionlayer1);
        p_448152_.put(Blocks.LIME_BED, chunksectionlayer1);
        p_448152_.put(Blocks.PINK_BED, chunksectionlayer1);
        p_448152_.put(Blocks.GRAY_BED, chunksectionlayer1);
        p_448152_.put(Blocks.LIGHT_GRAY_BED, chunksectionlayer1);
        p_448152_.put(Blocks.CYAN_BED, chunksectionlayer1);
        p_448152_.put(Blocks.PURPLE_BED, chunksectionlayer1);
        p_448152_.put(Blocks.BLUE_BED, chunksectionlayer1);
        p_448152_.put(Blocks.BROWN_BED, chunksectionlayer1);
        p_448152_.put(Blocks.GREEN_BED, chunksectionlayer1);
        p_448152_.put(Blocks.RED_BED, chunksectionlayer1);
        p_448152_.put(Blocks.BLACK_BED, chunksectionlayer1);
        p_448152_.put(Blocks.POWERED_RAIL, chunksectionlayer1);
        p_448152_.put(Blocks.DETECTOR_RAIL, chunksectionlayer1);
        p_448152_.put(Blocks.COBWEB, chunksectionlayer1);
        p_448152_.put(Blocks.SHORT_GRASS, chunksectionlayer1);
        p_448152_.put(Blocks.FERN, chunksectionlayer1);
        p_448152_.put(Blocks.BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.SHORT_DRY_GRASS, chunksectionlayer1);
        p_448152_.put(Blocks.TALL_DRY_GRASS, chunksectionlayer1);
        p_448152_.put(Blocks.SEAGRASS, chunksectionlayer1);
        p_448152_.put(Blocks.TALL_SEAGRASS, chunksectionlayer1);
        p_448152_.put(Blocks.DANDELION, chunksectionlayer1);
        p_448152_.put(Blocks.OPEN_EYEBLOSSOM, chunksectionlayer1);
        p_448152_.put(Blocks.CLOSED_EYEBLOSSOM, chunksectionlayer1);
        p_448152_.put(Blocks.POPPY, chunksectionlayer1);
        p_448152_.put(Blocks.BLUE_ORCHID, chunksectionlayer1);
        p_448152_.put(Blocks.ALLIUM, chunksectionlayer1);
        p_448152_.put(Blocks.AZURE_BLUET, chunksectionlayer1);
        p_448152_.put(Blocks.RED_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.ORANGE_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.WHITE_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.PINK_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.OXEYE_DAISY, chunksectionlayer1);
        p_448152_.put(Blocks.CORNFLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.WITHER_ROSE, chunksectionlayer1);
        p_448152_.put(Blocks.LILY_OF_THE_VALLEY, chunksectionlayer1);
        p_448152_.put(Blocks.BROWN_MUSHROOM, chunksectionlayer1);
        p_448152_.put(Blocks.RED_MUSHROOM, chunksectionlayer1);
        p_448152_.put(Blocks.TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.WALL_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.SOUL_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.SOUL_WALL_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.COPPER_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.COPPER_WALL_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.FIRE, chunksectionlayer1);
        p_448152_.put(Blocks.SOUL_FIRE, chunksectionlayer1);
        p_448152_.put(Blocks.SPAWNER, chunksectionlayer1);
        p_448152_.put(Blocks.TRIAL_SPAWNER, chunksectionlayer1);
        p_448152_.put(Blocks.VAULT, chunksectionlayer1);
        p_448152_.put(Blocks.WHEAT, chunksectionlayer1);
        p_448152_.put(Blocks.OAK_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.LADDER, chunksectionlayer1);
        p_448152_.put(Blocks.RAIL, chunksectionlayer1);
        p_448152_.put(Blocks.IRON_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.REDSTONE_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.REDSTONE_WALL_TORCH, chunksectionlayer1);
        p_448152_.put(Blocks.CACTUS, chunksectionlayer1);
        p_448152_.put(Blocks.SUGAR_CANE, chunksectionlayer1);
        p_448152_.put(Blocks.REPEATER, chunksectionlayer1);
        p_448152_.put(Blocks.OAK_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.SPRUCE_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.BIRCH_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.JUNGLE_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.ACACIA_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.CHERRY_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.DARK_OAK_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_OAK_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.CRIMSON_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WARPED_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.MANGROVE_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.BAMBOO_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.EXPOSED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WEATHERED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.OXIDIZED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_EXPOSED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_WEATHERED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_OXIDIZED_COPPER_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.ATTACHED_PUMPKIN_STEM, chunksectionlayer1);
        p_448152_.put(Blocks.ATTACHED_MELON_STEM, chunksectionlayer1);
        p_448152_.put(Blocks.PUMPKIN_STEM, chunksectionlayer1);
        p_448152_.put(Blocks.MELON_STEM, chunksectionlayer1);
        p_448152_.put(Blocks.VINE, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_MOSS_CARPET, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_HANGING_MOSS, chunksectionlayer1);
        p_448152_.put(Blocks.GLOW_LICHEN, chunksectionlayer1);
        p_448152_.put(Blocks.RESIN_CLUMP, chunksectionlayer1);
        p_448152_.put(Blocks.LILY_PAD, chunksectionlayer1);
        p_448152_.put(Blocks.NETHER_WART, chunksectionlayer1);
        p_448152_.put(Blocks.BREWING_STAND, chunksectionlayer1);
        p_448152_.put(Blocks.COCOA, chunksectionlayer1);
        p_448152_.put(Blocks.FLOWER_POT, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_SPRUCE_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_BIRCH_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_JUNGLE_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_ACACIA_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CHERRY_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_DARK_OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_PALE_OAK_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_MANGROVE_PROPAGULE, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_FERN, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_DANDELION, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_POPPY, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_OPEN_EYEBLOSSOM, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CLOSED_EYEBLOSSOM, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_BLUE_ORCHID, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_ALLIUM, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_AZURE_BLUET, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_RED_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_ORANGE_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_WHITE_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_PINK_TULIP, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_OXEYE_DAISY, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CORNFLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_LILY_OF_THE_VALLEY, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_WITHER_ROSE, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_RED_MUSHROOM, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_BROWN_MUSHROOM, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_DEAD_BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CACTUS, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_AZALEA, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_FLOWERING_AZALEA, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_TORCHFLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.CARROTS, chunksectionlayer1);
        p_448152_.put(Blocks.POTATOES, chunksectionlayer1);
        p_448152_.put(Blocks.COMPARATOR, chunksectionlayer1);
        p_448152_.put(Blocks.ACTIVATOR_RAIL, chunksectionlayer1);
        p_448152_.put(Blocks.IRON_TRAPDOOR, chunksectionlayer1);
        p_448152_.put(Blocks.SUNFLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.LILAC, chunksectionlayer1);
        p_448152_.put(Blocks.ROSE_BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.PEONY, chunksectionlayer1);
        p_448152_.put(Blocks.TALL_GRASS, chunksectionlayer1);
        p_448152_.put(Blocks.LARGE_FERN, chunksectionlayer1);
        p_448152_.put(Blocks.SPRUCE_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.BIRCH_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.JUNGLE_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.ACACIA_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.CHERRY_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.DARK_OAK_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.PALE_OAK_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.MANGROVE_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.BAMBOO_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.EXPOSED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WEATHERED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.OXIDIZED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_EXPOSED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_WEATHERED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_OXIDIZED_COPPER_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.END_ROD, chunksectionlayer1);
        p_448152_.put(Blocks.CHORUS_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.CHORUS_FLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.TORCHFLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.TORCHFLOWER_CROP, chunksectionlayer1);
        p_448152_.put(Blocks.PITCHER_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.PITCHER_CROP, chunksectionlayer1);
        p_448152_.put(Blocks.BEETROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.KELP, chunksectionlayer1);
        p_448152_.put(Blocks.KELP_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.TURTLE_EGG, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_TUBE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BRAIN_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BUBBLE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_FIRE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_HORN_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.TUBE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.BRAIN_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.BUBBLE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.FIRE_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.HORN_CORAL, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_TUBE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BRAIN_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BUBBLE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_FIRE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_HORN_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.TUBE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.BRAIN_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.BUBBLE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.FIRE_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.HORN_CORAL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_TUBE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BRAIN_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_BUBBLE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_FIRE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.DEAD_HORN_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.TUBE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.BRAIN_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.BUBBLE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.FIRE_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.HORN_CORAL_WALL_FAN, chunksectionlayer1);
        p_448152_.put(Blocks.SEA_PICKLE, chunksectionlayer1);
        p_448152_.put(Blocks.CONDUIT, chunksectionlayer1);
        p_448152_.put(Blocks.BAMBOO_SAPLING, chunksectionlayer1);
        p_448152_.put(Blocks.BAMBOO, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_BAMBOO, chunksectionlayer1);
        p_448152_.put(Blocks.SCAFFOLDING, chunksectionlayer1);
        p_448152_.put(Blocks.STONECUTTER, chunksectionlayer1);
        p_448152_.put(Blocks.LANTERN, chunksectionlayer1);
        p_448152_.put(Blocks.SOUL_LANTERN, chunksectionlayer1);
        Blocks.COPPER_LANTERN.forEach(p_420869_ -> p_448152_.put(p_420869_, chunksectionlayer1));
        p_448152_.put(Blocks.CAMPFIRE, chunksectionlayer1);
        p_448152_.put(Blocks.SOUL_CAMPFIRE, chunksectionlayer1);
        p_448152_.put(Blocks.SWEET_BERRY_BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.WEEPING_VINES, chunksectionlayer1);
        p_448152_.put(Blocks.WEEPING_VINES_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.TWISTING_VINES, chunksectionlayer1);
        p_448152_.put(Blocks.TWISTING_VINES_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.NETHER_SPROUTS, chunksectionlayer1);
        p_448152_.put(Blocks.CRIMSON_FUNGUS, chunksectionlayer1);
        p_448152_.put(Blocks.WARPED_FUNGUS, chunksectionlayer1);
        p_448152_.put(Blocks.CRIMSON_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.WARPED_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CRIMSON_FUNGUS, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_WARPED_FUNGUS, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_CRIMSON_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.POTTED_WARPED_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.CRIMSON_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.WARPED_DOOR, chunksectionlayer1);
        p_448152_.put(Blocks.POINTED_DRIPSTONE, chunksectionlayer1);
        p_448152_.put(Blocks.SMALL_AMETHYST_BUD, chunksectionlayer1);
        p_448152_.put(Blocks.MEDIUM_AMETHYST_BUD, chunksectionlayer1);
        p_448152_.put(Blocks.LARGE_AMETHYST_BUD, chunksectionlayer1);
        p_448152_.put(Blocks.AMETHYST_CLUSTER, chunksectionlayer1);
        p_448152_.put(Blocks.CAVE_VINES, chunksectionlayer1);
        p_448152_.put(Blocks.CAVE_VINES_PLANT, chunksectionlayer1);
        p_448152_.put(Blocks.SPORE_BLOSSOM, chunksectionlayer1);
        p_448152_.put(Blocks.FLOWERING_AZALEA, chunksectionlayer1);
        p_448152_.put(Blocks.AZALEA, chunksectionlayer1);
        p_448152_.put(Blocks.PINK_PETALS, chunksectionlayer1);
        p_448152_.put(Blocks.WILDFLOWERS, chunksectionlayer1);
        p_448152_.put(Blocks.LEAF_LITTER, chunksectionlayer1);
        p_448152_.put(Blocks.BIG_DRIPLEAF, chunksectionlayer1);
        p_448152_.put(Blocks.BIG_DRIPLEAF_STEM, chunksectionlayer1);
        p_448152_.put(Blocks.SMALL_DRIPLEAF, chunksectionlayer1);
        p_448152_.put(Blocks.HANGING_ROOTS, chunksectionlayer1);
        p_448152_.put(Blocks.SCULK_SENSOR, chunksectionlayer1);
        p_448152_.put(Blocks.CALIBRATED_SCULK_SENSOR, chunksectionlayer1);
        p_448152_.put(Blocks.SCULK_VEIN, chunksectionlayer1);
        p_448152_.put(Blocks.SCULK_SHRIEKER, chunksectionlayer1);
        p_448152_.put(Blocks.MANGROVE_PROPAGULE, chunksectionlayer1);
        p_448152_.put(Blocks.FROGSPAWN, chunksectionlayer1);
        p_448152_.put(Blocks.COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.EXPOSED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.WEATHERED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.OXIDIZED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_EXPOSED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_WEATHERED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.WAXED_OXIDIZED_COPPER_GRATE, chunksectionlayer1);
        p_448152_.put(Blocks.FIREFLY_BUSH, chunksectionlayer1);
        p_448152_.put(Blocks.CACTUS_FLOWER, chunksectionlayer1);
        p_448152_.put(Blocks.BEACON, chunksectionlayer1);
        ChunkSectionLayer chunksectionlayer2 = ChunkSectionLayer.TRANSLUCENT;
        p_448152_.put(Blocks.ICE, chunksectionlayer2);
        p_448152_.put(Blocks.NETHER_PORTAL, chunksectionlayer2);
        p_448152_.put(Blocks.GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.WHITE_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.ORANGE_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.MAGENTA_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.LIGHT_BLUE_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.YELLOW_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.LIME_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.PINK_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.GRAY_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.LIGHT_GRAY_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.CYAN_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.PURPLE_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.BLUE_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.BROWN_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.GREEN_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.REDSTONE_WIRE, chunksectionlayer2);
        p_448152_.put(Blocks.RED_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.BLACK_STAINED_GLASS, chunksectionlayer2);
        p_448152_.put(Blocks.WHITE_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.ORANGE_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.MAGENTA_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.LIGHT_BLUE_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.YELLOW_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.LIME_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.PINK_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.GRAY_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.LIGHT_GRAY_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.CYAN_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.PURPLE_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.BLUE_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.BROWN_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.GREEN_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.RED_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.BLACK_STAINED_GLASS_PANE, chunksectionlayer2);
        p_448152_.put(Blocks.SLIME_BLOCK, chunksectionlayer2);
        p_448152_.put(Blocks.HONEY_BLOCK, chunksectionlayer2);
        p_448152_.put(Blocks.FROSTED_ICE, chunksectionlayer2);
        p_448152_.put(Blocks.BUBBLE_COLUMN, chunksectionlayer2);
        p_448152_.put(Blocks.TINTED_GLASS, chunksectionlayer2);
    });
    @Deprecated
    private static final Map<Fluid, ChunkSectionLayer> LAYER_BY_FLUID = Util.make(Maps.newHashMap(), p_404902_ -> {
        p_404902_.put(Fluids.FLOWING_WATER, ChunkSectionLayer.TRANSLUCENT);
        p_404902_.put(Fluids.WATER, ChunkSectionLayer.TRANSLUCENT);
    });
    private static boolean cutoutLeaves;
    private static final Collection<ChunkSectionLayer> CUTOUT_MIPPED;
    private static final Collection<ChunkSectionLayer> SOLID;
    private static final Map<Holder.Reference<Block>, Collection<ChunkSectionLayer>> BLOCK_RENDER_TYPES;
    private static final Map<Holder.Reference<Fluid>, ChunkSectionLayer> FLUID_RENDER_TYPES;

    @Deprecated
    public static ChunkSectionLayer getChunkRenderType(BlockState p_109283_) {
        Block block = p_109283_.getBlock();
        if (block instanceof LeavesBlock) {
            return cutoutLeaves ? ChunkSectionLayer.CUTOUT : ChunkSectionLayer.SOLID;
        }
        ChunkSectionLayer chunksectionlayer = TYPE_BY_BLOCK.get(block);
        return chunksectionlayer != null ? chunksectionlayer : ChunkSectionLayer.SOLID;
    }

    @Deprecated
    public static RenderType getMovingBlockRenderType(BlockState p_109294_) {
        Block block = p_109294_.getBlock();
        if (block instanceof LeavesBlock) {
            return cutoutLeaves ? RenderTypes.cutoutMovingBlock() : RenderTypes.solidMovingBlock();
        }
        ChunkSectionLayer chunksectionlayer = TYPE_BY_BLOCK.get(block);
        if (chunksectionlayer != null) {
            return switch (chunksectionlayer) {
                default -> throw new MatchException(null, null);
                case ChunkSectionLayer.SOLID -> RenderTypes.solidMovingBlock();
                case ChunkSectionLayer.CUTOUT -> RenderTypes.cutoutMovingBlock();
                case ChunkSectionLayer.TRANSLUCENT -> RenderTypes.translucentMovingBlock();
                case ChunkSectionLayer.TRIPWIRE -> RenderTypes.tripwireMovingBlock();
            };
        }
        return RenderTypes.solidMovingBlock();
    }

    @Deprecated
    public static RenderType getRenderType(BlockState p_364446_) {
        ChunkSectionLayer chunksectionlayer = ItemBlockRenderTypes.getChunkRenderType(p_364446_);
        return chunksectionlayer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentBlockItemSheet() : Sheets.cutoutBlockSheet();
    }

    public static ChunkSectionLayer getRenderLayer(FluidState p_109288_) {
        ChunkSectionLayer chunksectionlayer = FLUID_RENDER_TYPES.get(ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)p_109288_.getType()));
        return chunksectionlayer != null ? chunksectionlayer : ChunkSectionLayer.SOLID;
    }

    public static void setCutoutLeaves(boolean p_454762_) {
        cutoutLeaves = p_454762_;
    }

    public static boolean isFancy() {
        return cutoutLeaves;
    }

    public static Collection<ChunkSectionLayer> getRenderLayers(BlockState state) {
        Block block = state.getBlock();
        if (block instanceof LeavesBlock) {
            return cutoutLeaves ? CUTOUT_MIPPED : SOLID;
        }
        return BLOCK_RENDER_TYPES.get(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block));
    }

    public static void setRenderLayer(Block block, ChunkSectionLayer type) {
        ItemBlockRenderTypes.checkClientLoading();
        BLOCK_RENDER_TYPES.put(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block), EnumSet.of(type));
    }

    public static synchronized void setRenderLayer(Block block, ChunkSectionLayer first, ChunkSectionLayer ... others) {
        ItemBlockRenderTypes.checkClientLoading();
        BLOCK_RENDER_TYPES.put(ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block), EnumSet.of(first, others));
    }

    public static synchronized void setRenderLayer(Fluid fluid, ChunkSectionLayer type) {
        ItemBlockRenderTypes.checkClientLoading();
        FLUID_RENDER_TYPES.put(ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)fluid), type);
    }

    private static void checkClientLoading() {
        Preconditions.checkState((boolean)ClientModLoader.isLoading(), (Object)"Render layers can only be set during client loading! This might ideally be done from `FMLClientSetupEvent`.");
    }

    static {
        CUTOUT_MIPPED = EnumSet.of(ChunkSectionLayer.CUTOUT);
        SOLID = EnumSet.of(ChunkSectionLayer.SOLID);
        BLOCK_RENDER_TYPES = (Map)Util.make(new Object2ObjectOpenHashMap(TYPE_BY_BLOCK.size(), 0.5f), map -> {
            map.defaultReturnValue(SOLID);
            for (Map.Entry<Block, ChunkSectionLayer> entry : TYPE_BY_BLOCK.entrySet()) {
                map.put((Object)ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)entry.getKey()), EnumSet.of(entry.getValue()));
            }
        });
        FLUID_RENDER_TYPES = (Map)Util.make(new Object2ObjectOpenHashMap(LAYER_BY_FLUID.size(), 0.5f), map -> {
            map.defaultReturnValue((Object)ChunkSectionLayer.SOLID);
            for (Map.Entry<Fluid, ChunkSectionLayer> entry : LAYER_BY_FLUID.entrySet()) {
                map.put((Object)ForgeRegistries.FLUIDS.getDelegateOrThrow((Object)entry.getKey()), (Object)entry.getValue());
            }
        });
    }
}

