/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.effects.SpearAnimations;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.MapRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ItemInHandRenderer {
    private static final RenderType MAP_BACKGROUND = RenderTypes.text(Identifier.withDefaultNamespace("textures/map/map_background.png"));
    private static final RenderType MAP_BACKGROUND_CHECKERBOARD = RenderTypes.text(Identifier.withDefaultNamespace("textures/map/map_background_checkerboard.png"));
    private static final float ITEM_SWING_X_POS_SCALE = -0.4f;
    private static final float ITEM_SWING_Y_POS_SCALE = 0.2f;
    private static final float ITEM_SWING_Z_POS_SCALE = -0.2f;
    private static final float ITEM_HEIGHT_SCALE = -0.6f;
    private static final float ITEM_POS_X = 0.56f;
    private static final float ITEM_POS_Y = -0.52f;
    private static final float ITEM_POS_Z = -0.72f;
    private static final float ITEM_PRESWING_ROT_Y = 45.0f;
    private static final float ITEM_SWING_X_ROT_AMOUNT = -80.0f;
    private static final float ITEM_SWING_Y_ROT_AMOUNT = -20.0f;
    private static final float ITEM_SWING_Z_ROT_AMOUNT = -20.0f;
    private static final float EAT_JIGGLE_X_ROT_AMOUNT = 10.0f;
    private static final float EAT_JIGGLE_Y_ROT_AMOUNT = 90.0f;
    private static final float EAT_JIGGLE_Z_ROT_AMOUNT = 30.0f;
    private static final float EAT_JIGGLE_X_POS_SCALE = 0.6f;
    private static final float EAT_JIGGLE_Y_POS_SCALE = -0.5f;
    private static final float EAT_JIGGLE_Z_POS_SCALE = 0.0f;
    private static final double EAT_JIGGLE_EXPONENT = 27.0;
    private static final float EAT_EXTRA_JIGGLE_CUTOFF = 0.8f;
    private static final float EAT_EXTRA_JIGGLE_SCALE = 0.1f;
    private static final float ARM_SWING_X_POS_SCALE = -0.3f;
    private static final float ARM_SWING_Y_POS_SCALE = 0.4f;
    private static final float ARM_SWING_Z_POS_SCALE = -0.4f;
    private static final float ARM_SWING_Y_ROT_AMOUNT = 70.0f;
    private static final float ARM_SWING_Z_ROT_AMOUNT = -20.0f;
    private static final float ARM_HEIGHT_SCALE = -0.6f;
    private static final float ARM_POS_SCALE = 0.8f;
    private static final float ARM_POS_X = 0.8f;
    private static final float ARM_POS_Y = -0.75f;
    private static final float ARM_POS_Z = -0.9f;
    private static final float ARM_PRESWING_ROT_Y = 45.0f;
    private static final float ARM_PREROTATION_X_OFFSET = -1.0f;
    private static final float ARM_PREROTATION_Y_OFFSET = 3.6f;
    private static final float ARM_PREROTATION_Z_OFFSET = 3.5f;
    private static final float ARM_POSTROTATION_X_OFFSET = 5.6f;
    private static final int ARM_ROT_X = 200;
    private static final int ARM_ROT_Y = -135;
    private static final int ARM_ROT_Z = 120;
    private static final float MAP_SWING_X_POS_SCALE = -0.4f;
    private static final float MAP_SWING_Z_POS_SCALE = -0.2f;
    private static final float MAP_HANDS_POS_X = 0.0f;
    private static final float MAP_HANDS_POS_Y = 0.04f;
    private static final float MAP_HANDS_POS_Z = -0.72f;
    private static final float MAP_HANDS_HEIGHT_SCALE = -1.2f;
    private static final float MAP_HANDS_TILT_SCALE = -0.5f;
    private static final float MAP_PLAYER_PITCH_SCALE = 45.0f;
    private static final float MAP_HANDS_Z_ROT_AMOUNT = -85.0f;
    private static final float MAPHAND_X_ROT_AMOUNT = 45.0f;
    private static final float MAPHAND_Y_ROT_AMOUNT = 92.0f;
    private static final float MAPHAND_Z_ROT_AMOUNT = -41.0f;
    private static final float MAP_HAND_X_POS = 0.3f;
    private static final float MAP_HAND_Y_POS = -1.1f;
    private static final float MAP_HAND_Z_POS = 0.45f;
    private static final float MAP_SWING_X_ROT_AMOUNT = 20.0f;
    private static final float MAP_PRE_ROT_SCALE = 0.38f;
    private static final float MAP_GLOBAL_X_POS = -0.5f;
    private static final float MAP_GLOBAL_Y_POS = -0.5f;
    private static final float MAP_GLOBAL_Z_POS = 0.0f;
    private static final float MAP_FINAL_SCALE = 0.0078125f;
    private static final int MAP_BORDER = 7;
    private static final int MAP_HEIGHT = 128;
    private static final int MAP_WIDTH = 128;
    private static final float BOW_CHARGE_X_POS_SCALE = 0.0f;
    private static final float BOW_CHARGE_Y_POS_SCALE = 0.0f;
    private static final float BOW_CHARGE_Z_POS_SCALE = 0.04f;
    private static final float BOW_CHARGE_SHAKE_X_SCALE = 0.0f;
    private static final float BOW_CHARGE_SHAKE_Y_SCALE = 0.004f;
    private static final float BOW_CHARGE_SHAKE_Z_SCALE = 0.0f;
    private static final float BOW_CHARGE_Z_SCALE = 0.2f;
    private static final float BOW_MIN_SHAKE_CHARGE = 0.1f;
    private final Minecraft minecraft;
    private final MapRenderState mapRenderState = new MapRenderState();
    private ItemStack mainHandItem = ItemStack.EMPTY;
    private ItemStack offHandItem = ItemStack.EMPTY;
    private float mainHandHeight;
    private float oMainHandHeight;
    private float offHandHeight;
    private float oOffHandHeight;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemModelResolver itemModelResolver;

    public ItemInHandRenderer(Minecraft p_234241_, EntityRenderDispatcher p_234242_, ItemModelResolver p_376876_) {
        this.minecraft = p_234241_;
        this.entityRenderDispatcher = p_234242_;
        this.itemModelResolver = p_376876_;
    }

    public void renderItem(LivingEntity p_270072_, ItemStack p_270793_, ItemDisplayContext p_270837_, PoseStack p_270974_, SubmitNodeCollector p_429847_, int p_270103_) {
        if (!p_270793_.isEmpty()) {
            ItemStackRenderState itemstackrenderstate = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(itemstackrenderstate, p_270793_, p_270837_, p_270072_.level(), (ItemOwner)p_270072_, p_270072_.getId() + p_270837_.ordinal());
            itemstackrenderstate.submit(p_270974_, p_429847_, p_270103_, OverlayTexture.NO_OVERLAY, 0);
        }
    }

    private float calculateMapTilt(float p_109313_) {
        float f = 1.0f - p_109313_ / 45.0f + 0.1f;
        f = Mth.clamp(f, 0.0f, 1.0f);
        return -Mth.cos(f * (float)Math.PI) * 0.5f + 0.5f;
    }

    private void renderMapHand(PoseStack p_109362_, SubmitNodeCollector p_427410_, int p_109364_, HumanoidArm p_109365_) {
        AvatarRenderer<AbstractClientPlayer> avatarrenderer = this.entityRenderDispatcher.getPlayerRenderer(this.minecraft.player);
        p_109362_.pushPose();
        float f = p_109365_ == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        p_109362_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(92.0f));
        p_109362_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(45.0f));
        p_109362_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * -41.0f));
        p_109362_.translate(f * 0.3f, -1.1f, 0.45f);
        Identifier identifier = this.minecraft.player.getSkin().body().texturePath();
        if (p_109365_ == HumanoidArm.RIGHT) {
            avatarrenderer.renderRightHand(p_109362_, p_427410_, p_109364_, identifier, this.minecraft.player.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE));
        } else {
            avatarrenderer.renderLeftHand(p_109362_, p_427410_, p_109364_, identifier, this.minecraft.player.isModelPartShown(PlayerModelPart.LEFT_SLEEVE));
        }
        p_109362_.popPose();
    }

    private void renderOneHandedMap(PoseStack p_109354_, SubmitNodeCollector p_428648_, int p_109356_, float p_109357_, HumanoidArm p_109358_, float p_109359_, ItemStack p_109360_) {
        float f = p_109358_ == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        p_109354_.translate(f * 0.125f, -0.125f, 0.0f);
        if (!this.minecraft.player.isInvisible()) {
            p_109354_.pushPose();
            p_109354_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * 10.0f));
            this.renderPlayerArm(p_109354_, p_428648_, p_109356_, p_109357_, p_109359_, p_109358_);
            p_109354_.popPose();
        }
        p_109354_.pushPose();
        p_109354_.translate(f * 0.51f, -0.08f + p_109357_ * -1.2f, -0.75f);
        float f1 = Mth.sqrt(p_109359_);
        float f2 = Mth.sin(f1 * (float)Math.PI);
        float f3 = -0.5f * f2;
        float f4 = 0.4f * Mth.sin(f1 * ((float)Math.PI * 2));
        float f5 = -0.3f * Mth.sin(p_109359_ * (float)Math.PI);
        p_109354_.translate(f * f3, f4 - 0.3f * f2, f5);
        p_109354_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f2 * -45.0f));
        p_109354_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * f2 * -30.0f));
        this.renderMap(p_109354_, p_428648_, p_109356_, p_109360_);
        p_109354_.popPose();
    }

    private void renderTwoHandedMap(PoseStack p_109340_, SubmitNodeCollector p_425898_, int p_109342_, float p_109343_, float p_109344_, float p_109345_) {
        float f = Mth.sqrt(p_109345_);
        float f1 = -0.2f * Mth.sin(p_109345_ * (float)Math.PI);
        float f2 = -0.4f * Mth.sin(f * (float)Math.PI);
        p_109340_.translate(0.0f, -f1 / 2.0f, f2);
        float f3 = this.calculateMapTilt(p_109343_);
        p_109340_.translate(0.0f, 0.04f + p_109344_ * -1.2f + f3 * -0.5f, -0.72f);
        p_109340_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f3 * -85.0f));
        if (!this.minecraft.player.isInvisible()) {
            p_109340_.pushPose();
            p_109340_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            this.renderMapHand(p_109340_, p_425898_, p_109342_, HumanoidArm.RIGHT);
            this.renderMapHand(p_109340_, p_425898_, p_109342_, HumanoidArm.LEFT);
            p_109340_.popPose();
        }
        float f4 = Mth.sin(f * (float)Math.PI);
        p_109340_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f4 * 20.0f));
        p_109340_.scale(2.0f, 2.0f, 2.0f);
        this.renderMap(p_109340_, p_425898_, p_109342_, this.mainHandItem);
    }

    private void renderMap(PoseStack p_109367_, SubmitNodeCollector p_425019_, int p_109369_, ItemStack p_109370_) {
        p_109367_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        p_109367_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
        p_109367_.scale(0.38f, 0.38f, 0.38f);
        p_109367_.translate(-0.5f, -0.5f, 0.0f);
        p_109367_.scale(0.0078125f, 0.0078125f, 0.0078125f);
        MapId mapid = (MapId)p_109370_.get(DataComponents.MAP_ID);
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData(mapid, (Level)this.minecraft.level);
        RenderType rendertype = mapitemsaveddata == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD;
        p_425019_.submitCustomGeometry(p_109367_, rendertype, (p_431196_, p_422769_) -> {
            p_422769_.addVertex(p_431196_, -7.0f, 135.0f, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setLight(p_109369_);
            p_422769_.addVertex(p_431196_, 135.0f, 135.0f, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setLight(p_109369_);
            p_422769_.addVertex(p_431196_, 135.0f, -7.0f, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setLight(p_109369_);
            p_422769_.addVertex(p_431196_, -7.0f, -7.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setLight(p_109369_);
        });
        if (mapitemsaveddata != null) {
            MapRenderer maprenderer = this.minecraft.getMapRenderer();
            maprenderer.extractRenderState(mapid, mapitemsaveddata, this.mapRenderState);
            maprenderer.render(this.mapRenderState, p_109367_, p_425019_, false, p_109369_);
        }
    }

    private void renderPlayerArm(PoseStack p_109347_, SubmitNodeCollector p_428322_, int p_109349_, float p_109350_, float p_109351_, HumanoidArm p_109352_) {
        boolean flag = p_109352_ != HumanoidArm.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = Mth.sqrt(p_109351_);
        float f2 = -0.3f * Mth.sin(f1 * (float)Math.PI);
        float f3 = 0.4f * Mth.sin(f1 * ((float)Math.PI * 2));
        float f4 = -0.4f * Mth.sin(p_109351_ * (float)Math.PI);
        p_109347_.translate(f * (f2 + 0.64000005f), f3 + -0.6f + p_109350_ * -0.6f, f4 + -0.71999997f);
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * 45.0f));
        float f5 = Mth.sin(p_109351_ * p_109351_ * (float)Math.PI);
        float f6 = Mth.sin(f1 * (float)Math.PI);
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * f6 * 70.0f));
        p_109347_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * f5 * -20.0f));
        LocalPlayer abstractclientplayer = this.minecraft.player;
        p_109347_.translate(f * -1.0f, 3.6f, 3.5f);
        p_109347_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(f * 120.0f));
        p_109347_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(200.0f));
        p_109347_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f * -135.0f));
        p_109347_.translate(f * 5.6f, 0.0f, 0.0f);
        AvatarRenderer<AbstractClientPlayer> avatarrenderer = this.entityRenderDispatcher.getPlayerRenderer(abstractclientplayer);
        Identifier identifier = abstractclientplayer.getSkin().body().texturePath();
        if (flag) {
            avatarrenderer.renderRightHand(p_109347_, p_428322_, p_109349_, identifier, abstractclientplayer.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE));
        } else {
            avatarrenderer.renderLeftHand(p_109347_, p_428322_, p_109349_, identifier, abstractclientplayer.isModelPartShown(PlayerModelPart.LEFT_SLEEVE));
        }
    }

    private void applyEatTransform(PoseStack p_109331_, float p_109332_, HumanoidArm p_109333_, ItemStack p_109334_, Player p_343800_) {
        float f = (float)p_343800_.getUseItemRemainingTicks() - p_109332_ + 1.0f;
        float f1 = f / (float)p_109334_.getUseDuration(p_343800_);
        if (f1 < 0.8f) {
            float f2 = Mth.abs(Mth.cos(f / 4.0f * (float)Math.PI) * 0.1f);
            p_109331_.translate(0.0f, f2, 0.0f);
        }
        float f3 = 1.0f - (float)Math.pow(f1, 27.0);
        int i = p_109333_ == HumanoidArm.RIGHT ? 1 : -1;
        p_109331_.translate(f3 * 0.6f * (float)i, f3 * -0.5f, f3 * 0.0f);
        p_109331_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * f3 * 90.0f));
        p_109331_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f3 * 10.0f));
        p_109331_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)i * f3 * 30.0f));
    }

    private void applyBrushTransform(PoseStack p_273513_, float p_273245_, HumanoidArm p_273726_, Player p_344712_) {
        float f = p_344712_.getUseItemRemainingTicks() % 10;
        float f1 = f - p_273245_ + 1.0f;
        float f2 = 1.0f - f1 / 10.0f;
        float f3 = -90.0f;
        float f4 = 60.0f;
        float f5 = 150.0f;
        float f6 = -15.0f;
        int i = 2;
        float f7 = -15.0f + 75.0f * Mth.cos(f2 * 2.0f * (float)Math.PI);
        if (p_273726_ != HumanoidArm.RIGHT) {
            p_273513_.translate(0.1, 0.83, 0.35);
            p_273513_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-80.0f));
            p_273513_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
            p_273513_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f7));
            p_273513_.translate(-0.3, 0.22, 0.35);
        } else {
            p_273513_.translate(-0.25, 0.22, 0.35);
            p_273513_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-80.0f));
            p_273513_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            p_273513_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(0.0f));
            p_273513_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f7));
        }
    }

    private void applyItemArmAttackTransform(PoseStack p_109336_, HumanoidArm p_109337_, float p_109338_) {
        int i = p_109337_ == HumanoidArm.RIGHT ? 1 : -1;
        float f = Mth.sin(p_109338_ * p_109338_ * (float)Math.PI);
        p_109336_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * (45.0f + f * -20.0f)));
        float f1 = Mth.sin(Mth.sqrt(p_109338_) * (float)Math.PI);
        p_109336_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)i * f1 * -20.0f));
        p_109336_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f1 * -80.0f));
        p_109336_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * -45.0f));
    }

    private void applyItemArmTransform(PoseStack p_109383_, HumanoidArm p_109384_, float p_109385_) {
        int i = p_109384_ == HumanoidArm.RIGHT ? 1 : -1;
        p_109383_.translate((float)i * 0.56f, -0.52f + p_109385_ * -0.6f, -0.72f);
    }

    public void renderHandsWithItems(float p_109315_, PoseStack p_109316_, SubmitNodeCollector p_424174_, LocalPlayer p_109318_, int p_109319_) {
        float f7;
        float f6;
        float f5;
        float f4;
        float f = p_109318_.getAttackAnim(p_109315_);
        InteractionHand interactionhand = (InteractionHand)((Object)MoreObjects.firstNonNull((Object)((Object)p_109318_.swingingArm), (Object)((Object)InteractionHand.MAIN_HAND)));
        float f1 = p_109318_.getXRot(p_109315_);
        HandRenderSelection iteminhandrenderer$handrenderselection = ItemInHandRenderer.evaluateWhichHandsToRender(p_109318_);
        float f2 = Mth.lerp(p_109315_, p_109318_.xBobO, p_109318_.xBob);
        float f3 = Mth.lerp(p_109315_, p_109318_.yBobO, p_109318_.yBob);
        p_109316_.mulPose((Quaternionfc)Axis.XP.rotationDegrees((p_109318_.getViewXRot(p_109315_) - f2) * 0.1f));
        p_109316_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((p_109318_.getViewYRot(p_109315_) - f3) * 0.1f));
        if (iteminhandrenderer$handrenderselection.renderMainHand && !ForgeHooksClient.renderSpecificFirstPersonHand((InteractionHand)InteractionHand.MAIN_HAND, (PoseStack)p_109316_, (SubmitNodeCollector)p_424174_, (int)p_109319_, (float)p_109315_, (float)f1, (float)(f4 = interactionhand == InteractionHand.MAIN_HAND ? f : 0.0f), (float)(f5 = this.itemModelResolver.swapAnimationScale(this.mainHandItem) * (1.0f - Mth.lerp(p_109315_, this.oMainHandHeight, this.mainHandHeight))), (ItemStack)this.mainHandItem)) {
            this.renderArmWithItem(p_109318_, p_109315_, f1, InteractionHand.MAIN_HAND, f4, this.mainHandItem, f5, p_109316_, p_424174_, p_109319_);
        }
        if (iteminhandrenderer$handrenderselection.renderOffHand && !ForgeHooksClient.renderSpecificFirstPersonHand((InteractionHand)InteractionHand.OFF_HAND, (PoseStack)p_109316_, (SubmitNodeCollector)p_424174_, (int)p_109319_, (float)p_109315_, (float)f1, (float)(f6 = interactionhand == InteractionHand.OFF_HAND ? f : 0.0f), (float)(f7 = this.itemModelResolver.swapAnimationScale(this.offHandItem) * (1.0f - Mth.lerp(p_109315_, this.oOffHandHeight, this.offHandHeight))), (ItemStack)this.offHandItem)) {
            this.renderArmWithItem(p_109318_, p_109315_, f1, InteractionHand.OFF_HAND, f6, this.offHandItem, f7, p_109316_, p_424174_, p_109319_);
        }
        this.minecraft.gameRenderer.getFeatureRenderDispatcher().renderAllFeatures();
        this.minecraft.renderBuffers().bufferSource().endBatch();
    }

    @VisibleForTesting
    static HandRenderSelection evaluateWhichHandsToRender(LocalPlayer p_172915_) {
        boolean flag1;
        ItemStack itemstack = p_172915_.getMainHandItem();
        ItemStack itemstack1 = p_172915_.getOffhandItem();
        boolean flag = itemstack.is(Items.BOW) || itemstack1.is(Items.BOW);
        boolean bl = flag1 = itemstack.is(Items.CROSSBOW) || itemstack1.is(Items.CROSSBOW);
        if (!flag && !flag1) {
            return HandRenderSelection.RENDER_BOTH_HANDS;
        }
        if (p_172915_.isUsingItem()) {
            return ItemInHandRenderer.selectionUsingItemWhileHoldingBowLike(p_172915_);
        }
        return ItemInHandRenderer.isChargedCrossbow(itemstack) ? HandRenderSelection.RENDER_MAIN_HAND_ONLY : HandRenderSelection.RENDER_BOTH_HANDS;
    }

    private static HandRenderSelection selectionUsingItemWhileHoldingBowLike(LocalPlayer p_172917_) {
        ItemStack itemstack = p_172917_.getUseItem();
        InteractionHand interactionhand = p_172917_.getUsedItemHand();
        if (!itemstack.is(Items.BOW) && !itemstack.is(Items.CROSSBOW)) {
            return interactionhand == InteractionHand.MAIN_HAND && ItemInHandRenderer.isChargedCrossbow(p_172917_.getOffhandItem()) ? HandRenderSelection.RENDER_MAIN_HAND_ONLY : HandRenderSelection.RENDER_BOTH_HANDS;
        }
        return HandRenderSelection.onlyForHand(interactionhand);
    }

    private static boolean isChargedCrossbow(ItemStack p_172913_) {
        return p_172913_.is(Items.CROSSBOW) && CrossbowItem.isCharged(p_172913_);
    }

    private void renderArmWithItem(AbstractClientPlayer p_109372_, float p_109373_, float p_109374_, InteractionHand p_109375_, float p_109376_, ItemStack p_109377_, float p_109378_, PoseStack p_109379_, SubmitNodeCollector p_425151_, int p_109381_) {
        block29: {
            block31: {
                boolean flag3;
                block34: {
                    int j;
                    HumanoidArm humanoidarm;
                    block35: {
                        block33: {
                            int i;
                            boolean flag;
                            block32: {
                                block30: {
                                    if (p_109372_.isScoping()) break block29;
                                    flag = p_109375_ == InteractionHand.MAIN_HAND;
                                    humanoidarm = flag ? p_109372_.getMainArm() : p_109372_.getMainArm().getOpposite();
                                    p_109379_.pushPose();
                                    if (!p_109377_.isEmpty()) break block30;
                                    if (flag && !p_109372_.isInvisible()) {
                                        this.renderPlayerArm(p_109379_, p_425151_, p_109381_, p_109378_, p_109376_, humanoidarm);
                                    }
                                    break block31;
                                }
                                if (!p_109377_.has(DataComponents.MAP_ID)) break block32;
                                if (flag && this.offHandItem.isEmpty()) {
                                    this.renderTwoHandedMap(p_109379_, p_425151_, p_109381_, p_109374_, p_109378_, p_109376_);
                                } else {
                                    this.renderOneHandedMap(p_109379_, p_425151_, p_109381_, p_109378_, humanoidarm, p_109376_, p_109377_);
                                }
                                break block31;
                            }
                            if (!(p_109377_.getItem() instanceof CrossbowItem)) break block33;
                            this.applyItemArmTransform(p_109379_, humanoidarm, p_109378_);
                            boolean flag1 = CrossbowItem.isCharged(p_109377_);
                            boolean flag2 = humanoidarm == HumanoidArm.RIGHT;
                            int n = i = flag2 ? 1 : -1;
                            if (p_109372_.isUsingItem() && p_109372_.getUseItemRemainingTicks() > 0 && p_109372_.getUsedItemHand() == p_109375_ && !flag1) {
                                p_109379_.translate((float)i * -0.4785682f, -0.094387f, 0.05731531f);
                                p_109379_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-11.935f));
                                p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * 65.3f));
                                p_109379_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)i * -9.785f));
                                float f = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                                float f1 = f / (float)CrossbowItem.getChargeDuration(p_109377_, p_109372_);
                                if (f1 > 1.0f) {
                                    f1 = 1.0f;
                                }
                                if (f1 > 0.1f) {
                                    float f2 = Mth.sin((f - 0.1f) * 1.3f);
                                    float f3 = f1 - 0.1f;
                                    float f4 = f2 * f3;
                                    p_109379_.translate(f4 * 0.0f, f4 * 0.004f, f4 * 0.0f);
                                }
                                p_109379_.translate(f1 * 0.0f, f1 * 0.0f, f1 * 0.04f);
                                p_109379_.scale(1.0f, 1.0f, 1.0f + f1 * 0.2f);
                                p_109379_.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)i * 45.0f));
                            } else {
                                this.swingArm(p_109376_, p_109379_, i, humanoidarm);
                                if (flag1 && p_109376_ < 0.001f && flag) {
                                    p_109379_.translate((float)i * -0.641864f, 0.0f, 0.0f);
                                    p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)i * 10.0f));
                                }
                            }
                            this.renderItem(p_109372_, p_109377_, flag2 ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, p_109379_, p_425151_, p_109381_);
                            break block31;
                        }
                        flag3 = humanoidarm == HumanoidArm.RIGHT;
                        int n = j = flag3 ? 1 : -1;
                        if (IClientItemExtensions.of((ItemStack)p_109377_).applyForgeHandTransform(p_109379_, this.minecraft.player, humanoidarm, p_109377_, p_109373_, p_109378_, p_109376_)) break block34;
                        if (!p_109372_.isUsingItem() || p_109372_.getUseItemRemainingTicks() <= 0 || p_109372_.getUsedItemHand() != p_109375_) break block35;
                        ItemUseAnimation itemuseanimation = p_109377_.getUseAnimation();
                        if (!itemuseanimation.hasCustomArmTransform()) {
                            this.applyItemArmTransform(p_109379_, humanoidarm, p_109378_);
                        }
                        switch (itemuseanimation) {
                            default: {
                                break;
                            }
                            case EAT: 
                            case DRINK: {
                                this.applyEatTransform(p_109379_, p_109373_, humanoidarm, p_109377_, p_109372_);
                                this.applyItemArmTransform(p_109379_, humanoidarm, p_109378_);
                                break;
                            }
                            case BLOCK: {
                                if (!(p_109377_.getItem() instanceof ShieldItem)) {
                                    p_109379_.translate((float)j * -0.14142136f, 0.08f, 0.14142136f);
                                    p_109379_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-102.25f));
                                    p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)j * 13.365f));
                                    p_109379_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * 78.05f));
                                    break;
                                }
                                break block34;
                            }
                            case BOW: {
                                p_109379_.translate((float)j * -0.2785682f, 0.18344387f, 0.15731531f);
                                p_109379_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-13.935f));
                                p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)j * 35.3f));
                                p_109379_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * -9.785f));
                                float f7 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                                float f9 = f7 / 20.0f;
                                f9 = (f9 * f9 + f9 * 2.0f) / 3.0f;
                                if (f9 > 1.0f) {
                                    f9 = 1.0f;
                                }
                                if (f9 > 0.1f) {
                                    float f11 = Mth.sin((f7 - 0.1f) * 1.3f);
                                    float f13 = f9 - 0.1f;
                                    float f15 = f11 * f13;
                                    p_109379_.translate(f15 * 0.0f, f15 * 0.004f, f15 * 0.0f);
                                }
                                p_109379_.translate(f9 * 0.0f, f9 * 0.0f, f9 * 0.04f);
                                p_109379_.scale(1.0f, 1.0f, 1.0f + f9 * 0.2f);
                                p_109379_.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)j * 45.0f));
                                break;
                            }
                            case TRIDENT: {
                                p_109379_.translate((float)j * -0.5f, 0.7f, 0.1f);
                                p_109379_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-55.0f));
                                p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)j * 35.3f));
                                p_109379_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * -9.785f));
                                float f6 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                                float f8 = f6 / 10.0f;
                                if (f8 > 1.0f) {
                                    f8 = 1.0f;
                                }
                                if (f8 > 0.1f) {
                                    float f10 = Mth.sin((f6 - 0.1f) * 1.3f);
                                    float f12 = f8 - 0.1f;
                                    float f14 = f10 * f12;
                                    p_109379_.translate(f14 * 0.0f, f14 * 0.004f, f14 * 0.0f);
                                }
                                p_109379_.translate(0.0f, 0.0f, f8 * 0.2f);
                                p_109379_.scale(1.0f, 1.0f, 1.0f + f8 * 0.2f);
                                p_109379_.mulPose((Quaternionfc)Axis.YN.rotationDegrees((float)j * 45.0f));
                                break;
                            }
                            case BRUSH: {
                                this.applyBrushTransform(p_109379_, p_109373_, humanoidarm, p_109372_);
                                break;
                            }
                            case BUNDLE: {
                                this.swingArm(p_109376_, p_109379_, j, humanoidarm);
                                break;
                            }
                            case SPEAR: {
                                p_109379_.translate((float)j * 0.56f, -0.52f, -0.72f);
                                float f5 = (float)p_109377_.getUseDuration(p_109372_) - ((float)p_109372_.getUseItemRemainingTicks() - p_109373_ + 1.0f);
                                SpearAnimations.firstPersonUse((float)p_109372_.getTicksSinceLastKineticHitFeedback(p_109373_), (PoseStack)p_109379_, (float)f5, (HumanoidArm)humanoidarm, (ItemStack)p_109377_);
                                break;
                            }
                        }
                        break block34;
                    }
                    if (p_109372_.isAutoSpinAttack()) {
                        this.applyItemArmTransform(p_109379_, humanoidarm, p_109378_);
                        p_109379_.translate((float)j * -0.4f, 0.8f, 0.3f);
                        p_109379_.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)j * 65.0f));
                        p_109379_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * -85.0f));
                    } else {
                        this.applyItemArmTransform(p_109379_, humanoidarm, p_109378_);
                        switch (p_109377_.getSwingAnimation().type()) {
                            default: {
                                break;
                            }
                            case WHACK: {
                                this.swingArm(p_109376_, p_109379_, j, humanoidarm);
                                break;
                            }
                            case STAB: {
                                SpearAnimations.firstPersonAttack((float)p_109376_, (PoseStack)p_109379_, (int)j, (HumanoidArm)humanoidarm);
                            }
                        }
                    }
                }
                this.renderItem(p_109372_, p_109377_, flag3 ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, p_109379_, p_425151_, p_109381_);
            }
            p_109379_.popPose();
        }
    }

    private void swingArm(float p_376030_, PoseStack p_378498_, int p_375719_, HumanoidArm p_377471_) {
        float f = -0.4f * Mth.sin(Mth.sqrt(p_376030_) * (float)Math.PI);
        float f1 = 0.2f * Mth.sin(Mth.sqrt(p_376030_) * ((float)Math.PI * 2));
        float f2 = -0.2f * Mth.sin(p_376030_ * (float)Math.PI);
        p_378498_.translate((float)p_375719_ * f, f1, f2);
        this.applyItemArmAttackTransform(p_378498_, p_377471_, p_376030_);
    }

    private boolean shouldInstantlyReplaceVisibleItem(ItemStack p_376473_, ItemStack p_378754_) {
        return ItemStack.matchesIgnoringComponents(p_376473_, p_378754_, DataComponentType::ignoreSwapAnimation) ? true : !this.itemModelResolver.shouldPlaySwapAnimation(p_378754_);
    }

    public void tick() {
        this.oMainHandHeight = this.mainHandHeight;
        this.oOffHandHeight = this.offHandHeight;
        LocalPlayer localplayer = this.minecraft.player;
        ItemStack itemstack = localplayer.getMainHandItem();
        ItemStack itemstack1 = localplayer.getOffhandItem();
        if (this.shouldInstantlyReplaceVisibleItem(this.mainHandItem, itemstack)) {
            this.mainHandItem = itemstack;
        }
        if (this.shouldInstantlyReplaceVisibleItem(this.offHandItem, itemstack1)) {
            this.offHandItem = itemstack1;
        }
        if (localplayer.isHandsBusy()) {
            this.mainHandHeight = Mth.clamp(this.mainHandHeight - 0.4f, 0.0f, 1.0f);
            this.offHandHeight = Mth.clamp(this.offHandHeight - 0.4f, 0.0f, 1.0f);
        } else {
            float f = localplayer.getItemSwapScale(1.0f);
            boolean requipM = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.mainHandItem, (ItemStack)itemstack, (int)localplayer.getInventory().getSelectedSlot());
            boolean requipO = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.offHandItem, (ItemStack)itemstack1, (int)-1);
            if (!requipM && this.mainHandItem != itemstack) {
                this.mainHandItem = itemstack;
            }
            if (!requipO && this.offHandItem != itemstack1) {
                this.offHandItem = itemstack1;
            }
            float f1 = requipM ? 0.0f : f * f * f;
            float f2 = requipO ? 0.0f : 1.0f;
            this.mainHandHeight += Mth.clamp(f1 - this.mainHandHeight, -0.4f, 0.4f);
            this.offHandHeight += Mth.clamp(f2 - this.offHandHeight, -0.4f, 0.4f);
        }
        if (this.mainHandHeight < 0.1f) {
            this.mainHandItem = itemstack;
        }
        if (this.offHandHeight < 0.1f) {
            this.offHandItem = itemstack1;
        }
    }

    public void itemUsed(InteractionHand p_109321_) {
        if (p_109321_ == InteractionHand.MAIN_HAND) {
            this.mainHandHeight = 0.0f;
        } else {
            this.offHandHeight = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @VisibleForTesting
    static enum HandRenderSelection {
        RENDER_BOTH_HANDS(true, true),
        RENDER_MAIN_HAND_ONLY(true, false),
        RENDER_OFF_HAND_ONLY(false, true);

        final boolean renderMainHand;
        final boolean renderOffHand;

        private HandRenderSelection(boolean p_172928_, boolean p_172929_) {
            this.renderMainHand = p_172928_;
            this.renderOffHand = p_172929_;
        }

        public static HandRenderSelection onlyForHand(InteractionHand p_172932_) {
            return p_172932_ == InteractionHand.MAIN_HAND ? RENDER_MAIN_HAND_ONLY : RENDER_OFF_HAND_ONLY;
        }
    }
}

