/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;

@OnlyIn(value=Dist.CLIENT)
public class LiquidBlockRenderer {
    private static final float MAX_FLUID_HEIGHT = 0.8888889f;
    private final TextureAtlasSprite lavaStill;
    private final TextureAtlasSprite lavaFlowing;
    private final TextureAtlasSprite waterStill;
    private final TextureAtlasSprite waterFlowing;
    private final TextureAtlasSprite waterOverlay;

    public LiquidBlockRenderer(MaterialSet p_451072_) {
        this.lavaStill = p_451072_.get(ModelBakery.LAVA_STILL);
        this.lavaFlowing = p_451072_.get(ModelBakery.LAVA_FLOW);
        this.waterStill = p_451072_.get(ModelBakery.WATER_STILL);
        this.waterFlowing = p_451072_.get(ModelBakery.WATER_FLOW);
        this.waterOverlay = p_451072_.get(ModelBakery.WATER_OVERLAY);
    }

    private static boolean isNeighborSameFluid(FluidState p_203186_, FluidState p_203187_) {
        return p_203187_.getType().isSame(p_203186_.getType());
    }

    private static boolean isFaceOccludedByState(Direction p_110980_, float p_110981_, BlockState p_110983_) {
        VoxelShape voxelshape = p_110983_.getFaceOcclusionShape(p_110980_.getOpposite());
        if (voxelshape == Shapes.empty()) {
            return false;
        }
        if (voxelshape == Shapes.block()) {
            boolean flag = p_110981_ == 1.0f;
            return p_110980_ != Direction.UP || flag;
        }
        VoxelShape voxelshape1 = Shapes.box(0.0, 0.0, 0.0, 1.0, p_110981_, 1.0);
        return Shapes.blockOccludes(voxelshape1, voxelshape, p_110980_);
    }

    private static boolean isFaceOccludedByNeighbor(Direction p_203182_, float p_203183_, BlockState p_203184_) {
        return LiquidBlockRenderer.isFaceOccludedByState(p_203182_, p_203183_, p_203184_);
    }

    private static boolean isFaceOccludedBySelf(BlockState p_110962_, Direction p_110963_) {
        return LiquidBlockRenderer.isFaceOccludedByState(p_110963_.getOpposite(), 1.0f, p_110962_);
    }

    public static boolean shouldRenderFace(FluidState p_203169_, BlockState p_203170_, Direction p_203171_, FluidState p_203172_) {
        return !LiquidBlockRenderer.isFaceOccludedBySelf(p_203170_, p_203171_) && !LiquidBlockRenderer.isNeighborSameFluid(p_203169_, p_203172_);
    }

    public void tesselate(BlockAndTintGetter p_234370_, BlockPos p_234371_, VertexConsumer p_234372_, BlockState p_234373_, FluidState p_234374_) {
        boolean flag = p_234374_.is(FluidTags.LAVA);
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)p_234370_, (BlockPos)p_234371_, (FluidState)p_234374_);
        TextureAtlasSprite textureatlassprite = sprites[0];
        TextureAtlasSprite textureatlassprite1 = sprites[1];
        int i = IClientFluidTypeExtensions.of((FluidState)p_234374_).getTintColor(p_234374_, p_234370_, p_234371_);
        float alpha = (float)(i >> 24 & 0xFF) / 255.0f;
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        BlockState blockstate = p_234370_.getBlockState(p_234371_.relative(Direction.DOWN));
        FluidState fluidstate = blockstate.getFluidState();
        BlockState blockstate1 = p_234370_.getBlockState(p_234371_.relative(Direction.UP));
        FluidState fluidstate1 = blockstate1.getFluidState();
        BlockState blockstate2 = p_234370_.getBlockState(p_234371_.relative(Direction.NORTH));
        FluidState fluidstate2 = blockstate2.getFluidState();
        BlockState blockstate3 = p_234370_.getBlockState(p_234371_.relative(Direction.SOUTH));
        FluidState fluidstate3 = blockstate3.getFluidState();
        BlockState blockstate4 = p_234370_.getBlockState(p_234371_.relative(Direction.WEST));
        FluidState fluidstate4 = blockstate4.getFluidState();
        BlockState blockstate5 = p_234370_.getBlockState(p_234371_.relative(Direction.EAST));
        FluidState fluidstate5 = blockstate5.getFluidState();
        boolean flag1 = !LiquidBlockRenderer.isNeighborSameFluid(p_234374_, fluidstate1);
        boolean flag2 = LiquidBlockRenderer.shouldRenderFace(p_234374_, p_234373_, Direction.DOWN, fluidstate) && !LiquidBlockRenderer.isFaceOccludedByNeighbor(Direction.DOWN, 0.8888889f, blockstate);
        boolean flag3 = LiquidBlockRenderer.shouldRenderFace(p_234374_, p_234373_, Direction.NORTH, fluidstate2);
        boolean flag4 = LiquidBlockRenderer.shouldRenderFace(p_234374_, p_234373_, Direction.SOUTH, fluidstate3);
        boolean flag5 = LiquidBlockRenderer.shouldRenderFace(p_234374_, p_234373_, Direction.WEST, fluidstate4);
        boolean flag6 = LiquidBlockRenderer.shouldRenderFace(p_234374_, p_234373_, Direction.EAST, fluidstate5);
        if (flag1 || flag2 || flag6 || flag5 || flag3 || flag4) {
            float f16;
            float f10;
            float f9;
            float f8;
            float f7;
            float f3 = p_234370_.getShade(Direction.DOWN, true);
            float f4 = p_234370_.getShade(Direction.UP, true);
            float f5 = p_234370_.getShade(Direction.NORTH, true);
            float f6 = p_234370_.getShade(Direction.WEST, true);
            Fluid fluid = p_234374_.getType();
            float f11 = this.getHeight(p_234370_, fluid, p_234371_, p_234373_, p_234374_);
            if (f11 >= 1.0f) {
                f7 = 1.0f;
                f8 = 1.0f;
                f9 = 1.0f;
                f10 = 1.0f;
            } else {
                float f12 = this.getHeight(p_234370_, fluid, p_234371_.north(), blockstate2, fluidstate2);
                float f13 = this.getHeight(p_234370_, fluid, p_234371_.south(), blockstate3, fluidstate3);
                float f14 = this.getHeight(p_234370_, fluid, p_234371_.east(), blockstate5, fluidstate5);
                float f15 = this.getHeight(p_234370_, fluid, p_234371_.west(), blockstate4, fluidstate4);
                f7 = this.calculateAverageHeight(p_234370_, fluid, f11, f12, f14, p_234371_.relative(Direction.NORTH).relative(Direction.EAST));
                f8 = this.calculateAverageHeight(p_234370_, fluid, f11, f12, f15, p_234371_.relative(Direction.NORTH).relative(Direction.WEST));
                f9 = this.calculateAverageHeight(p_234370_, fluid, f11, f13, f14, p_234371_.relative(Direction.SOUTH).relative(Direction.EAST));
                f10 = this.calculateAverageHeight(p_234370_, fluid, f11, f13, f15, p_234371_.relative(Direction.SOUTH).relative(Direction.WEST));
            }
            float f37 = p_234371_.getX() & 0xF;
            float f38 = p_234371_.getY() & 0xF;
            float f39 = p_234371_.getZ() & 0xF;
            float f40 = 0.001f;
            float f12 = f16 = flag2 ? 0.001f : 0.0f;
            if (flag1 && !LiquidBlockRenderer.isFaceOccludedByNeighbor(Direction.UP, Math.min(Math.min(f8, f10), Math.min(f9, f7)), blockstate1)) {
                float f24;
                float f20;
                float f23;
                float f19;
                float f22;
                float f18;
                float f21;
                float f17;
                f8 -= 0.001f;
                f10 -= 0.001f;
                f9 -= 0.001f;
                f7 -= 0.001f;
                Vec3 vec3 = p_234374_.getFlow(p_234370_, p_234371_);
                if (vec3.x == 0.0 && vec3.z == 0.0) {
                    f17 = textureatlassprite.getU(0.0f);
                    f21 = textureatlassprite.getV(0.0f);
                    f18 = f17;
                    f22 = textureatlassprite.getV(1.0f);
                    f19 = textureatlassprite.getU(1.0f);
                    f23 = f22;
                    f20 = f19;
                    f24 = f21;
                } else {
                    float f25 = (float)Mth.atan2(vec3.z, vec3.x) - 1.5707964f;
                    float f26 = Mth.sin(f25) * 0.25f;
                    float f27 = Mth.cos(f25) * 0.25f;
                    float f28 = 0.5f;
                    f17 = textureatlassprite1.getU(0.5f + (-f27 - f26));
                    f21 = textureatlassprite1.getV(0.5f + (-f27 + f26));
                    f18 = textureatlassprite1.getU(0.5f + (-f27 + f26));
                    f22 = textureatlassprite1.getV(0.5f + (f27 + f26));
                    f19 = textureatlassprite1.getU(0.5f + (f27 + f26));
                    f23 = textureatlassprite1.getV(0.5f + (f27 - f26));
                    f20 = textureatlassprite1.getU(0.5f + (f27 - f26));
                    f24 = textureatlassprite1.getV(0.5f + (-f27 - f26));
                }
                int l = this.getLightColor(p_234370_, p_234371_);
                float f54 = f4 * f;
                float f55 = f4 * f1;
                float f56 = f4 * f2;
                this.vertex(p_234372_, f37 + 0.0f, f38 + f8, f39 + 0.0f, f54, f55, f56, f17, f21, l, alpha);
                this.vertex(p_234372_, f37 + 0.0f, f38 + f10, f39 + 1.0f, f54, f55, f56, f18, f22, l, alpha);
                this.vertex(p_234372_, f37 + 1.0f, f38 + f9, f39 + 1.0f, f54, f55, f56, f19, f23, l, alpha);
                this.vertex(p_234372_, f37 + 1.0f, f38 + f7, f39 + 0.0f, f54, f55, f56, f20, f24, l, alpha);
                if (p_234374_.shouldRenderBackwardUpFace(p_234370_, p_234371_.above())) {
                    this.vertex(p_234372_, f37 + 0.0f, f38 + f8, f39 + 0.0f, f54, f55, f56, f17, f21, l, alpha);
                    this.vertex(p_234372_, f37 + 1.0f, f38 + f7, f39 + 0.0f, f54, f55, f56, f20, f24, l, alpha);
                    this.vertex(p_234372_, f37 + 1.0f, f38 + f9, f39 + 1.0f, f54, f55, f56, f19, f23, l, alpha);
                    this.vertex(p_234372_, f37 + 0.0f, f38 + f10, f39 + 1.0f, f54, f55, f56, f18, f22, l, alpha);
                }
            }
            if (flag2) {
                float f41 = textureatlassprite.getU0();
                float f42 = textureatlassprite.getU1();
                float f43 = textureatlassprite.getV0();
                float f44 = textureatlassprite.getV1();
                int k = this.getLightColor(p_234370_, p_234371_.below());
                float f47 = f3 * f;
                float f49 = f3 * f1;
                float f51 = f3 * f2;
                this.vertex(p_234372_, f37, f38 + f16, f39 + 1.0f, f47, f49, f51, f41, f44, k, alpha);
                this.vertex(p_234372_, f37, f38 + f16, f39, f47, f49, f51, f41, f43, k, alpha);
                this.vertex(p_234372_, f37 + 1.0f, f38 + f16, f39, f47, f49, f51, f42, f43, k, alpha);
                this.vertex(p_234372_, f37 + 1.0f, f38 + f16, f39 + 1.0f, f47, f49, f51, f42, f44, k, alpha);
            }
            int j = this.getLightColor(p_234370_, p_234371_);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                float f53;
                float f50;
                float f52;
                float f48;
                float f46;
                float f45;
                if (!(switch (direction) {
                    case Direction.NORTH -> {
                        f45 = f8;
                        f46 = f7;
                        f48 = f37;
                        f52 = f37 + 1.0f;
                        f50 = f39 + 0.001f;
                        f53 = f39 + 0.001f;
                        yield flag3;
                    }
                    case Direction.SOUTH -> {
                        f45 = f9;
                        f46 = f10;
                        f48 = f37 + 1.0f;
                        f52 = f37;
                        f50 = f39 + 1.0f - 0.001f;
                        f53 = f39 + 1.0f - 0.001f;
                        yield flag4;
                    }
                    case Direction.WEST -> {
                        f45 = f10;
                        f46 = f8;
                        f48 = f37 + 0.001f;
                        f52 = f37 + 0.001f;
                        f50 = f39 + 1.0f;
                        f53 = f39;
                        yield flag5;
                    }
                    default -> {
                        f45 = f7;
                        f46 = f9;
                        f48 = f37 + 1.0f - 0.001f;
                        f52 = f37 + 1.0f - 0.001f;
                        f50 = f39;
                        f53 = f39 + 1.0f;
                        yield flag6;
                    }
                }) || LiquidBlockRenderer.isFaceOccludedByNeighbor(direction, Math.max(f45, f46), p_234370_.getBlockState(p_234371_.relative(direction)))) continue;
                BlockPos blockpos = p_234371_.relative(direction);
                TextureAtlasSprite textureatlassprite2 = textureatlassprite1;
                if (sprites[2] != null && p_234370_.getBlockState(blockpos).shouldDisplayFluidOverlay(p_234370_, blockpos, p_234374_)) {
                    textureatlassprite2 = sprites[2];
                }
                float f57 = textureatlassprite2.getU(0.0f);
                float f29 = textureatlassprite2.getU(0.5f);
                float f30 = textureatlassprite2.getV((1.0f - f45) * 0.5f);
                float f31 = textureatlassprite2.getV((1.0f - f46) * 0.5f);
                float f32 = textureatlassprite2.getV(0.5f);
                float f33 = direction.getAxis() == Direction.Axis.Z ? f5 : f6;
                float f34 = f4 * f33 * f;
                float f35 = f4 * f33 * f1;
                float f36 = f4 * f33 * f2;
                this.vertex(p_234372_, f48, f38 + f45, f50, f34, f35, f36, f57, f30, j, alpha);
                this.vertex(p_234372_, f52, f38 + f46, f53, f34, f35, f36, f29, f31, j, alpha);
                this.vertex(p_234372_, f52, f38 + f16, f53, f34, f35, f36, f29, f32, j, alpha);
                this.vertex(p_234372_, f48, f38 + f16, f50, f34, f35, f36, f57, f32, j, alpha);
                if (textureatlassprite2 == this.waterOverlay) continue;
                this.vertex(p_234372_, f48, f38 + f16, f50, f34, f35, f36, f57, f32, j, alpha);
                this.vertex(p_234372_, f52, f38 + f16, f53, f34, f35, f36, f29, f32, j, alpha);
                this.vertex(p_234372_, f52, f38 + f46, f53, f34, f35, f36, f29, f31, j, alpha);
                this.vertex(p_234372_, f48, f38 + f45, f50, f34, f35, f36, f57, f30, j, alpha);
            }
        }
    }

    private float calculateAverageHeight(BlockAndTintGetter p_203150_, Fluid p_203151_, float p_203152_, float p_203153_, float p_203154_, BlockPos p_203155_) {
        if (!(p_203154_ >= 1.0f) && !(p_203153_ >= 1.0f)) {
            float[] afloat = new float[2];
            if (p_203154_ > 0.0f || p_203153_ > 0.0f) {
                float f = this.getHeight(p_203150_, p_203151_, p_203155_);
                if (f >= 1.0f) {
                    return 1.0f;
                }
                this.addWeightedHeight(afloat, f);
            }
            this.addWeightedHeight(afloat, p_203152_);
            this.addWeightedHeight(afloat, p_203154_);
            this.addWeightedHeight(afloat, p_203153_);
            return afloat[0] / afloat[1];
        }
        return 1.0f;
    }

    private void addWeightedHeight(float[] p_203189_, float p_203190_) {
        if (p_203190_ >= 0.8f) {
            p_203189_[0] = p_203189_[0] + p_203190_ * 10.0f;
            p_203189_[1] = p_203189_[1] + 10.0f;
        } else if (p_203190_ >= 0.0f) {
            p_203189_[0] = p_203189_[0] + p_203190_;
            p_203189_[1] = p_203189_[1] + 1.0f;
        }
    }

    private float getHeight(BlockAndTintGetter p_203157_, Fluid p_203158_, BlockPos p_203159_) {
        BlockState blockstate = p_203157_.getBlockState(p_203159_);
        return this.getHeight(p_203157_, p_203158_, p_203159_, blockstate, blockstate.getFluidState());
    }

    private float getHeight(BlockAndTintGetter p_203161_, Fluid p_203162_, BlockPos p_203163_, BlockState p_203164_, FluidState p_203165_) {
        if (p_203162_.isSame(p_203165_.getType())) {
            BlockState blockstate = p_203161_.getBlockState(p_203163_.above());
            return p_203162_.isSame(blockstate.getFluidState().getType()) ? 1.0f : p_203165_.getOwnHeight();
        }
        return !p_203164_.isSolid() ? 0.0f : -1.0f;
    }

    private void vertex(VertexConsumer p_110985_, float p_110989_, float p_110990_, float p_110991_, float p_110992_, float p_110993_, float p_343128_, float p_344448_, float p_344284_, int p_110994_, float alpha) {
        p_110985_.addVertex(p_110989_, p_110990_, p_110991_).setColor(p_110992_, p_110993_, p_343128_, alpha).setUv(p_344448_, p_344284_).setLight(p_110994_).setNormal(0.0f, 1.0f, 0.0f);
    }

    private int getLightColor(BlockAndTintGetter p_110946_, BlockPos p_110947_) {
        int i = LevelRenderer.getLightColor(p_110946_, p_110947_);
        int j = LevelRenderer.getLightColor(p_110946_, p_110947_.above());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }
}

