/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.HashMultimap;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public record SimpleModelWrapper(QuadCollection quads, boolean useAmbientOcclusion, TextureAtlasSprite particleIcon, ChunkSectionLayer layer, ChunkSectionLayer layerFast) implements BlockModelPart
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public SimpleModelWrapper(QuadCollection quadcollection, boolean useAmbientOcclusion, TextureAtlasSprite particleIcon) {
        this(quadcollection, useAmbientOcclusion, particleIcon, null, null);
    }

    public static BlockModelPart bake(ModelBaker p_395631_, Identifier p_457297_, ModelState p_396899_) {
        ResolvedModel resolvedmodel = p_395631_.getModel(p_457297_);
        TextureSlots textureslots = resolvedmodel.getTopTextureSlots();
        boolean flag = resolvedmodel.getTopAmbientOcclusion();
        TextureAtlasSprite textureatlassprite = resolvedmodel.resolveParticleSprite(textureslots, p_395631_);
        QuadCollection quadcollection = resolvedmodel.bakeTopGeometry(textureslots, p_395631_, p_396899_);
        HashMultimap multimap = null;
        for (BakedQuad bakedquad : quadcollection.getAll()) {
            TextureAtlasSprite textureatlassprite1 = bakedquad.sprite();
            if (textureatlassprite1.atlasLocation().equals(TextureAtlas.LOCATION_BLOCKS)) continue;
            if (multimap == null) {
                multimap = HashMultimap.create();
            }
            multimap.put((Object)textureatlassprite1.atlasLocation(), (Object)textureatlassprite1.contents().name());
        }
        if (multimap != null) {
            LOGGER.warn("Rejecting block model {}, since it contains sprites from outside of supported atlas: {}", (Object)p_457297_, multimap);
            return p_395631_.missingBlockModelPart();
        }
        IGeometryBakingContext ctx = resolvedmodel.getContext();
        return new SimpleModelWrapper(quadcollection, flag, textureatlassprite, ctx.getRenderType().block(), ctx.getRenderTypeFast().block());
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable Direction p_395134_) {
        return this.quads.getQuads(p_395134_);
    }
}

