/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.skull.DragonHeadModel;
import net.minecraft.client.model.object.skull.PiglinHeadModel;
import net.minecraft.client.model.object.skull.SkullModel;
import net.minecraft.client.model.object.skull.SkullModelBase;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.blockentity.state.SkullBlockRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class SkullBlockRenderer
implements BlockEntityRenderer<SkullBlockEntity, SkullBlockRenderState> {
    private static Map<SkullBlock.Type, Function<EntityModelSet, SkullModelBase>> customModels;
    private final Function<SkullBlock.Type, SkullModelBase> modelByType;
    public static final Map<SkullBlock.Type, Identifier> SKIN_BY_TYPE;
    private final PlayerSkinRenderCache playerSkinRenderCache;

    public static @Nullable SkullModelBase createModel(EntityModelSet p_376421_, SkullBlock.Type p_377655_) {
        if (p_377655_ instanceof SkullBlock.Types) {
            SkullBlock.Types skullblock$types = (SkullBlock.Types)p_377655_;
            return switch (skullblock$types) {
                default -> throw new MatchException(null, null);
                case SkullBlock.Types.SKELETON -> new SkullModel(p_376421_.bakeLayer(ModelLayers.SKELETON_SKULL));
                case SkullBlock.Types.WITHER_SKELETON -> new SkullModel(p_376421_.bakeLayer(ModelLayers.WITHER_SKELETON_SKULL));
                case SkullBlock.Types.PLAYER -> new SkullModel(p_376421_.bakeLayer(ModelLayers.PLAYER_HEAD));
                case SkullBlock.Types.ZOMBIE -> new SkullModel(p_376421_.bakeLayer(ModelLayers.ZOMBIE_HEAD));
                case SkullBlock.Types.CREEPER -> new SkullModel(p_376421_.bakeLayer(ModelLayers.CREEPER_HEAD));
                case SkullBlock.Types.DRAGON -> new DragonHeadModel(p_376421_.bakeLayer(ModelLayers.DRAGON_SKULL));
                case SkullBlock.Types.PIGLIN -> new PiglinHeadModel(p_376421_.bakeLayer(ModelLayers.PIGLIN_HEAD));
            };
        }
        if (customModels == null) {
            customModels = ForgeEventFactoryClient.onCreateSkullModels();
        }
        return customModels.getOrDefault(p_377655_, k -> null).apply(p_376421_);
    }

    public SkullBlockRenderer(BlockEntityRendererProvider.Context p_173660_) {
        EntityModelSet entitymodelset = p_173660_.entityModelSet();
        this.playerSkinRenderCache = p_173660_.playerSkinRenderCache();
        this.modelByType = Util.memoize(p_448220_ -> SkullBlockRenderer.createModel(entitymodelset, p_448220_));
    }

    public SkullBlockRenderState createRenderState() {
        return new SkullBlockRenderState();
    }

    public void extractRenderState(SkullBlockEntity p_428948_, SkullBlockRenderState p_425051_, float p_428826_, Vec3 p_425640_, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay p_428325_) {
        super.extractRenderState((BlockEntity)p_428948_, (BlockEntityRenderState)p_425051_, p_428826_, p_425640_, p_428325_);
        p_425051_.animationProgress = p_428948_.getAnimation(p_428826_);
        BlockState blockstate = p_428948_.getBlockState();
        boolean flag = blockstate.getBlock() instanceof WallSkullBlock;
        p_425051_.direction = flag ? blockstate.getValue(WallSkullBlock.FACING) : null;
        int i = flag ? RotationSegment.convertToSegment(p_425051_.direction.getOpposite()) : blockstate.getValue(SkullBlock.ROTATION);
        p_425051_.rotationDegrees = RotationSegment.convertToDegrees(i);
        p_425051_.skullType = ((AbstractSkullBlock)blockstate.getBlock()).getType();
        p_425051_.renderType = this.resolveSkullRenderType(p_425051_.skullType, p_428948_);
    }

    public void submit(SkullBlockRenderState p_427348_, PoseStack p_429151_, SubmitNodeCollector p_428428_, CameraRenderState p_428415_) {
        SkullModelBase skullmodelbase = this.modelByType.apply(p_427348_.skullType);
        SkullBlockRenderer.submitSkull(p_427348_.direction, p_427348_.rotationDegrees, p_427348_.animationProgress, p_429151_, p_428428_, p_427348_.lightCoords, skullmodelbase, p_427348_.renderType, 0, p_427348_.breakProgress);
    }

    public static void submitSkull(@Nullable Direction p_429199_, float p_431016_, float p_424944_, PoseStack p_424955_, SubmitNodeCollector p_427335_, int p_430325_, SkullModelBase p_454097_, RenderType p_456161_, int p_422297_, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay p_431224_) {
        p_424955_.pushPose();
        if (p_429199_ == null) {
            p_424955_.translate(0.5f, 0.0f, 0.5f);
        } else {
            float f = 0.25f;
            p_424955_.translate(0.5f - (float)p_429199_.getStepX() * 0.25f, 0.25f, 0.5f - (float)p_429199_.getStepZ() * 0.25f);
        }
        p_424955_.scale(-1.0f, -1.0f, 1.0f);
        SkullModelBase.State skullmodelbase$state = new SkullModelBase.State();
        skullmodelbase$state.animationPos = p_424944_;
        skullmodelbase$state.yRot = p_431016_;
        p_427335_.submitModel((Model)p_454097_, (Object)skullmodelbase$state, p_424955_, p_456161_, p_430325_, OverlayTexture.NO_OVERLAY, p_422297_, p_431224_);
        p_424955_.popPose();
    }

    private RenderType resolveSkullRenderType(SkullBlock.Type p_427761_, SkullBlockEntity p_425433_) {
        ResolvableProfile resolvableprofile;
        if (p_427761_ == SkullBlock.Types.PLAYER && (resolvableprofile = p_425433_.getOwnerProfile()) != null) {
            return this.playerSkinRenderCache.getOrDefault(resolvableprofile).renderType();
        }
        return SkullBlockRenderer.getSkullRenderType(p_427761_, null);
    }

    public static RenderType getSkullRenderType(SkullBlock.Type p_408012_, @Nullable Identifier p_452477_) {
        return RenderTypes.entityCutoutNoCullZOffset(p_452477_ != null ? p_452477_ : SKIN_BY_TYPE.get(p_408012_));
    }

    public static RenderType getPlayerSkinRenderType(Identifier p_459382_) {
        return RenderTypes.entityTranslucent(p_459382_);
    }

    static {
        SKIN_BY_TYPE = Util.make(Maps.newHashMap(), p_340906_ -> {
            p_340906_.put(SkullBlock.Types.SKELETON, Identifier.withDefaultNamespace("textures/entity/skeleton/skeleton.png"));
            p_340906_.put(SkullBlock.Types.WITHER_SKELETON, Identifier.withDefaultNamespace("textures/entity/skeleton/wither_skeleton.png"));
            p_340906_.put(SkullBlock.Types.ZOMBIE, Identifier.withDefaultNamespace("textures/entity/zombie/zombie.png"));
            p_340906_.put(SkullBlock.Types.CREEPER, Identifier.withDefaultNamespace("textures/entity/creeper/creeper.png"));
            p_340906_.put(SkullBlock.Types.DRAGON, Identifier.withDefaultNamespace("textures/entity/enderdragon/dragon.png"));
            p_340906_.put(SkullBlock.Types.PIGLIN, Identifier.withDefaultNamespace("textures/entity/piglin/piglin.png"));
            p_340906_.put(SkullBlock.Types.PLAYER, DefaultPlayerSkin.getDefaultTexture());
        });
    }
}

