/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.entity.vehicle.minecart.NewMinecartBehavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.event.RenderNameTagEvent;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityRenderer<T extends Entity, S extends EntityRenderState> {
    private static final float SHADOW_POWER_FALLOFF_Y = 0.5f;
    private static final float MAX_SHADOW_RADIUS = 32.0f;
    public static final float NAMETAG_SCALE = 0.025f;
    protected final EntityRenderDispatcher entityRenderDispatcher;
    private final Font font;
    protected float shadowRadius;
    protected float shadowStrength = 1.0f;

    protected EntityRenderer(EntityRendererProvider.Context p_174008_) {
        this.entityRenderDispatcher = p_174008_.getEntityRenderDispatcher();
        this.font = p_174008_.getFont();
    }

    public final int getPackedLightCoords(T p_114506_, float p_114507_) {
        BlockPos blockpos = BlockPos.containing(((Entity)p_114506_).getLightProbePosition(p_114507_));
        return LightTexture.pack(this.getBlockLightLevel(p_114506_, blockpos), this.getSkyLightLevel(p_114506_, blockpos));
    }

    protected int getSkyLightLevel(T p_114509_, BlockPos p_114510_) {
        return ((Entity)p_114509_).level().getBrightness(LightLayer.SKY, p_114510_);
    }

    protected int getBlockLightLevel(T p_114496_, BlockPos p_114497_) {
        return ((Entity)p_114496_).isOnFire() ? 15 : ((Entity)p_114496_).level().getBrightness(LightLayer.BLOCK, p_114497_);
    }

    public boolean shouldRender(T p_114491_, Frustum p_114492_, double p_114493_, double p_114494_, double p_114495_) {
        Leashable leashable;
        Entity entity;
        if (!((Entity)p_114491_).shouldRender(p_114493_, p_114494_, p_114495_)) {
            return false;
        }
        if (!this.affectedByCulling(p_114491_)) {
            return true;
        }
        AABB aabb = this.getBoundingBoxForCulling(p_114491_).inflate(0.5);
        if (aabb.hasNaN() || aabb.getSize() == 0.0) {
            aabb = new AABB(((Entity)p_114491_).getX() - 2.0, ((Entity)p_114491_).getY() - 2.0, ((Entity)p_114491_).getZ() - 2.0, ((Entity)p_114491_).getX() + 2.0, ((Entity)p_114491_).getY() + 2.0, ((Entity)p_114491_).getZ() + 2.0);
        }
        if (p_114492_.isVisible(aabb)) {
            return true;
        }
        if (p_114491_ instanceof Leashable && (entity = (leashable = (Leashable)p_114491_).getLeashHolder()) != null) {
            AABB aabb1 = this.entityRenderDispatcher.getRenderer(entity).getBoundingBoxForCulling(entity);
            return p_114492_.isVisible(aabb1) || p_114492_.isVisible(aabb.minmax(aabb1));
        }
        return false;
    }

    protected AABB getBoundingBoxForCulling(T p_365369_) {
        return ((Entity)p_365369_).getBoundingBox();
    }

    protected boolean affectedByCulling(T p_366877_) {
        return true;
    }

    public Vec3 getRenderOffset(S p_367733_) {
        return ((EntityRenderState)p_367733_).passengerOffset != null ? ((EntityRenderState)p_367733_).passengerOffset : Vec3.ZERO;
    }

    public void submit(S p_431602_, PoseStack p_427228_, SubmitNodeCollector p_425204_, CameraRenderState p_426406_) {
        if (((EntityRenderState)p_431602_).leashStates != null) {
            for (EntityRenderState.LeashState entityrenderstate$leashstate : ((EntityRenderState)p_431602_).leashStates) {
                p_425204_.submitLeash(p_427228_, entityrenderstate$leashstate);
            }
        }
        this.submitNameTag(p_431602_, p_427228_, p_425204_, p_426406_);
    }

    protected boolean shouldShowName(T p_114504_, double p_363875_) {
        return ((Entity)p_114504_).shouldShowName() || ((Entity)p_114504_).hasCustomName() && p_114504_ == this.entityRenderDispatcher.crosshairPickEntity;
    }

    public Font getFont() {
        return this.font;
    }

    protected void submitNameTag(S p_429896_, PoseStack p_428845_, SubmitNodeCollector p_426439_, CameraRenderState p_428408_) {
        RenderNameTagEvent event = ForgeEventFactoryClient.fireRenderNameTagEvent(p_429896_, (Component)((EntityRenderState)p_429896_).nameTag, (EntityRenderer)this, (PoseStack)p_428845_, (SubmitNodeCollector)p_426439_, (CameraRenderState)p_428408_);
        if (!event.getResult().isDenied() && (event.getResult().isAllowed() || ((EntityRenderState)p_429896_).nameTag != null)) {
            p_426439_.submitNameTag(p_428845_, ((EntityRenderState)p_429896_).nameTagAttachment, 0, event.getContent(), !((EntityRenderState)p_429896_).isDiscrete, ((EntityRenderState)p_429896_).lightCoords, ((EntityRenderState)p_429896_).distanceToCameraSq, p_428408_);
        }
    }

    protected @Nullable Component getNameTag(T p_361489_) {
        return ((Entity)p_361489_).getDisplayName();
    }

    protected float getShadowRadius(S p_364114_) {
        return this.shadowRadius;
    }

    protected float getShadowStrength(S p_376038_) {
        return this.shadowStrength;
    }

    public abstract S createRenderState();

    public final S createRenderState(T p_363266_, float p_363950_) {
        S s = this.createRenderState();
        this.extractRenderState(p_363266_, s, p_363950_);
        this.finalizeRenderState(p_363266_, s);
        return s;
    }

    public void extractRenderState(T p_367571_, S p_367427_, float p_363243_) {
        Leashable leashable;
        Entity $$12;
        NewMinecartBehavior newminecartbehavior;
        AbstractMinecart abstractminecart;
        Object object;
        ((EntityRenderState)p_367427_).entityType = ((Entity)p_367571_).getType();
        ((EntityRenderState)p_367427_).x = Mth.lerp((double)p_363243_, ((Entity)p_367571_).xOld, ((Entity)p_367571_).getX());
        ((EntityRenderState)p_367427_).y = Mth.lerp((double)p_363243_, ((Entity)p_367571_).yOld, ((Entity)p_367571_).getY());
        ((EntityRenderState)p_367427_).z = Mth.lerp((double)p_363243_, ((Entity)p_367571_).zOld, ((Entity)p_367571_).getZ());
        ((EntityRenderState)p_367427_).isInvisible = ((Entity)p_367571_).isInvisible();
        ((EntityRenderState)p_367427_).ageInTicks = (float)((Entity)p_367571_).tickCount + p_363243_;
        ((EntityRenderState)p_367427_).boundingBoxWidth = ((Entity)p_367571_).getBbWidth();
        ((EntityRenderState)p_367427_).boundingBoxHeight = ((Entity)p_367571_).getBbHeight();
        ((EntityRenderState)p_367427_).eyeHeight = ((Entity)p_367571_).getEyeHeight();
        if (((Entity)p_367571_).isPassenger() && (object = ((Entity)p_367571_).getVehicle()) instanceof AbstractMinecart && (object = (abstractminecart = (AbstractMinecart)object).getBehavior()) instanceof NewMinecartBehavior && (newminecartbehavior = (NewMinecartBehavior)object).cartHasPosRotLerp()) {
            double d2 = Mth.lerp((double)p_363243_, abstractminecart.xOld, abstractminecart.getX());
            double d0 = Mth.lerp((double)p_363243_, abstractminecart.yOld, abstractminecart.getY());
            double d1 = Mth.lerp((double)p_363243_, abstractminecart.zOld, abstractminecart.getZ());
            ((EntityRenderState)p_367427_).passengerOffset = newminecartbehavior.getCartLerpPosition(p_363243_).subtract(new Vec3(d2, d0, d1));
        } else {
            ((EntityRenderState)p_367427_).passengerOffset = null;
        }
        if (this.entityRenderDispatcher.camera != null) {
            boolean flag1;
            ((EntityRenderState)p_367427_).distanceToCameraSq = this.entityRenderDispatcher.distanceToSqr((Entity)p_367571_);
            boolean bl = flag1 = ForgeHooksClient.isNameplateInRenderDistance(p_367571_, (double)((EntityRenderState)p_367427_).distanceToCameraSq) && this.shouldShowName(p_367571_, ((EntityRenderState)p_367427_).distanceToCameraSq);
            if (flag1) {
                ((EntityRenderState)p_367427_).nameTag = this.getNameTag(p_367571_);
                ((EntityRenderState)p_367427_).nameTagAttachment = ((Entity)p_367571_).getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, ((Entity)p_367571_).getYRot(p_363243_));
            } else {
                ((EntityRenderState)p_367427_).nameTag = null;
            }
        }
        ((EntityRenderState)p_367427_).isDiscrete = ((Entity)p_367571_).isDiscrete();
        Level level = ((Entity)p_367571_).level();
        if (p_367571_ instanceof Leashable && ($$12 = (leashable = (Leashable)p_367571_).getLeashHolder()) instanceof Entity) {
            int i1;
            float f = ((Entity)p_367571_).getPreciseBodyRotation(p_363243_) * ((float)Math.PI / 180);
            Vec3 vec31 = leashable.getLeashOffset(p_363243_);
            BlockPos blockpos = BlockPos.containing(((Entity)p_367571_).getEyePosition(p_363243_));
            BlockPos blockpos1 = BlockPos.containing($$12.getEyePosition(p_363243_));
            int i = this.getBlockLightLevel(p_367571_, blockpos);
            int j = this.entityRenderDispatcher.getRenderer($$12).getBlockLightLevel($$12, blockpos1);
            int k = level.getBrightness(LightLayer.SKY, blockpos);
            int l = level.getBrightness(LightLayer.SKY, blockpos1);
            boolean flag = $$12.supportQuadLeashAsHolder() && leashable.supportQuadLeash();
            int n = i1 = flag ? 4 : 1;
            if (((EntityRenderState)p_367427_).leashStates == null || ((EntityRenderState)p_367427_).leashStates.size() != i1) {
                ((EntityRenderState)p_367427_).leashStates = new ArrayList(i1);
                for (int j1 = 0; j1 < i1; ++j1) {
                    ((EntityRenderState)p_367427_).leashStates.add(new EntityRenderState.LeashState());
                }
            }
            if (flag) {
                float f1 = $$12.getPreciseBodyRotation(p_363243_) * ((float)Math.PI / 180);
                Vec3 vec3 = $$12.getPosition(p_363243_);
                Vec3[] avec3 = leashable.getQuadLeashOffsets();
                Vec3[] avec31 = $$12.getQuadLeashHolderOffsets();
                for (int k1 = 0; k1 < i1; ++k1) {
                    EntityRenderState.LeashState entityrenderstate$leashstate = (EntityRenderState.LeashState)((EntityRenderState)p_367427_).leashStates.get(k1);
                    entityrenderstate$leashstate.offset = avec3[k1].yRot(-f);
                    entityrenderstate$leashstate.start = ((Entity)p_367571_).getPosition(p_363243_).add(entityrenderstate$leashstate.offset);
                    entityrenderstate$leashstate.end = vec3.add(avec31[k1].yRot(-f1));
                    entityrenderstate$leashstate.startBlockLight = i;
                    entityrenderstate$leashstate.endBlockLight = j;
                    entityrenderstate$leashstate.startSkyLight = k;
                    entityrenderstate$leashstate.endSkyLight = l;
                    entityrenderstate$leashstate.slack = false;
                }
            } else {
                Vec3 vec32 = vec31.yRot(-f);
                EntityRenderState.LeashState entityrenderstate$leashstate1 = (EntityRenderState.LeashState)((EntityRenderState)p_367427_).leashStates.getFirst();
                entityrenderstate$leashstate1.offset = vec32;
                entityrenderstate$leashstate1.start = ((Entity)p_367571_).getPosition(p_363243_).add(vec32);
                entityrenderstate$leashstate1.end = $$12.getRopeHoldPosition(p_363243_);
                entityrenderstate$leashstate1.startBlockLight = i;
                entityrenderstate$leashstate1.endBlockLight = j;
                entityrenderstate$leashstate1.startSkyLight = k;
                entityrenderstate$leashstate1.endSkyLight = l;
            }
        } else {
            ((EntityRenderState)p_367427_).leashStates = null;
        }
        ((EntityRenderState)p_367427_).displayFireAnimation = ((Entity)p_367571_).displayFireAnimation();
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag2 = minecraft.shouldEntityAppearGlowing((Entity)p_367571_);
        ((EntityRenderState)p_367427_).outlineColor = flag2 ? ARGB.opaque(((Entity)p_367571_).getTeamColor()) : 0;
        ((EntityRenderState)p_367427_).lightCoords = this.getPackedLightCoords(p_367571_, p_363243_);
    }

    protected void finalizeRenderState(T p_430394_, S p_428267_) {
        Minecraft minecraft = Minecraft.getInstance();
        Level level = ((Entity)p_430394_).level();
        this.extractShadow(p_428267_, minecraft, level);
    }

    private void extractShadow(S p_431467_, Minecraft p_425570_, Level p_429120_) {
        ((EntityRenderState)p_431467_).shadowPieces.clear();
        if (((Boolean)p_425570_.options.entityShadows().get()).booleanValue() && !((EntityRenderState)p_431467_).isInvisible) {
            double d0;
            float f1;
            float f;
            ((EntityRenderState)p_431467_).shadowRadius = f = Math.min(this.getShadowRadius(p_431467_), 32.0f);
            if (f > 0.0f && (f1 = (float)((1.0 - (d0 = ((EntityRenderState)p_431467_).distanceToCameraSq) / 256.0) * (double)this.getShadowStrength(p_431467_))) > 0.0f) {
                int i = Mth.floor(((EntityRenderState)p_431467_).x - (double)f);
                int j = Mth.floor(((EntityRenderState)p_431467_).x + (double)f);
                int k = Mth.floor(((EntityRenderState)p_431467_).z - (double)f);
                int l = Mth.floor(((EntityRenderState)p_431467_).z + (double)f);
                float f2 = Math.min(f1 / 0.5f - 1.0f, f);
                int i1 = Mth.floor(((EntityRenderState)p_431467_).y - (double)f2);
                int j1 = Mth.floor(((EntityRenderState)p_431467_).y);
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int k1 = k; k1 <= l; ++k1) {
                    for (int l1 = i; l1 <= j; ++l1) {
                        blockpos$mutableblockpos.set(l1, 0, k1);
                        ChunkAccess chunkaccess = p_429120_.getChunk(blockpos$mutableblockpos);
                        for (int i2 = i1; i2 <= j1; ++i2) {
                            blockpos$mutableblockpos.setY(i2);
                            this.extractShadowPiece(p_431467_, p_429120_, f1, blockpos$mutableblockpos, chunkaccess);
                        }
                    }
                }
            }
        } else {
            ((EntityRenderState)p_431467_).shadowRadius = 0.0f;
        }
    }

    private void extractShadowPiece(S p_428100_, Level p_431705_, float p_429996_, BlockPos.MutableBlockPos p_424981_, ChunkAccess p_426623_) {
        VoxelShape voxelshape;
        int i;
        float f = p_429996_ - (float)(((EntityRenderState)p_428100_).y - (double)p_424981_.getY()) * 0.5f;
        Vec3i blockpos = p_424981_.below();
        BlockState blockstate = p_426623_.getBlockState((BlockPos)blockpos);
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE && (i = p_431705_.getMaxLocalRawBrightness(p_424981_)) > 3 && blockstate.isCollisionShapeFullBlock(p_426623_, (BlockPos)blockpos) && !(voxelshape = blockstate.getShape(p_426623_, (BlockPos)blockpos)).isEmpty()) {
            float f1 = Mth.clamp(f * 0.5f * LightTexture.getBrightness(p_431705_.dimensionType(), i), 0.0f, 1.0f);
            float f2 = (float)((double)p_424981_.getX() - ((EntityRenderState)p_428100_).x);
            float f3 = (float)((double)p_424981_.getY() - ((EntityRenderState)p_428100_).y);
            float f4 = (float)((double)p_424981_.getZ() - ((EntityRenderState)p_428100_).z);
            ((EntityRenderState)p_428100_).shadowPieces.add(new EntityRenderState.ShadowPiece(f2, f3, f4, voxelshape, f1));
        }
    }

    private static @Nullable Entity getServerSideEntity(Entity p_397464_) {
        ServerLevel serverlevel;
        IntegratedServer integratedserver = Minecraft.getInstance().getSingleplayerServer();
        if (integratedserver != null && (serverlevel = integratedserver.getLevel(p_397464_.level().dimension())) != null) {
            return serverlevel.getEntity(p_397464_.getId());
        }
        return null;
    }
}

