/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BlockStateDefinitions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class ItemFrameRenderer<T extends ItemFrame>
extends EntityRenderer<T, ItemFrameRenderState> {
    public static final int GLOW_FRAME_BRIGHTNESS = 5;
    public static final int BRIGHT_MAP_LIGHT_ADJUSTMENT = 30;
    private final ItemModelResolver itemModelResolver;
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public ItemFrameRenderer(EntityRendererProvider.Context p_174204_) {
        super(p_174204_);
        this.itemModelResolver = p_174204_.getItemModelResolver();
        this.mapRenderer = p_174204_.getMapRenderer();
        this.blockRenderer = p_174204_.getBlockRenderDispatcher();
    }

    @Override
    protected int getBlockLightLevel(T p_174216_, BlockPos p_174217_) {
        return ((Entity)p_174216_).getType() == EntityType.GLOW_ITEM_FRAME ? Math.max(5, super.getBlockLightLevel(p_174216_, p_174217_)) : super.getBlockLightLevel(p_174216_, p_174217_);
    }

    @Override
    public void submit(ItemFrameRenderState p_430553_, PoseStack p_431616_, SubmitNodeCollector p_423714_, CameraRenderState p_430139_) {
        float f1;
        float f;
        super.submit(p_430553_, p_431616_, p_423714_, p_430139_);
        p_431616_.pushPose();
        Direction direction = p_430553_.direction;
        Vec3 vec3 = this.getRenderOffset(p_430553_);
        p_431616_.translate(-vec3.x(), -vec3.y(), -vec3.z());
        double d0 = 0.46875;
        p_431616_.translate((double)direction.getStepX() * 0.46875, (double)direction.getStepY() * 0.46875, (double)direction.getStepZ() * 0.46875);
        if (direction.getAxis().isHorizontal()) {
            f = 0.0f;
            f1 = 180.0f - direction.toYRot();
        } else {
            f = -90 * direction.getAxisDirection().getStep();
            f1 = 180.0f;
        }
        p_431616_.mulPose((Quaternionfc)Axis.XP.rotationDegrees(f));
        p_431616_.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f1));
        if (!p_430553_.isInvisible) {
            BlockState blockstate = BlockStateDefinitions.getItemFrameFakeState(p_430553_.isGlowFrame, p_430553_.mapId != null);
            BlockStateModel blockstatemodel = this.blockRenderer.getBlockModel(blockstate);
            p_431616_.pushPose();
            p_431616_.translate(-0.5f, -0.5f, -0.5f);
            p_423714_.submitBlockModel(p_431616_, RenderTypes.entitySolidZOffsetForward(TextureAtlas.LOCATION_BLOCKS), blockstatemodel, 1.0f, 1.0f, 1.0f, p_430553_.lightCoords, OverlayTexture.NO_OVERLAY, p_430553_.outlineColor);
            p_431616_.popPose();
        }
        if (p_430553_.isInvisible) {
            p_431616_.translate(0.0f, 0.0f, 0.5f);
        } else {
            p_431616_.translate(0.0f, 0.0f, 0.4375f);
        }
        if (p_430553_.mapId != null) {
            int j = p_430553_.rotation % 4 * 2;
            p_431616_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)j * 360.0f / 8.0f));
            if (!ForgeEventFactoryClient.onRenderItemInFrame((ItemFrameRenderState)p_430553_, (ItemFrameRenderer)this, (PoseStack)p_431616_, (SubmitNodeCollector)p_423714_, (int)p_430553_.lightCoords)) {
                p_431616_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                float f2 = 0.0078125f;
                p_431616_.scale(0.0078125f, 0.0078125f, 0.0078125f);
                p_431616_.translate(-64.0f, -64.0f, 0.0f);
                p_431616_.translate(0.0f, 0.0f, -1.0f);
                int i = this.getLightCoords(p_430553_.isGlowFrame, 15728850, p_430553_.lightCoords);
                this.mapRenderer.render(p_430553_.mapRenderState, p_431616_, p_423714_, true, i);
            }
        } else if (!p_430553_.item.isEmpty()) {
            p_431616_.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)p_430553_.rotation * 360.0f / 8.0f));
            int k = this.getLightCoords(p_430553_.isGlowFrame, 0xF000F0, p_430553_.lightCoords);
            p_431616_.scale(0.5f, 0.5f, 0.5f);
            p_430553_.item.submit(p_431616_, p_423714_, k, OverlayTexture.NO_OVERLAY, p_430553_.outlineColor);
        }
        p_431616_.popPose();
    }

    private int getLightCoords(boolean p_368253_, int p_174210_, int p_174211_) {
        return p_368253_ ? p_174210_ : p_174211_;
    }

    @Override
    public Vec3 getRenderOffset(ItemFrameRenderState p_368370_) {
        return new Vec3((float)p_368370_.direction.getStepX() * 0.3f, -0.25, (float)p_368370_.direction.getStepZ() * 0.3f);
    }

    @Override
    protected boolean shouldShowName(T p_115091_, double p_366137_) {
        return Minecraft.renderNames() && this.entityRenderDispatcher.crosshairPickEntity == p_115091_ && ((ItemFrame)p_115091_).getItem().getCustomName() != null;
    }

    @Override
    protected Component getNameTag(T p_364863_) {
        return ((ItemFrame)p_364863_).getItem().getHoverName();
    }

    @Override
    public ItemFrameRenderState createRenderState() {
        return new ItemFrameRenderState();
    }

    @Override
    public void extractRenderState(T p_369136_, ItemFrameRenderState p_364469_, float p_366511_) {
        MapItemSavedData mapitemsaveddata;
        MapId mapid;
        super.extractRenderState(p_369136_, p_364469_, p_366511_);
        p_364469_.direction = ((HangingEntity)p_369136_).getDirection();
        ItemStack itemstack = ((ItemFrame)p_369136_).getItem();
        this.itemModelResolver.updateForNonLiving(p_364469_.item, itemstack, ItemDisplayContext.FIXED, p_369136_);
        p_364469_.rotation = ((ItemFrame)p_369136_).getRotation();
        p_364469_.isGlowFrame = ((Entity)p_369136_).getType() == EntityType.GLOW_ITEM_FRAME;
        p_364469_.mapId = null;
        if (!itemstack.isEmpty() && (mapid = ((ItemFrame)p_369136_).getFramedMapId(itemstack)) != null && (mapitemsaveddata = ((Entity)p_369136_).level().getMapData(mapid)) != null) {
            this.mapRenderer.extractRenderState(mapid, mapitemsaveddata, p_364469_.mapRenderState);
            p_364469_.mapId = mapid;
        }
    }
}

