/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.equipment.ElytraModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WingsLayer<S extends HumanoidRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private final ElytraModel elytraModel;
    private final ElytraModel elytraBabyModel;
    private final EquipmentLayerRenderer equipmentRenderer;

    public WingsLayer(RenderLayerParent<S, M> p_366720_, EntityModelSet p_369504_, EquipmentLayerRenderer p_361718_) {
        super(p_366720_);
        this.elytraModel = new ElytraModel(p_369504_.bakeLayer(ModelLayers.ELYTRA));
        this.elytraBabyModel = new ElytraModel(p_369504_.bakeLayer(ModelLayers.ELYTRA_BABY));
        this.equipmentRenderer = p_361718_;
    }

    public void submit(PoseStack p_423573_, SubmitNodeCollector p_430991_, int p_423681_, S p_424203_, float p_425267_, float p_425536_) {
        ItemStack itemstack = ((HumanoidRenderState)p_424203_).chestEquipment;
        Equippable equippable = (Equippable)itemstack.get(DataComponents.EQUIPPABLE);
        if (equippable != null && !equippable.assetId().isEmpty()) {
            Identifier identifier = this.getPlayerElytraTexture((HumanoidRenderState)p_424203_);
            ElytraModel elytramodel = ((HumanoidRenderState)p_424203_).isBaby ? this.elytraBabyModel : this.elytraModel;
            p_423573_.pushPose();
            p_423573_.translate(0.0f, 0.0f, 0.125f);
            this.equipmentRenderer.renderLayers(EquipmentClientInfo.LayerType.WINGS, equippable.assetId().get(), (Model)elytramodel, p_424203_, itemstack, p_423573_, p_430991_, p_423681_, identifier, ((HumanoidRenderState)p_424203_).outlineColor, 0);
            p_423573_.popPose();
        }
    }

    protected @Nullable Identifier getPlayerElytraTexture(HumanoidRenderState p_364125_) {
        if (p_364125_ instanceof AvatarRenderState) {
            AvatarRenderState avatarrenderstate = (AvatarRenderState)p_364125_;
            PlayerSkin playerskin = avatarrenderstate.skin;
            if (playerskin.elytra() != null) {
                return playerskin.elytra().texturePath();
            }
            if (playerskin.cape() != null && avatarrenderstate.showCape) {
                return playerskin.cape().texturePath();
            }
        }
        return null;
    }
}

