/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.rendertype;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.OutputTarget;
import net.minecraft.client.renderer.rendertype.TextureTransform;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSetup {
    final RenderPipeline pipeline;
    final Map<String, TextureBinding> textures;
    final TextureTransform textureTransform;
    final OutputTarget outputTarget;
    final OutlineProperty outlineProperty;
    final boolean useLightmap;
    final boolean useOverlay;
    final boolean affectsCrumbling;
    final boolean sortOnUpload;
    final int bufferSize;
    final LayeringTransform layeringTransform;
    final Map<String, TextureAndSampler> texturesWithSamplers;

    RenderSetup(RenderPipeline p_455545_, Map<String, TextureBinding> p_455652_, boolean p_459117_, boolean p_460590_, LayeringTransform p_458911_, OutputTarget p_457054_, TextureTransform p_453948_, OutlineProperty p_454071_, boolean p_455910_, boolean p_450946_, int p_453755_, Map<String, TextureAndSampler> texturesWithSamplers) {
        this.pipeline = p_455545_;
        this.textures = p_455652_;
        this.outputTarget = p_457054_;
        this.textureTransform = p_453948_;
        this.useLightmap = p_459117_;
        this.useOverlay = p_460590_;
        this.outlineProperty = p_454071_;
        this.layeringTransform = p_458911_;
        this.affectsCrumbling = p_455910_;
        this.sortOnUpload = p_450946_;
        this.bufferSize = p_453755_;
        this.texturesWithSamplers = texturesWithSamplers;
    }

    public String toString() {
        return "RenderSetup[layeringTransform=" + String.valueOf(this.layeringTransform) + ", textureTransform=" + String.valueOf(this.textureTransform) + ", textures=" + String.valueOf(this.textures) + ", outlineProperty=" + String.valueOf((Object)this.outlineProperty) + ", useLightmap=" + this.useLightmap + ", useOverlay=" + this.useOverlay + "]";
    }

    public static RenderSetupBuilder builder(RenderPipeline p_455597_) {
        return new RenderSetupBuilder(p_455597_);
    }

    public Map<String, TextureAndSampler> getTextures() {
        if (this.textures.isEmpty() && !this.useOverlay && !this.useLightmap) {
            return Collections.emptyMap();
        }
        HashMap<String, TextureAndSampler> map = new HashMap<String, TextureAndSampler>();
        if (this.useOverlay) {
            map.put("Sampler1", new TextureAndSampler(Minecraft.getInstance().gameRenderer.overlayTexture().getTextureView(), RenderSystem.getSamplerCache().getClampToEdge(FilterMode.LINEAR)));
        }
        if (this.useLightmap) {
            map.put("Sampler2", new TextureAndSampler(Minecraft.getInstance().gameRenderer.lightTexture().getTextureView(), RenderSystem.getSamplerCache().getClampToEdge(FilterMode.LINEAR)));
        }
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        for (Map.Entry<String, TextureBinding> entry : this.textures.entrySet()) {
            AbstractTexture abstracttexture = texturemanager.getTexture(entry.getValue().location);
            GpuSampler gpusampler = entry.getValue().sampler().get();
            map.put(entry.getKey(), new TextureAndSampler(abstracttexture.getTextureView(), gpusampler != null ? gpusampler : abstracttexture.getSampler()));
        }
        map.putAll(this.texturesWithSamplers);
        return map;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum OutlineProperty {
        NONE("none"),
        IS_OUTLINE("is_outline"),
        AFFECTS_OUTLINE("affects_outline");

        private final String name;

        private OutlineProperty(String p_452545_) {
            this.name = p_452545_;
        }

        public String toString() {
            return this.name;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RenderSetupBuilder {
        private final RenderPipeline pipeline;
        private boolean useLightmap = false;
        private boolean useOverlay = false;
        private LayeringTransform layeringTransform = LayeringTransform.NO_LAYERING;
        private OutputTarget outputTarget = OutputTarget.MAIN_TARGET;
        private TextureTransform textureTransform = TextureTransform.DEFAULT_TEXTURING;
        private boolean affectsCrumbling = false;
        private boolean sortOnUpload = false;
        private int bufferSize = 1536;
        private OutlineProperty outlineProperty = OutlineProperty.NONE;
        private final Map<String, TextureBinding> textures = new HashMap<String, TextureBinding>();
        private final Map<String, TextureAndSampler> texturesWithSamplers = new HashMap<String, TextureAndSampler>();

        RenderSetupBuilder(RenderPipeline p_453804_) {
            this.pipeline = p_453804_;
        }

        public RenderSetupBuilder withTexture(String p_450834_, Identifier p_455691_) {
            this.textures.put(p_450834_, new TextureBinding(p_455691_, () -> null));
            return this;
        }

        public RenderSetupBuilder withTexture(String p_451536_, Identifier p_457755_, @Nullable Supplier<GpuSampler> p_457392_) {
            this.textures.put(p_451536_, new TextureBinding(p_457755_, (Supplier<GpuSampler>)Suppliers.memoize(() -> p_457392_ == null ? null : (GpuSampler)p_457392_.get())));
            return this;
        }

        public RenderSetupBuilder withTexture(String name, GpuTextureView textureView, GpuSampler sampler) {
            this.texturesWithSamplers.put(name, new TextureAndSampler(textureView, sampler));
            return this;
        }

        public RenderSetupBuilder useLightmap() {
            this.useLightmap = true;
            return this;
        }

        public RenderSetupBuilder useOverlay() {
            this.useOverlay = true;
            return this;
        }

        public RenderSetupBuilder affectsCrumbling() {
            this.affectsCrumbling = true;
            return this;
        }

        public RenderSetupBuilder sortOnUpload() {
            this.sortOnUpload = true;
            return this;
        }

        public RenderSetupBuilder bufferSize(int p_461063_) {
            this.bufferSize = p_461063_;
            return this;
        }

        public RenderSetupBuilder setLayeringTransform(LayeringTransform p_460097_) {
            this.layeringTransform = p_460097_;
            return this;
        }

        public RenderSetupBuilder setOutputTarget(OutputTarget p_461092_) {
            this.outputTarget = p_461092_;
            return this;
        }

        public RenderSetupBuilder setTextureTransform(TextureTransform p_454187_) {
            this.textureTransform = p_454187_;
            return this;
        }

        public RenderSetupBuilder setOutline(OutlineProperty p_455591_) {
            this.outlineProperty = p_455591_;
            return this;
        }

        public RenderSetup createRenderSetup() {
            return new RenderSetup(this.pipeline, this.textures, this.useLightmap, this.useOverlay, this.layeringTransform, this.outputTarget, this.textureTransform, this.outlineProperty, this.affectsCrumbling, this.sortOnUpload, this.bufferSize, this.texturesWithSamplers);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record TextureAndSampler(GpuTextureView textureView, GpuSampler sampler) {
    }

    @OnlyIn(value=Dist.CLIENT)
    record TextureBinding(Identifier location, Supplier<@Nullable GpuSampler> sampler) {
    }
}

