/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.SpriteCoordinateExpander;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@OnlyIn(value=Dist.CLIENT)
public class TextureAtlasSprite
implements AutoCloseable {
    private final Identifier atlasLocation;
    private final SpriteContents contents;
    private final int x;
    private final int y;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;
    private final int padding;

    protected TextureAtlasSprite(Identifier p_460544_, SpriteContents p_248526_, int p_248950_, int p_249741_, int p_248672_, int p_248637_, int p_452036_) {
        this.atlasLocation = p_460544_;
        this.contents = p_248526_;
        this.padding = p_452036_;
        this.x = p_248672_;
        this.y = p_248637_;
        this.u0 = (float)(p_248672_ + p_452036_) / (float)p_248950_;
        this.u1 = (float)(p_248672_ + p_452036_ + p_248526_.width()) / (float)p_248950_;
        this.v0 = (float)(p_248637_ + p_452036_) / (float)p_249741_;
        this.v1 = (float)(p_248637_ + p_452036_ + p_248526_.height()) / (float)p_249741_;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public float getU0() {
        return this.u0;
    }

    public float getU1() {
        return this.u1;
    }

    public SpriteContents contents() {
        return this.contents;
    }

    public @Nullable SpriteContents.AnimationState createAnimationState(GpuBufferSlice p_455189_, int p_458866_) {
        return this.contents.createAnimationState(p_455189_, p_458866_);
    }

    public float getU(float p_298825_) {
        float f = this.u1 - this.u0;
        return this.u0 + f * p_298825_;
    }

    public float getV0() {
        return this.v0;
    }

    public float getV1() {
        return this.v1;
    }

    public float getV(float p_299087_) {
        float f = this.v1 - this.v0;
        return this.v0 + f * p_299087_;
    }

    public Identifier atlasLocation() {
        return this.atlasLocation;
    }

    public String toString() {
        return "TextureAtlasSprite{contents='" + String.valueOf(this.contents) + "', u0=" + this.u0 + ", u1=" + this.u1 + ", v0=" + this.v0 + ", v1=" + this.v1 + "}";
    }

    public void uploadFirstFrame(GpuTexture p_397186_, int p_460430_) {
        this.contents.uploadFirstFrame(p_397186_, p_460430_);
    }

    public VertexConsumer wrap(VertexConsumer p_118382_) {
        return new SpriteCoordinateExpander(p_118382_, this);
    }

    boolean isAnimated() {
        return this.contents.isAnimated();
    }

    public void uploadSpriteUbo(ByteBuffer p_450246_, int p_456272_, int p_452106_, int p_453297_, int p_452181_, int p_457141_) {
        for (int i = 0; i <= p_452106_; ++i) {
            Std140Builder.intoBuffer((ByteBuffer)MemoryUtil.memSlice((ByteBuffer)p_450246_, (int)(p_456272_ + i * p_457141_), (int)p_457141_)).putMat4f((Matrix4fc)new Matrix4f().ortho2D(0.0f, (float)(p_453297_ >> i), 0.0f, (float)(p_452181_ >> i))).putMat4f((Matrix4fc)new Matrix4f().translate((float)(this.x >> i), (float)(this.y >> i), 0.0f).scale((float)(this.contents.width() + this.padding * 2 >> i), (float)(this.contents.height() + this.padding * 2 >> i), 1.0f)).putFloat((float)this.padding / (float)this.contents.width()).putFloat((float)this.padding / (float)this.contents.height()).putInt(i);
        }
    }

    @Override
    public void close() {
        this.contents.close();
    }

    public int getPixelRGBA(int frameIndex, int x, int y) {
        if (this.contents.animatedTexture != null) {
            x += this.contents.animatedTexture.getFrameX(frameIndex) * this.contents.width;
            y += this.contents.animatedTexture.getFrameY(frameIndex) * this.contents.height;
        }
        return this.contents.getOriginalImage().getPixel(x, y);
    }
}

