/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectFunction;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.ModelContext;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ModelDiscovery {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Object2ObjectMap<Identifier, ModelWrapper> modelWrappers = new Object2ObjectOpenHashMap();
    private final ModelWrapper missingModel;
    private final Object2ObjectFunction<Identifier, ModelWrapper> uncachedResolver;
    private final ResolvableModel.Resolver resolver;
    private final Queue<ModelWrapper> parentDiscoveryQueue = new ArrayDeque<ModelWrapper>();

    public ModelDiscovery(Map<Identifier, UnbakedModel> p_362964_, UnbakedModel p_367385_) {
        this.missingModel = new ModelWrapper(MissingBlockModel.LOCATION, p_367385_, true);
        this.modelWrappers.put((Object)MissingBlockModel.LOCATION, (Object)this.missingModel);
        this.uncachedResolver = p_448446_ -> {
            Identifier identifier = (Identifier)p_448446_;
            UnbakedModel unbakedmodel = (UnbakedModel)p_362964_.get(identifier);
            if (unbakedmodel == null) {
                LOGGER.warn("Missing block model: {}", (Object)identifier);
                return this.missingModel;
            }
            return this.createAndQueueWrapper(identifier, unbakedmodel);
        };
        this.resolver = this::getOrCreateModel;
    }

    private static boolean isRoot(UnbakedModel p_394200_) {
        return p_394200_.parent() == null;
    }

    private ModelWrapper getOrCreateModel(Identifier p_453016_) {
        return (ModelWrapper)this.modelWrappers.computeIfAbsent((Object)p_453016_, this.uncachedResolver);
    }

    private ModelWrapper createAndQueueWrapper(Identifier p_459979_, UnbakedModel p_391978_) {
        boolean flag = ModelDiscovery.isRoot(p_391978_);
        ModelWrapper modeldiscovery$modelwrapper = new ModelWrapper(p_459979_, p_391978_, flag);
        if (!flag) {
            this.parentDiscoveryQueue.add(modeldiscovery$modelwrapper);
        }
        return modeldiscovery$modelwrapper;
    }

    public void addRoot(ResolvableModel p_376215_) {
        p_376215_.resolveDependencies(this.resolver);
    }

    public void addSpecialModel(Identifier p_460236_, UnbakedModel p_391360_) {
        if (!ModelDiscovery.isRoot(p_391360_)) {
            LOGGER.warn("Trying to add non-root special model {}, ignoring", (Object)p_460236_);
        } else {
            ModelWrapper modeldiscovery$modelwrapper = (ModelWrapper)this.modelWrappers.put((Object)p_460236_, (Object)this.createAndQueueWrapper(p_460236_, p_391360_));
            if (modeldiscovery$modelwrapper != null) {
                LOGGER.warn("Duplicate special model {}", (Object)p_460236_);
            }
        }
    }

    public ResolvedModel missingModel() {
        return this.missingModel;
    }

    public Map<Identifier, ResolvedModel> resolve() {
        ArrayList<ModelWrapper> list = new ArrayList<ModelWrapper>();
        this.discoverDependencies(list);
        ModelDiscovery.propagateValidity(list);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.modelWrappers.forEach((p_460758_, p_389606_) -> {
            if (p_389606_.valid) {
                builder.put(p_460758_, p_389606_);
            } else {
                LOGGER.warn("Model {} ignored due to cyclic dependency", p_460758_);
            }
        });
        return builder.build();
    }

    private void discoverDependencies(List<ModelWrapper> p_396534_) {
        ModelWrapper modeldiscovery$modelwrapper;
        while ((modeldiscovery$modelwrapper = this.parentDiscoveryQueue.poll()) != null) {
            ModelWrapper modeldiscovery$modelwrapper1;
            Identifier identifier = Objects.requireNonNull(modeldiscovery$modelwrapper.wrapped.parent());
            modeldiscovery$modelwrapper.parent = modeldiscovery$modelwrapper1 = this.getOrCreateModel(identifier);
            if (modeldiscovery$modelwrapper1.valid) {
                modeldiscovery$modelwrapper.valid = true;
                continue;
            }
            p_396534_.add(modeldiscovery$modelwrapper);
        }
    }

    private static void propagateValidity(List<ModelWrapper> p_394425_) {
        boolean flag = true;
        while (flag) {
            flag = false;
            Iterator<ModelWrapper> iterator = p_394425_.iterator();
            while (iterator.hasNext()) {
                ModelWrapper modeldiscovery$modelwrapper = iterator.next();
                if (!Objects.requireNonNull(modeldiscovery$modelwrapper.parent).valid) continue;
                modeldiscovery$modelwrapper.valid = true;
                iterator.remove();
                flag = true;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModelWrapper
    implements ResolvedModel {
        private static final Slot<Boolean> KEY_AMBIENT_OCCLUSION = ModelWrapper.slot(0);
        private static final Slot<UnbakedModel.GuiLight> KEY_GUI_LIGHT = ModelWrapper.slot(1);
        private static final Slot<UnbakedGeometry> KEY_GEOMETRY = ModelWrapper.slot(2);
        private static final Slot<ItemTransforms> KEY_TRANSFORMS = ModelWrapper.slot(3);
        private static final Slot<TextureSlots> KEY_TEXTURE_SLOTS = ModelWrapper.slot(4);
        private static final Slot<TextureAtlasSprite> KEY_PARTICLE_SPRITE = ModelWrapper.slot(5);
        private static final Slot<QuadCollection> KEY_DEFAULT_GEOMETRY = ModelWrapper.slot(6);
        private static final int SLOT_COUNT = 7;
        private final Identifier id;
        boolean valid;
        @Nullable ModelWrapper parent;
        final UnbakedModel wrapped;
        private final AtomicReferenceArray<@Nullable Object> fixedSlots = new AtomicReferenceArray(7);
        private final Map<ModelState, QuadCollection> modelBakeCache = new ConcurrentHashMap<ModelState, QuadCollection>();
        private @Nullable ModelContext context = null;

        private static <T> Slot<T> slot(int p_392332_) {
            Objects.checkIndex(p_392332_, 7);
            return new Slot(p_392332_);
        }

        ModelWrapper(Identifier p_454615_, UnbakedModel p_394055_, boolean p_397832_) {
            this.id = p_454615_;
            this.wrapped = p_394055_;
            this.valid = p_397832_;
        }

        @Override
        public UnbakedModel wrapped() {
            return this.wrapped;
        }

        @Override
        public @Nullable ResolvedModel parent() {
            return this.parent;
        }

        @Override
        public IGeometryBakingContext getContext() {
            if (this.context == null || this.context.parent() != this.parent) {
                this.context = new ModelContext((ResolvedModel)this);
            }
            return this.context;
        }

        public String debugName() {
            return this.id.toString();
        }

        private <T> @Nullable T getSlot(Slot<T> p_394981_) {
            return (T)this.fixedSlots.get(p_394981_.index);
        }

        private <T> T updateSlot(Slot<T> p_391987_, T p_391757_) {
            Object t = this.fixedSlots.compareAndExchange(p_391987_.index, null, p_391757_);
            return (T)(t == null ? p_391757_ : t);
        }

        private <T> T getSimpleProperty(Slot<T> p_397608_, Function<ResolvedModel, T> p_393296_) {
            T t = this.getSlot(p_397608_);
            return t != null ? t : this.updateSlot(p_397608_, p_393296_.apply(this));
        }

        @Override
        public boolean getTopAmbientOcclusion() {
            return this.getSimpleProperty(KEY_AMBIENT_OCCLUSION, ResolvedModel::findTopAmbientOcclusion);
        }

        @Override
        public UnbakedModel.GuiLight getTopGuiLight() {
            return this.getSimpleProperty(KEY_GUI_LIGHT, ResolvedModel::findTopGuiLight);
        }

        @Override
        public ItemTransforms getTopTransforms() {
            return this.getSimpleProperty(KEY_TRANSFORMS, ResolvedModel::findTopTransforms);
        }

        @Override
        public UnbakedGeometry getTopGeometry() {
            return this.getSimpleProperty(KEY_GEOMETRY, ResolvedModel::findTopGeometry);
        }

        @Override
        public TextureSlots getTopTextureSlots() {
            return this.getSimpleProperty(KEY_TEXTURE_SLOTS, ResolvedModel::findTopTextureSlots);
        }

        @Override
        public TextureAtlasSprite resolveParticleSprite(TextureSlots p_396706_, ModelBaker p_393999_) {
            TextureAtlasSprite textureatlassprite = this.getSlot(KEY_PARTICLE_SPRITE);
            return textureatlassprite != null ? textureatlassprite : this.updateSlot(KEY_PARTICLE_SPRITE, ResolvedModel.resolveParticleSprite(p_396706_, p_393999_, this));
        }

        private QuadCollection bakeDefaultState(TextureSlots p_392267_, ModelBaker p_393576_, ModelState p_391972_) {
            QuadCollection quadcollection = this.getSlot(KEY_DEFAULT_GEOMETRY);
            return quadcollection != null ? quadcollection : this.updateSlot(KEY_DEFAULT_GEOMETRY, this.getTopGeometry().bake(p_392267_, p_393576_, p_391972_, this, this.getContext()));
        }

        @Override
        public QuadCollection bakeTopGeometry(TextureSlots p_396404_, ModelBaker p_391625_, ModelState p_396681_) {
            return p_396681_ == BlockModelRotation.IDENTITY ? this.bakeDefaultState(p_396404_, p_391625_, p_396681_) : this.modelBakeCache.computeIfAbsent(p_396681_, p_394933_ -> {
                UnbakedGeometry unbakedgeometry = this.getTopGeometry();
                return unbakedgeometry.bake(p_396404_, p_391625_, (ModelState)p_394933_, this, this.getContext());
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    record Slot<T>(int index) {
    }
}

