/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IQuadTransformer;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class QuadCollection {
    public static final QuadCollection EMPTY = new QuadCollection(List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
    private final List<BakedQuad> all;
    private final List<BakedQuad> unculled;
    private final List<BakedQuad> north;
    private final List<BakedQuad> south;
    private final List<BakedQuad> east;
    private final List<BakedQuad> west;
    private final List<BakedQuad> up;
    private final List<BakedQuad> down;

    QuadCollection(List<BakedQuad> p_391548_, List<BakedQuad> p_397628_, List<BakedQuad> p_392216_, List<BakedQuad> p_397515_, List<BakedQuad> p_391585_, List<BakedQuad> p_393386_, List<BakedQuad> p_393693_, List<BakedQuad> p_393927_) {
        this.all = p_391548_;
        this.unculled = p_397628_;
        this.north = p_392216_;
        this.south = p_397515_;
        this.east = p_391585_;
        this.west = p_393386_;
        this.up = p_393693_;
        this.down = p_393927_;
    }

    public List<BakedQuad> getQuads(@Nullable Direction p_394582_) {
        Direction direction = p_394582_;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NORTH", "SOUTH", "EAST", "WEST", "UP", "DOWN"}, (Direction)direction, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> this.unculled;
            case 0 -> this.north;
            case 1 -> this.south;
            case 2 -> this.east;
            case 3 -> this.west;
            case 4 -> this.up;
            case 5 -> this.down;
        };
    }

    public List<BakedQuad> getAll() {
        return this.all;
    }

    public QuadCollection transform(IQuadTransformer transformer) {
        return new QuadCollection(transformer.process(this.all), transformer.process(this.unculled), transformer.process(this.north), transformer.process(this.south), transformer.process(this.east), transformer.process(this.west), transformer.process(this.up), transformer.process(this.down));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final ImmutableList.Builder<BakedQuad> unculledFaces = ImmutableList.builder();
        private final Multimap<Direction, BakedQuad> culledFaces = ArrayListMultimap.create();

        public Builder addCulledFace(Direction p_396778_, BakedQuad p_396647_) {
            this.culledFaces.put((Object)p_396778_, (Object)p_396647_);
            return this;
        }

        public Builder addUnculledFace(BakedQuad p_397122_) {
            this.unculledFaces.add((Object)p_397122_);
            return this;
        }

        private static QuadCollection createFromSublists(List<BakedQuad> p_393861_, int p_393519_, int p_394001_, int p_391425_, int p_397077_, int p_396687_, int p_395872_, int p_395332_) {
            int i = 0;
            int j = i + p_393519_;
            List<BakedQuad> list = p_393861_.subList(i, j);
            i = j + p_394001_;
            List<BakedQuad> list1 = p_393861_.subList(j, i);
            int k = i + p_391425_;
            List<BakedQuad> list2 = p_393861_.subList(i, k);
            i = k + p_397077_;
            List<BakedQuad> list3 = p_393861_.subList(k, i);
            int l = i + p_396687_;
            List<BakedQuad> list4 = p_393861_.subList(i, l);
            i = l + p_395872_;
            List<BakedQuad> list5 = p_393861_.subList(l, i);
            List<BakedQuad> list6 = p_393861_.subList(i, i + p_395332_);
            return new QuadCollection(p_393861_, list, list1, list2, list3, list4, list5, list6);
        }

        public QuadCollection build() {
            ImmutableList immutablelist = this.unculledFaces.build();
            if (this.culledFaces.isEmpty()) {
                return immutablelist.isEmpty() ? EMPTY : new QuadCollection((List<BakedQuad>)immutablelist, (List<BakedQuad>)immutablelist, List.of(), List.of(), List.of(), List.of(), List.of(), List.of());
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)immutablelist);
            Collection collection = this.culledFaces.get((Object)Direction.NORTH);
            builder.addAll((Iterable)collection);
            Collection collection1 = this.culledFaces.get((Object)Direction.SOUTH);
            builder.addAll((Iterable)collection1);
            Collection collection2 = this.culledFaces.get((Object)Direction.EAST);
            builder.addAll((Iterable)collection2);
            Collection collection3 = this.culledFaces.get((Object)Direction.WEST);
            builder.addAll((Iterable)collection3);
            Collection collection4 = this.culledFaces.get((Object)Direction.UP);
            builder.addAll((Iterable)collection4);
            Collection collection5 = this.culledFaces.get((Object)Direction.DOWN);
            builder.addAll((Iterable)collection5);
            return Builder.createFromSublists((List<BakedQuad>)builder.build(), immutablelist.size(), collection.size(), collection1.size(), collection2.size(), collection3.size(), collection4.size(), collection5.size());
        }
    }
}

