/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.resources.Identifier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jspecify.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface UnbakedModel {
    public static final String PARTICLE_TEXTURE_REFERENCE = "particle";

    default public @Nullable Boolean ambientOcclusion() {
        return null;
    }

    default public @Nullable GuiLight guiLight() {
        return null;
    }

    default public @Nullable ItemTransforms transforms() {
        return null;
    }

    default public TextureSlots.Data textureSlots() {
        return TextureSlots.Data.EMPTY;
    }

    default public @Nullable UnbakedGeometry geometry() {
        return null;
    }

    default public @Nullable Identifier parent() {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_377886_) {
            this.name = p_377886_;
        }

        public static GuiLight getByName(String p_378162_) {
            for (GuiLight unbakedmodel$guilight : GuiLight.values()) {
                if (!unbakedmodel$guilight.name.equals(p_378162_)) continue;
                return unbakedmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_378162_);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

