/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.server;

import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.client.server.LanServer;
import net.minecraft.client.server.LanServerPinger;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.DualStackUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class LanServerDetection {
    static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();

    @OnlyIn(value=Dist.CLIENT)
    public static class LanServerList {
        private final List<LanServer> servers = Lists.newArrayList();
        private boolean isDirty;

        public synchronized @Nullable List<LanServer> takeDirtyServers() {
            if (this.isDirty) {
                List<LanServer> list = List.copyOf(this.servers);
                this.isDirty = false;
                return list;
            }
            return null;
        }

        public synchronized void addServer(String p_120097_, InetAddress p_120098_) {
            String s = LanServerPinger.parseMotd(p_120097_);
            Object s1 = LanServerPinger.parseAddress(p_120097_);
            if (s1 != null) {
                s1 = DualStackUtils.checkIPv6((InetAddress)p_120098_) ? "[" + InetAddresses.toAddrString((InetAddress)p_120098_) + "]:" + (String)s1 : p_120098_.getHostAddress() + ":" + (String)s1;
                boolean flag = false;
                for (LanServer lanserver : this.servers) {
                    if (!lanserver.getAddress().equals(s1)) continue;
                    lanserver.updatePingTime();
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.servers.add(new LanServer(s, (String)s1));
                    this.isDirty = true;
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LanServerDetector
    extends Thread {
        private final LanServerList serverList;
        private final InetAddress pingGroup;
        private final MulticastSocket socket;

        public LanServerDetector(LanServerList p_120090_) throws IOException {
            super("LanServerDetector #" + UNIQUE_THREAD_ID.incrementAndGet());
            this.serverList = p_120090_;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            this.socket = new MulticastSocket(4445);
            this.pingGroup = InetAddress.getByName(LanServerPinger.MULTICAST_GROUP);
            this.socket.setSoTimeout(5000);
            this.socket.joinGroup(this.pingGroup);
        }

        @Override
        public void run() {
            byte[] abyte = new byte[1024];
            while (!this.isInterrupted()) {
                DatagramPacket datagrampacket = new DatagramPacket(abyte, abyte.length);
                try {
                    this.socket.receive(datagrampacket);
                }
                catch (SocketTimeoutException sockettimeoutexception) {
                    continue;
                }
                catch (IOException ioexception1) {
                    LOGGER.error("Couldn't ping server", (Throwable)ioexception1);
                    break;
                }
                String s = new String(datagrampacket.getData(), datagrampacket.getOffset(), datagrampacket.getLength(), StandardCharsets.UTF_8);
                LOGGER.debug("{}: {}", (Object)datagrampacket.getAddress(), (Object)s);
                this.serverList.addServer(s, datagrampacket.getAddress());
            }
            try {
                this.socket.leaveGroup(this.pingGroup);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket.close();
        }
    }
}

