/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.Library;
import com.mojang.blaze3d.audio.Listener;
import com.mojang.blaze3d.audio.ListenerTransform;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.SharedConstants;
import net.minecraft.client.Camera;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundEngineExecutor;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import net.minecraftforge.client.event.sound.SoundEngineLoadEvent;
import net.minecraftforge.eventbus.internal.Event;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@OnlyIn(value=Dist.CLIENT)
public class SoundEngine {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"SOUNDS");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final float PITCH_MIN = 0.5f;
    private static final float PITCH_MAX = 2.0f;
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 1.0f;
    private static final int MIN_SOURCE_LIFETIME = 20;
    private static final Set<Identifier> ONLY_WARN_ONCE = Sets.newHashSet();
    private static final long DEFAULT_DEVICE_CHECK_INTERVAL_MS = 1000L;
    public static final String MISSING_SOUND = "FOR THE DEBUG!";
    public static final String OPEN_AL_SOFT_PREFIX = "OpenAL Soft on ";
    public static final int OPEN_AL_SOFT_PREFIX_LENGTH = "OpenAL Soft on ".length();
    public final SoundManager soundManager;
    private final Options options;
    private boolean loaded;
    private final Library library = new Library();
    private final Listener listener = this.library.getListener();
    private final SoundBufferLibrary soundBuffers;
    private final SoundEngineExecutor executor = new SoundEngineExecutor();
    private final ChannelAccess channelAccess = new ChannelAccess(this.library, (Executor)this.executor);
    private int tickCount;
    private long lastDeviceCheckTime;
    private final AtomicReference<DeviceCheckState> devicePoolState = new AtomicReference<DeviceCheckState>(DeviceCheckState.NO_CHANGE);
    private final Map<SoundInstance, ChannelAccess.ChannelHandle> instanceToChannel = Maps.newHashMap();
    private final Multimap<SoundSource, SoundInstance> instanceBySource = HashMultimap.create();
    private final Object2FloatMap<SoundSource> gainBySource = (Object2FloatMap)Util.make(new Object2FloatOpenHashMap(), p_448465_ -> p_448465_.defaultReturnValue(1.0f));
    private final List<TickableSoundInstance> tickingSounds = Lists.newArrayList();
    private final Map<SoundInstance, Integer> queuedSounds = Maps.newHashMap();
    private final Map<SoundInstance, Integer> soundDeleteTime = Maps.newHashMap();
    private final List<SoundEventListener> listeners = Lists.newArrayList();
    private final List<TickableSoundInstance> queuedTickableSounds = Lists.newArrayList();
    private final List<Sound> preloadQueue = Lists.newArrayList();

    public SoundEngine(SoundManager p_120236_, Options p_120237_, ResourceProvider p_249332_) {
        this.soundManager = p_120236_;
        this.options = p_120237_;
        this.soundBuffers = new SoundBufferLibrary(p_249332_);
        SoundEngineLoadEvent.BUS.post((Event)new SoundEngineLoadEvent(this));
    }

    public void reload() {
        ONLY_WARN_ONCE.clear();
        for (SoundEvent soundevent : BuiltInRegistries.SOUND_EVENT) {
            Identifier identifier;
            if (soundevent == SoundEvents.EMPTY || this.soundManager.getSoundEvent(identifier = soundevent.location()) != null) continue;
            LOGGER.warn("Missing sound for event: {}", (Object)BuiltInRegistries.SOUND_EVENT.getKey(soundevent));
            ONLY_WARN_ONCE.add(identifier);
        }
        this.destroy();
        this.loadLibrary();
        SoundEngineLoadEvent.BUS.post((Event)new SoundEngineLoadEvent(this));
    }

    private synchronized void loadLibrary() {
        if (!this.loaded) {
            try {
                String s = (String)this.options.soundDevice().get();
                this.library.init("".equals(s) ? null : s, ((Boolean)this.options.directionalAudio().get()).booleanValue());
                this.listener.reset();
                this.soundBuffers.preload(this.preloadQueue).thenRun(this.preloadQueue::clear);
                this.loaded = true;
                LOGGER.info(MARKER, "Sound engine started");
            }
            catch (RuntimeException runtimeexception) {
                LOGGER.error(MARKER, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
            }
        }
    }

    public void refreshCategoryVolume(SoundSource p_451806_) {
        if (this.loaded) {
            this.instanceToChannel.forEach((p_448467_, p_448468_) -> {
                if (p_451806_ == p_448467_.getSource() || p_451806_ == SoundSource.MASTER) {
                    float f = this.calculateVolume((SoundInstance)p_448467_);
                    p_448468_.execute(p_405035_ -> p_405035_.setVolume(f));
                }
            });
        }
    }

    public void destroy() {
        if (this.loaded) {
            this.stopAll();
            this.soundBuffers.clear();
            this.library.cleanup();
            this.loaded = false;
        }
    }

    public void emergencyShutdown() {
        if (this.loaded) {
            this.library.cleanup();
        }
    }

    public void stop(SoundInstance p_120275_) {
        ChannelAccess.ChannelHandle channelaccess$channelhandle;
        if (this.loaded && (channelaccess$channelhandle = this.instanceToChannel.get(p_120275_)) != null) {
            channelaccess$channelhandle.execute(Channel::stop);
        }
    }

    public void updateCategoryVolume(SoundSource p_120261_, float p_457169_) {
        this.gainBySource.put((Object)p_120261_, Mth.clamp(p_457169_, 0.0f, 1.0f));
        this.refreshCategoryVolume(p_120261_);
    }

    public void stopAll() {
        if (this.loaded) {
            this.executor.shutDown();
            this.instanceToChannel.clear();
            this.channelAccess.clear();
            this.queuedSounds.clear();
            this.tickingSounds.clear();
            this.instanceBySource.clear();
            this.soundDeleteTime.clear();
            this.queuedTickableSounds.clear();
            this.gainBySource.clear();
            this.executor.startUp();
        }
    }

    public void addEventListener(SoundEventListener p_120296_) {
        this.listeners.add(p_120296_);
    }

    public void removeEventListener(SoundEventListener p_120308_) {
        this.listeners.remove(p_120308_);
    }

    private boolean shouldChangeDevice() {
        boolean flag;
        if (this.library.isCurrentDeviceDisconnected()) {
            LOGGER.info("Audio device was lost!");
            return true;
        }
        long i = Util.getMillis();
        boolean bl = flag = i - this.lastDeviceCheckTime >= 1000L;
        if (flag) {
            this.lastDeviceCheckTime = i;
            if (this.devicePoolState.compareAndSet(DeviceCheckState.NO_CHANGE, DeviceCheckState.ONGOING)) {
                String s = (String)this.options.soundDevice().get();
                Util.ioPool().execute(() -> {
                    if ("".equals(s)) {
                        if (this.library.hasDefaultDeviceChanged()) {
                            LOGGER.info("System default audio device has changed!");
                            this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.CHANGE_DETECTED);
                        }
                    } else if (!this.library.getCurrentDeviceName().equals(s) && this.library.getAvailableSoundDevices().contains(s)) {
                        LOGGER.info("Preferred audio device has become available!");
                        this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.CHANGE_DETECTED);
                    }
                    this.devicePoolState.compareAndSet(DeviceCheckState.ONGOING, DeviceCheckState.NO_CHANGE);
                });
            }
        }
        return this.devicePoolState.compareAndSet(DeviceCheckState.CHANGE_DETECTED, DeviceCheckState.NO_CHANGE);
    }

    public void tick(boolean p_120303_) {
        if (this.shouldChangeDevice()) {
            this.reload();
        }
        if (!p_120303_) {
            this.tickInGameSound();
        } else {
            this.tickMusicWhenPaused();
        }
        this.channelAccess.scheduleTick();
    }

    private void tickInGameSound() {
        ++this.tickCount;
        this.queuedTickableSounds.stream().filter(SoundInstance::canPlaySound).forEach(this::play);
        this.queuedTickableSounds.clear();
        for (TickableSoundInstance tickablesoundinstance : this.tickingSounds) {
            if (!tickablesoundinstance.canPlaySound()) {
                this.stop((SoundInstance)tickablesoundinstance);
            }
            tickablesoundinstance.tick();
            if (tickablesoundinstance.isStopped()) {
                this.stop((SoundInstance)tickablesoundinstance);
                continue;
            }
            float f = this.calculateVolume((SoundInstance)tickablesoundinstance);
            float f1 = this.calculatePitch((SoundInstance)tickablesoundinstance);
            Vec3 vec3 = new Vec3(tickablesoundinstance.getX(), tickablesoundinstance.getY(), tickablesoundinstance.getZ());
            ChannelAccess.ChannelHandle channelaccess$channelhandle = this.instanceToChannel.get(tickablesoundinstance);
            if (channelaccess$channelhandle == null) continue;
            channelaccess$channelhandle.execute(p_194478_ -> {
                p_194478_.setVolume(f);
                p_194478_.setPitch(f1);
                p_194478_.setSelfPosition(vec3);
            });
        }
        Iterator<Map.Entry<SoundInstance, ChannelAccess.ChannelHandle>> iterator = this.instanceToChannel.entrySet().iterator();
        while (iterator.hasNext()) {
            int i;
            Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry = iterator.next();
            ChannelAccess.ChannelHandle channelaccess$channelhandle1 = entry.getValue();
            SoundInstance soundinstance = entry.getKey();
            if (!channelaccess$channelhandle1.isStopped() || (i = this.soundDeleteTime.get(soundinstance).intValue()) > this.tickCount) continue;
            if (SoundEngine.shouldLoopManually(soundinstance)) {
                this.queuedSounds.put(soundinstance, this.tickCount + soundinstance.getDelay());
            }
            iterator.remove();
            LOGGER.debug(MARKER, "Removed channel {} because it's not playing anymore", (Object)channelaccess$channelhandle1);
            this.soundDeleteTime.remove(soundinstance);
            try {
                this.instanceBySource.remove((Object)soundinstance.getSource(), (Object)soundinstance);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(soundinstance instanceof TickableSoundInstance)) continue;
            this.tickingSounds.remove(soundinstance);
        }
        Iterator<Map.Entry<SoundInstance, Integer>> iterator1 = this.queuedSounds.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<SoundInstance, Integer> entry1 = iterator1.next();
            if (this.tickCount < entry1.getValue()) continue;
            SoundInstance soundinstance1 = entry1.getKey();
            if (soundinstance1 instanceof TickableSoundInstance) {
                ((TickableSoundInstance)soundinstance1).tick();
            }
            this.play(soundinstance1);
            iterator1.remove();
        }
    }

    private void tickMusicWhenPaused() {
        Iterator<Map.Entry<SoundInstance, ChannelAccess.ChannelHandle>> iterator = this.instanceToChannel.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry = iterator.next();
            ChannelAccess.ChannelHandle channelaccess$channelhandle = entry.getValue();
            SoundInstance soundinstance = entry.getKey();
            if (soundinstance.getSource() != SoundSource.MUSIC || !channelaccess$channelhandle.isStopped()) continue;
            iterator.remove();
            LOGGER.debug(MARKER, "Removed channel {} because it's not playing anymore", (Object)channelaccess$channelhandle);
            this.soundDeleteTime.remove(soundinstance);
            this.instanceBySource.remove((Object)soundinstance.getSource(), (Object)soundinstance);
        }
    }

    private static boolean requiresManualLooping(SoundInstance p_120316_) {
        return p_120316_.getDelay() > 0;
    }

    private static boolean shouldLoopManually(SoundInstance p_120319_) {
        return p_120319_.isLooping() && SoundEngine.requiresManualLooping(p_120319_);
    }

    private static boolean shouldLoopAutomatically(SoundInstance p_120322_) {
        return p_120322_.isLooping() && !SoundEngine.requiresManualLooping(p_120322_);
    }

    public boolean isActive(SoundInstance p_120306_) {
        if (!this.loaded) {
            return false;
        }
        return this.soundDeleteTime.containsKey(p_120306_) && this.soundDeleteTime.get(p_120306_) <= this.tickCount ? true : this.instanceToChannel.containsKey(p_120306_);
    }

    public PlayResult play(SoundInstance p_120313_) {
        Sound sound;
        if (!this.loaded) {
            return PlayResult.NOT_STARTED;
        }
        if (!p_120313_.canPlaySound()) {
            return PlayResult.NOT_STARTED;
        }
        if ((p_120313_ = ForgeHooksClient.playSound((SoundEngine)this, (SoundInstance)p_120313_)) == null || !p_120313_.canPlaySound()) {
            return PlayResult.NOT_STARTED;
        }
        WeighedSoundEvents weighedsoundevents = p_120313_.resolve(this.soundManager);
        Identifier identifier = p_120313_.getIdentifier();
        if (weighedsoundevents == null) {
            if (ONLY_WARN_ONCE.add(identifier)) {
                LOGGER.warn(MARKER, "Unable to play unknown soundEvent: {}", (Object)identifier);
            }
            if (!SharedConstants.DEBUG_SUBTITLES) {
                return PlayResult.NOT_STARTED;
            }
            weighedsoundevents = new WeighedSoundEvents(identifier, MISSING_SOUND);
        }
        if ((sound = p_120313_.getSound()) == SoundManager.INTENTIONALLY_EMPTY_SOUND) {
            return PlayResult.NOT_STARTED;
        }
        if (sound == SoundManager.EMPTY_SOUND) {
            if (ONLY_WARN_ONCE.add(identifier)) {
                LOGGER.warn(MARKER, "Unable to play empty soundEvent: {}", (Object)identifier);
            }
            return PlayResult.NOT_STARTED;
        }
        float f = p_120313_.getVolume();
        float f1 = Math.max(f, 1.0f) * (float)sound.getAttenuationDistance();
        SoundSource soundsource = p_120313_.getSource();
        float f2 = this.calculateVolume(f, soundsource);
        float f3 = this.calculatePitch(p_120313_);
        SoundInstance.Attenuation soundinstance$attenuation = p_120313_.getAttenuation();
        boolean flag = p_120313_.isRelative();
        if (!this.listeners.isEmpty()) {
            float f4 = !flag && soundinstance$attenuation != SoundInstance.Attenuation.NONE ? f1 : Float.POSITIVE_INFINITY;
            for (SoundEventListener soundeventlistener : this.listeners) {
                soundeventlistener.onPlaySound(p_120313_, weighedsoundevents, f4);
            }
        }
        boolean flag2 = false;
        if (f2 == 0.0f) {
            if (!p_120313_.canStartSilent() && soundsource != SoundSource.MUSIC) {
                LOGGER.debug(MARKER, "Skipped playing sound {}, volume was zero.", (Object)sound.getLocation());
                return PlayResult.NOT_STARTED;
            }
            flag2 = true;
        }
        Vec3 vec3 = new Vec3(p_120313_.getX(), p_120313_.getY(), p_120313_.getZ());
        boolean flag3 = SoundEngine.shouldLoopAutomatically(p_120313_);
        boolean flag1 = sound.shouldStream();
        CompletableFuture completablefuture = this.channelAccess.createHandle(sound.shouldStream() ? Library.Pool.STREAMING : Library.Pool.STATIC);
        ChannelAccess.ChannelHandle channelaccess$channelhandle = (ChannelAccess.ChannelHandle)completablefuture.join();
        if (channelaccess$channelhandle == null) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                LOGGER.warn("Failed to create new sound handle");
            }
            return PlayResult.NOT_STARTED;
        }
        LOGGER.debug(MARKER, "Playing sound {} for event {}", (Object)sound.getLocation(), (Object)identifier);
        this.soundDeleteTime.put(p_120313_, this.tickCount + 20);
        this.instanceToChannel.put(p_120313_, channelaccess$channelhandle);
        this.instanceBySource.put((Object)soundsource, (Object)p_120313_);
        channelaccess$channelhandle.execute(p_194488_ -> {
            p_194488_.setPitch(f3);
            p_194488_.setVolume(f2);
            if (soundinstance$attenuation == SoundInstance.Attenuation.LINEAR) {
                p_194488_.linearAttenuation(f1);
            } else {
                p_194488_.disableAttenuation();
            }
            p_194488_.setLooping(flag3 && !flag1);
            p_194488_.setSelfPosition(vec3);
            p_194488_.setRelative(flag);
        });
        SoundInstance soundinstance = p_120313_;
        if (!flag1) {
            this.soundBuffers.getCompleteBuffer(sound.getPath()).thenAccept(p_422528_ -> channelaccess$channelhandle.execute(p_194495_ -> {
                p_194495_.attachStaticBuffer(p_422528_);
                p_194495_.play();
                ForgeEventFactoryClient.onPlaySoundSource((SoundEngine)this, (SoundInstance)soundinstance, (Channel)p_194495_);
            }));
        } else {
            this.soundBuffers.getStream(sound.getPath(), flag3).thenAccept(p_430918_ -> channelaccess$channelhandle.execute(p_194498_ -> {
                p_194498_.attachBufferStream(p_430918_);
                p_194498_.play();
                ForgeEventFactoryClient.onPlayStreamingSource((SoundEngine)this, (SoundInstance)soundinstance, (Channel)p_194498_);
            }));
        }
        if (p_120313_ instanceof TickableSoundInstance) {
            this.tickingSounds.add((TickableSoundInstance)p_120313_);
        }
        return flag2 ? PlayResult.STARTED_SILENTLY : PlayResult.STARTED;
    }

    public void queueTickingSound(TickableSoundInstance p_120283_) {
        this.queuedTickableSounds.add(p_120283_);
    }

    public void requestPreload(Sound p_120273_) {
        this.preloadQueue.add(p_120273_);
    }

    private float calculatePitch(SoundInstance p_120325_) {
        return Mth.clamp(p_120325_.getPitch(), 0.5f, 2.0f);
    }

    private float calculateVolume(SoundInstance p_120328_) {
        return this.calculateVolume(p_120328_.getVolume(), p_120328_.getSource());
    }

    private float calculateVolume(float p_235258_, SoundSource p_235259_) {
        return Mth.clamp(p_235258_, 0.0f, 1.0f) * Mth.clamp(this.options.getFinalSoundSourceVolume(p_235259_), 0.0f, 1.0f) * this.gainBySource.getFloat((Object)p_235259_);
    }

    public void pauseAllExcept(SoundSource ... p_406622_) {
        if (this.loaded) {
            for (Map.Entry<SoundInstance, ChannelAccess.ChannelHandle> entry : this.instanceToChannel.entrySet()) {
                if (List.of(p_406622_).contains((Object)entry.getKey().getSource())) continue;
                entry.getValue().execute(Channel::pause);
            }
        }
    }

    public void resume() {
        if (this.loaded) {
            this.channelAccess.executeOnChannels(p_194510_ -> p_194510_.forEach(Channel::unpause));
        }
    }

    public void playDelayed(SoundInstance p_120277_, int p_120278_) {
        this.queuedSounds.put(p_120277_, this.tickCount + p_120278_);
    }

    public void updateSource(Camera p_120271_) {
        if (this.loaded && p_120271_.isInitialized()) {
            ListenerTransform listenertransform = new ListenerTransform(p_120271_.position(), new Vec3(p_120271_.forwardVector()), new Vec3(p_120271_.upVector()));
            this.executor.execute(() -> this.listener.setTransform(listenertransform));
        }
    }

    public void stop(@Nullable Identifier p_450572_, @Nullable SoundSource p_120301_) {
        if (p_120301_ != null) {
            for (SoundInstance soundinstance : this.instanceBySource.get((Object)p_120301_)) {
                if (p_450572_ != null && !soundinstance.getIdentifier().equals(p_450572_)) continue;
                this.stop(soundinstance);
            }
        } else if (p_450572_ == null) {
            this.stopAll();
        } else {
            for (SoundInstance soundinstance1 : this.instanceToChannel.keySet()) {
                if (!soundinstance1.getIdentifier().equals(p_450572_)) continue;
                this.stop(soundinstance1);
            }
        }
    }

    public String getDebugString() {
        return this.library.getDebugString();
    }

    public List<String> getAvailableSoundDevices() {
        return this.library.getAvailableSoundDevices();
    }

    public ListenerTransform getListenerTransform() {
        return this.listener.getTransform();
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum DeviceCheckState {
        ONGOING,
        CHANGE_DETECTED,
        NO_CHANGE;

    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum PlayResult {
        STARTED,
        STARTED_SILENTLY,
        NOT_STARTED;

    }
}

