/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final StringRepresentable.EnumCodec<Direction> CODEC;
    public static final Codec<Direction> VERTICAL_CODEC;
    public static final IntFunction<Direction> BY_ID;
    public static final StreamCodec<ByteBuf, Direction> STREAM_CODEC;
    @Deprecated
    public static final Codec<Direction> LEGACY_ID_CODEC;
    @Deprecated
    public static final Codec<Direction> LEGACY_ID_CODEC_2D;
    private static final ImmutableList<Axis> YXZ_AXIS_ORDER;
    private static final ImmutableList<Axis> YZX_AXIS_ORDER;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i normal;
    private final Vec3 normalVec3;
    private final Vector3fc normalVec3f;
    private static final Direction[] VALUES;
    private static final List<Direction> VALUES_VIEW;
    private static final List<Direction> UPDATE_ORDER;
    private static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;

    public static final List<Direction> valuesView() {
        return VALUES_VIEW;
    }

    public static final List<Direction> getUpdateOrder() {
        return UPDATE_ORDER;
    }

    private Direction(int p_122356_, int p_122357_, int p_122358_, String p_122359_, AxisDirection p_122360_, Axis p_122361_, Vec3i p_122362_) {
        this.data3d = p_122356_;
        this.data2d = p_122358_;
        this.oppositeIndex = p_122357_;
        this.name = p_122359_;
        this.axis = p_122361_;
        this.axisDirection = p_122360_;
        this.normal = p_122362_;
        this.normalVec3 = Vec3.atLowerCornerOf(p_122362_);
        this.normalVec3f = new Vector3f((float)p_122362_.getX(), (float)p_122362_.getY(), (float)p_122362_.getZ());
    }

    public static Direction[] orderedByNearest(Entity p_122383_) {
        Direction direction2;
        float f = p_122383_.getViewXRot(1.0f) * ((float)Math.PI / 180);
        float f1 = -p_122383_.getViewYRot(1.0f) * ((float)Math.PI / 180);
        float f2 = Mth.sin(f);
        float f3 = Mth.cos(f);
        float f4 = Mth.sin(f1);
        float f5 = Mth.cos(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.makeDirectionArray(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.makeDirectionArray(direction, direction2, direction1) : Direction.makeDirectionArray(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.makeDirectionArray(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.makeDirectionArray(direction2, direction, direction1) : Direction.makeDirectionArray(direction2, direction1, direction);
    }

    private static Direction[] makeDirectionArray(Direction p_122399_, Direction p_122400_, Direction p_122401_) {
        return new Direction[]{p_122399_, p_122400_, p_122401_, p_122401_.getOpposite(), p_122400_.getOpposite(), p_122399_.getOpposite()};
    }

    public static Direction rotate(Matrix4fc p_394866_, Direction p_254252_) {
        Vector3f vector3f = p_394866_.transformDirection(p_254252_.normalVec3f, new Vector3f());
        return Direction.getApproximateNearest(vector3f.x(), vector3f.y(), vector3f.z());
    }

    public static Collection<Direction> allShuffled(RandomSource p_235668_) {
        return Util.shuffledCopy(Direction.values(), p_235668_);
    }

    public static Stream<Direction> stream() {
        return Stream.of(VALUES);
    }

    public static float getYRot(Direction p_360754_) {
        return switch (p_360754_.ordinal()) {
            case 2 -> 180.0f;
            case 3 -> 0.0f;
            case 4 -> 90.0f;
            case 5 -> -90.0f;
            default -> throw new IllegalStateException("No y-Rot for vertical axis: " + String.valueOf(p_360754_));
        };
    }

    public Quaternionf getRotation() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Quaternionf().rotationX((float)Math.PI);
            case 1 -> new Quaternionf();
            case 2 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, (float)Math.PI);
            case 3 -> new Quaternionf().rotationX(1.5707964f);
            case 4 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, 1.5707964f);
            case 5 -> new Quaternionf().rotationXYZ(1.5707964f, 0.0f, -1.5707964f);
        };
    }

    public int get3DDataValue() {
        return this.data3d;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public static Direction getFacingAxis(Entity p_175358_, Axis p_175359_) {
        return switch (p_175359_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (EAST.isFacingAngle(p_175358_.getViewYRot(1.0f))) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (p_175358_.getViewXRot(1.0f) < 0.0f) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> SOUTH.isFacingAngle(p_175358_.getViewYRot(1.0f)) ? SOUTH : NORTH;
        };
    }

    public Direction getOpposite() {
        return Direction.from3DDataValue(this.oppositeIndex);
    }

    public Direction getClockWise(Axis p_175363_) {
        return switch (p_175363_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != WEST && this != EAST) {
                    yield this.getClockWiseX();
                }
                yield this;
            }
            case 1 -> {
                if (this != UP && this != DOWN) {
                    yield this.getClockWise();
                }
                yield this;
            }
            case 2 -> this != NORTH && this != SOUTH ? this.getClockWiseZ() : this;
        };
    }

    public Direction getCounterClockWise(Axis p_175365_) {
        return switch (p_175365_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (this != WEST && this != EAST) {
                    yield this.getCounterClockWiseX();
                }
                yield this;
            }
            case 1 -> {
                if (this != UP && this != DOWN) {
                    yield this.getCounterClockWise();
                }
                yield this;
            }
            case 2 -> this != NORTH && this != SOUTH ? this.getCounterClockWiseZ() : this;
        };
    }

    public Direction getClockWise() {
        return switch (this.ordinal()) {
            case 2 -> EAST;
            case 3 -> WEST;
            case 4 -> NORTH;
            case 5 -> SOUTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseX() {
        return switch (this.ordinal()) {
            case 0 -> SOUTH;
            case 1 -> NORTH;
            case 2 -> DOWN;
            case 3 -> UP;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getCounterClockWiseX() {
        return switch (this.ordinal()) {
            case 0 -> NORTH;
            case 1 -> SOUTH;
            case 2 -> UP;
            case 3 -> DOWN;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf(this));
        };
    }

    private Direction getClockWiseZ() {
        return switch (this.ordinal()) {
            case 0 -> WEST;
            case 1 -> EAST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> UP;
            case 5 -> DOWN;
        };
    }

    private Direction getCounterClockWiseZ() {
        return switch (this.ordinal()) {
            case 0 -> EAST;
            case 1 -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf(this));
            case 4 -> DOWN;
            case 5 -> UP;
        };
    }

    public Direction getCounterClockWise() {
        return switch (this.ordinal()) {
            case 2 -> WEST;
            case 3 -> EAST;
            case 4 -> SOUTH;
            case 5 -> NORTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf(this));
        };
    }

    public int getStepX() {
        return this.normal.getX();
    }

    public int getStepY() {
        return this.normal.getY();
    }

    public int getStepZ() {
        return this.normal.getZ();
    }

    public Vector3f step() {
        return new Vector3f(this.normalVec3f);
    }

    public String getName() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public static @Nullable Direction byName(String p_122403_) {
        return CODEC.byName(p_122403_);
    }

    public static Direction from3DDataValue(int p_122377_) {
        return BY_3D_DATA[Mth.abs(p_122377_ % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int p_122408_) {
        return BY_2D_DATA[Mth.abs(p_122408_ % BY_2D_DATA.length)];
    }

    public static Direction fromYRot(double p_122365_) {
        return Direction.from2DDataValue(Mth.floor(p_122365_ / 90.0 + 0.5) & 3);
    }

    public static Direction fromAxisAndDirection(Axis p_122388_, AxisDirection p_122389_) {
        return switch (p_122388_.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (p_122389_ == AxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (p_122389_ == AxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> p_122389_ == AxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    public float toYRot() {
        return (this.data2d & 3) * 90;
    }

    public static Direction getRandom(RandomSource p_235673_) {
        return Util.getRandom(VALUES, p_235673_);
    }

    public static Direction getApproximateNearest(double p_368065_, double p_363574_, double p_369926_) {
        return Direction.getApproximateNearest((float)p_368065_, (float)p_363574_, (float)p_369926_);
    }

    public static Direction getApproximateNearest(float p_122373_, float p_122374_, float p_122375_) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : VALUES) {
            float f1 = p_122373_ * (float)direction1.normal.getX() + p_122374_ * (float)direction1.normal.getY() + p_122375_ * (float)direction1.normal.getZ();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public static Direction getApproximateNearest(Vec3 p_361748_) {
        return Direction.getApproximateNearest(p_361748_.x, p_361748_.y, p_361748_.z);
    }

    @Contract(value="_,_,_,!null->!null;_,_,_,_->_")
    public static @Nullable Direction getNearest(int p_367360_, int p_362027_, int p_368517_, @Nullable Direction p_368118_) {
        int i = Math.abs(p_367360_);
        int j = Math.abs(p_362027_);
        int k = Math.abs(p_368517_);
        if (i > k && i > j) {
            return p_367360_ < 0 ? WEST : EAST;
        }
        if (k > i && k > j) {
            return p_368517_ < 0 ? NORTH : SOUTH;
        }
        if (j > i && j > k) {
            return p_362027_ < 0 ? DOWN : UP;
        }
        return p_368118_;
    }

    @Contract(value="_,!null->!null;_,_->_")
    public static @Nullable Direction getNearest(Vec3i p_365890_, @Nullable Direction p_366391_) {
        return Direction.getNearest(p_365890_.getX(), p_365890_.getY(), p_365890_.getZ(), p_366391_);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    private static DataResult<Direction> verifyVertical(Direction p_194529_) {
        return p_194529_.getAxis().isVertical() ? DataResult.success((Object)p_194529_) : DataResult.error(() -> "Expected a vertical direction");
    }

    public static Direction get(AxisDirection p_122391_, Axis p_122392_) {
        for (Direction direction : VALUES) {
            if (direction.getAxisDirection() != p_122391_ || direction.getAxis() != p_122392_) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + String.valueOf((Object)p_122391_) + " " + String.valueOf(p_122392_));
    }

    public static ImmutableList<Axis> axisStepOrder(Vec3 p_423968_) {
        return Math.abs(p_423968_.x) < Math.abs(p_423968_.z) ? YZX_AXIS_ORDER : YXZ_AXIS_ORDER;
    }

    public Vec3i getUnitVec3i() {
        return this.normal;
    }

    public Vec3 getUnitVec3() {
        return this.normalVec3;
    }

    public Vector3fc getUnitVec3f() {
        return this.normalVec3f;
    }

    public boolean isFacingAngle(float p_122371_) {
        float f = p_122371_ * ((float)Math.PI / 180);
        float f1 = -Mth.sin(f);
        float f2 = Mth.cos(f);
        return (float)this.normal.getX() * f1 + (float)this.normal.getZ() * f2 > 0.0f;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Direction::values);
        VERTICAL_CODEC = CODEC.validate(Direction::verifyVertical);
        BY_ID = ByIdMap.continuous(Direction::get3DDataValue, Direction.values(), ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Direction::get3DDataValue);
        LEGACY_ID_CODEC = Codec.BYTE.xmap(Direction::from3DDataValue, p_389654_ -> (byte)p_389654_.get3DDataValue());
        LEGACY_ID_CODEC_2D = Codec.BYTE.xmap(Direction::from2DDataValue, p_389653_ -> (byte)p_389653_.get2DDataValue());
        YXZ_AXIS_ORDER = ImmutableList.of((Object)Axis.Y, (Object)Axis.X, (Object)Axis.Z);
        YZX_AXIS_ORDER = ImmutableList.of((Object)Axis.Y, (Object)Axis.Z, (Object)Axis.X);
        VALUES = Direction.values();
        VALUES_VIEW = Collections.unmodifiableList(Arrays.asList(VALUES));
        UPDATE_ORDER = Collections.unmodifiableList(Stream.concat(Plane.HORIZONTAL.stream(), Plane.VERTICAL.stream()).toList());
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(p_235687_ -> p_235687_.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(p_235685_ -> p_235685_.getAxis().isHorizontal()).sorted(Comparator.comparingInt(p_235683_ -> p_235683_.data2d)).toArray(Direction[]::new);
    }

    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int choose(int p_122496_, int p_122497_, int p_122498_) {
                return p_122496_;
            }

            @Override
            public boolean choose(boolean p_396045_, boolean p_391922_, boolean p_397565_) {
                return p_396045_;
            }

            @Override
            public double choose(double p_122492_, double p_122493_, double p_122494_) {
                return p_122492_;
            }

            @Override
            public Direction getPositive() {
                return EAST;
            }

            @Override
            public Direction getNegative() {
                return WEST;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int p_122510_, int p_122511_, int p_122512_) {
                return p_122511_;
            }

            @Override
            public double choose(double p_122506_, double p_122507_, double p_122508_) {
                return p_122507_;
            }

            @Override
            public boolean choose(boolean p_395140_, boolean p_397530_, boolean p_392505_) {
                return p_397530_;
            }

            @Override
            public Direction getPositive() {
                return UP;
            }

            @Override
            public Direction getNegative() {
                return DOWN;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int p_122524_, int p_122525_, int p_122526_) {
                return p_122526_;
            }

            @Override
            public double choose(double p_122520_, double p_122521_, double p_122522_) {
                return p_122522_;
            }

            @Override
            public boolean choose(boolean p_396144_, boolean p_396392_, boolean p_391823_) {
                return p_391823_;
            }

            @Override
            public Direction getPositive() {
                return SOUTH;
            }

            @Override
            public Direction getNegative() {
                return NORTH;
            }
        };

        public static final Axis[] VALUES;
        public static final StringRepresentable.EnumCodec<Axis> CODEC;
        private final String name;

        private Axis(String p_122456_) {
            this.name = p_122456_;
        }

        public static @Nullable Axis byName(String p_122474_) {
            return CODEC.byName(p_122474_);
        }

        public String getName() {
            return this.name;
        }

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public abstract Direction getPositive();

        public abstract Direction getNegative();

        public Direction[] getDirections() {
            return new Direction[]{this.getPositive(), this.getNegative()};
        }

        public String toString() {
            return this.name;
        }

        public static Axis getRandom(RandomSource p_235689_) {
            return Util.getRandom(VALUES, p_235689_);
        }

        @Override
        public boolean test(@Nullable Direction p_122472_) {
            return p_122472_ != null && p_122472_.getAxis() == this;
        }

        public Plane getPlane() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> Plane.HORIZONTAL;
                case 1 -> Plane.VERTICAL;
            };
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        public abstract boolean choose(boolean var1, boolean var2, boolean var3);

        static {
            VALUES = Axis.values();
            CODEC = StringRepresentable.fromEnum(Axis::values);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int step;
        private final String name;

        private AxisDirection(int p_122538_, String p_122539_) {
            this.step = p_122538_;
            this.name = p_122539_;
        }

        public int getStep() {
            return this.step;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] faces;
        private final Axis[] axis;

        private Plane(Direction[] p_122555_, Axis[] p_122556_) {
            this.faces = p_122555_;
            this.axis = p_122556_;
        }

        public Direction getRandomDirection(RandomSource p_235691_) {
            return Util.getRandom(this.faces, p_235691_);
        }

        public Axis getRandomAxis(RandomSource p_235693_) {
            return Util.getRandom(this.axis, p_235693_);
        }

        @Override
        public boolean test(@Nullable Direction p_122559_) {
            return p_122559_ != null && p_122559_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.faces);
        }

        public Stream<Direction> stream() {
            return Arrays.stream(this.faces);
        }

        public List<Direction> shuffledCopy(RandomSource p_235695_) {
            return Util.shuffledCopy(this.faces, p_235695_);
        }

        public int length() {
            return this.faces.length;
        }
    }
}

