/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraftforge.common.extensions.IForgeHolderSet;
import org.jspecify.annotations.Nullable;

public interface HolderSet<T>
extends Iterable<Holder<T>>,
IForgeHolderSet<T> {
    public Stream<Holder<T>> stream();

    public int size();

    public boolean isBound();

    public Either<TagKey<T>, List<Holder<T>>> unwrap();

    public Optional<Holder<T>> getRandomElement(RandomSource var1);

    public Holder<T> get(int var1);

    public boolean contains(Holder<T> var1);

    public boolean canSerializeIn(HolderOwner<T> var1);

    public Optional<TagKey<T>> unwrapKey();

    @Deprecated
    @VisibleForTesting
    public static <T> Named<T> emptyNamed(HolderOwner<T> p_255858_, TagKey<T> p_256459_) {
        return new Named<T>((HolderOwner)p_255858_, (TagKey)p_256459_){

            @Override
            protected List<Holder<T>> contents() {
                throw new UnsupportedOperationException("Tag " + String.valueOf(this.key()) + " can't be dereferenced during construction");
            }
        };
    }

    public static <T> HolderSet<T> empty() {
        return Direct.EMPTY;
    }

    @SafeVarargs
    public static <T> Direct<T> direct(Holder<T> ... p_205810_) {
        return new Direct<T>(List.of(p_205810_));
    }

    public static <T> Direct<T> direct(List<? extends Holder<T>> p_205801_) {
        return new Direct(List.copyOf(p_205801_));
    }

    @SafeVarargs
    public static <E, T> Direct<T> direct(Function<E, Holder<T>> p_205807_, E ... p_205808_) {
        return HolderSet.direct(Stream.of(p_205808_).map(p_205807_).toList());
    }

    public static <E, T> Direct<T> direct(Function<E, Holder<T>> p_205804_, Collection<E> p_298882_) {
        return HolderSet.direct(p_298882_.stream().map(p_205804_).toList());
    }

    public static final class Direct<T>
    extends ListBacked<T> {
        static final Direct<?> EMPTY = new Direct(List.of());
        private final List<Holder<T>> contents;
        private @Nullable Set<Holder<T>> contentsSet;

        Direct(List<Holder<T>> p_205814_) {
            this.contents = p_205814_;
        }

        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        public boolean isBound() {
            return true;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.right(this.contents);
        }

        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.empty();
        }

        @Override
        public boolean contains(Holder<T> p_205816_) {
            if (this.contentsSet == null) {
                this.contentsSet = Set.copyOf(this.contents);
            }
            return this.contentsSet.contains(p_205816_);
        }

        public String toString() {
            return "DirectSet[" + String.valueOf(this.contents) + "]";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object p_335031_) {
            if (this == p_335031_) {
                return true;
            }
            if (!(p_335031_ instanceof Direct)) return false;
            Direct direct = (Direct)p_335031_;
            if (!this.contents.equals(direct.contents)) return false;
            return true;
        }

        public int hashCode() {
            return this.contents.hashCode();
        }
    }

    public static class Named<T>
    extends ListBacked<T> {
        private final HolderOwner<T> owner;
        private final TagKey<T> key;
        private @Nullable List<Holder<T>> contents;
        private List<Runnable> invalidationCallbacks = new ArrayList<Runnable>();

        public Named(HolderOwner<T> p_256118_, TagKey<T> p_256597_) {
            this.owner = p_256118_;
            this.key = p_256597_;
        }

        public void bind(List<Holder<T>> p_205836_) {
            this.contents = List.copyOf(p_205836_);
            this.invalidationCallbacks.forEach(Runnable::run);
        }

        public TagKey<T> key() {
            return this.key;
        }

        @Override
        protected List<Holder<T>> contents() {
            if (this.contents == null) {
                throw new IllegalStateException("Trying to access unbound tag '" + String.valueOf(this.key) + "' from registry " + String.valueOf(this.owner));
            }
            return this.contents;
        }

        @Override
        public boolean isBound() {
            return this.contents != null;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.of(this.key);
        }

        @Override
        public boolean contains(Holder<T> p_205834_) {
            return p_205834_.is(this.key);
        }

        public String toString() {
            return "NamedSet(" + String.valueOf(this.key) + ")[" + String.valueOf(this.contents) + "]";
        }

        @Override
        public boolean canSerializeIn(HolderOwner<T> p_256542_) {
            return this.owner.canSerializeIn(p_256542_);
        }

        public void addInvalidationListener(Runnable runnable) {
            this.invalidationCallbacks.add(runnable);
        }
    }

    public static abstract class ListBacked<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> contents();

        @Override
        public int size() {
            return this.contents().size();
        }

        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.contents().spliterator();
        }

        @Override
        public Iterator<Holder<T>> iterator() {
            return this.contents().iterator();
        }

        @Override
        public Stream<Holder<T>> stream() {
            return this.contents().stream();
        }

        @Override
        public Optional<Holder<T>> getRandomElement(RandomSource p_235714_) {
            return Util.getRandomSafe(this.contents(), p_235714_);
        }

        @Override
        public Holder<T> get(int p_205823_) {
            return this.contents().get(p_205823_);
        }

        @Override
        public boolean canSerializeIn(HolderOwner<T> p_255876_) {
            return true;
        }
    }
}

