/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.jspecify.annotations.Nullable;

public class MappedRegistry<T>
implements WritableRegistry<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = ForgeRegistry.REGISTRIES;
    private final ResourceKey<? extends Registry<T>> key;
    private final ObjectList<Holder.Reference<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)Util.make(new Reference2IntOpenHashMap(), p_308420_ -> p_308420_.defaultReturnValue(-1));
    private final Map<Identifier, Holder.Reference<T>> byLocation = new HashMap<Identifier, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, Holder.Reference<T>> byKey = new HashMap<ResourceKey<T>, Holder.Reference<T>>();
    private final Map<T, Holder.Reference<T>> byValue = new IdentityHashMap<T, Holder.Reference<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private final Map<TagKey<T>, HolderSet.Named<T>> frozenTags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    TagSet<T> allTags = TagSet.unbound();
    private boolean frozen;
    protected @Nullable Map<T, Holder.Reference<T>> unregisteredIntrusiveHolders;
    private static final Set<Identifier> KNOWN = new LinkedHashSet<Identifier>();

    @Override
    public Stream<HolderSet.Named<T>> listTags() {
        return this.getTags();
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_249899_, Lifecycle p_252249_) {
        this(p_249899_, p_252249_, false);
    }

    public MappedRegistry(ResourceKey<? extends Registry<T>> p_252132_, Lifecycle p_249215_, boolean p_251014_) {
        this.key = p_252132_;
        this.registryLifecycle = p_249215_;
        if (p_251014_) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.Reference<T>>();
        }
    }

    @Override
    public ResourceKey<? extends Registry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> p_205922_) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(p_205922_) + ")");
        }
    }

    @Override
    public Holder.Reference<T> register(ResourceKey<T> p_256252_, T p_256591_, RegistrationInfo p_329661_) {
        Holder.Reference reference;
        this.markKnown();
        this.validateWrite(p_256252_);
        Objects.requireNonNull(p_256252_);
        Objects.requireNonNull(p_256591_);
        if (this.byLocation.containsKey(p_256252_.identifier())) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(p_256252_) + "' to registry"));
        }
        if (this.byValue.containsKey(p_256591_)) {
            throw Util.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(p_256591_) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            reference = this.unregisteredIntrusiveHolders.remove(p_256591_);
            if (reference == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(p_256252_) + ":" + String.valueOf(p_256591_)));
            }
            reference.bindKey(p_256252_);
        } else {
            reference = this.byKey.computeIfAbsent(p_256252_, p_358082_ -> Holder.Reference.createStandAlone(this, p_358082_));
            reference.bindValue(p_256591_);
        }
        this.byKey.put(p_256252_, reference);
        this.byLocation.put(p_256252_.identifier(), reference);
        this.byValue.put(p_256591_, reference);
        int i = this.byId.size();
        this.byId.add((Object)reference);
        this.toId.put(p_256591_, i);
        this.registrationInfos.put(p_256252_, p_329661_);
        this.registryLifecycle = this.registryLifecycle.add(p_329661_.lifecycle());
        return reference;
    }

    @Override
    public @Nullable Identifier getKey(T p_122746_) {
        Holder.Reference<T> reference = this.byValue.get(p_122746_);
        return reference != null ? reference.key().identifier() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T p_122755_) {
        return Optional.ofNullable(this.byValue.get(p_122755_)).map(Holder.Reference::key);
    }

    @Override
    public int getId(@Nullable T p_122706_) {
        return this.toId.getInt(p_122706_);
    }

    @Override
    public @Nullable T getValue(@Nullable ResourceKey<T> p_122714_) {
        return MappedRegistry.getValueFromNullable(this.byKey.get(p_122714_));
    }

    @Override
    public @Nullable T byId(int p_122684_) {
        return p_122684_ >= 0 && p_122684_ < this.byId.size() ? (T)((Holder.Reference)this.byId.get(p_122684_)).value() : null;
    }

    @Override
    public Optional<Holder.Reference<T>> get(int p_205907_) {
        return p_205907_ >= 0 && p_205907_ < this.byId.size() ? Optional.ofNullable((Holder.Reference)this.byId.get(p_205907_)) : Optional.empty();
    }

    @Override
    public Optional<Holder.Reference<T>> get(Identifier p_457466_) {
        return Optional.ofNullable(this.byLocation.get(p_457466_));
    }

    @Override
    public Optional<Holder.Reference<T>> get(ResourceKey<T> p_205905_) {
        return Optional.ofNullable(this.byKey.get(p_205905_));
    }

    @Override
    public Optional<Holder.Reference<T>> getAny() {
        return this.byId.isEmpty() ? Optional.empty() : Optional.of((Holder.Reference)this.byId.getFirst());
    }

    @Override
    public Holder<T> wrapAsHolder(T p_263356_) {
        Holder.Reference<T> reference = this.byValue.get(p_263356_);
        return reference != null ? reference : Holder.direct(p_263356_);
    }

    protected Holder.Reference<T> getOrCreateHolderOrThrow(ResourceKey<T> p_248831_) {
        return this.byKey.computeIfAbsent(p_248831_, p_358081_ -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)p_358081_);
            return Holder.Reference.createStandAlone(this, p_358081_);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> p_331530_) {
        return Optional.ofNullable(this.registrationInfos.get(p_331530_));
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @Override
    public @Nullable T getValue(@Nullable Identifier p_459124_) {
        Holder.Reference<T> reference = this.byLocation.get(p_459124_);
        return MappedRegistry.getValueFromNullable(reference);
    }

    private static <T> @Nullable T getValueFromNullable(@Nullable Holder.Reference<T> p_205866_) {
        return p_205866_ != null ? (T)p_205866_.value() : null;
    }

    @Override
    public Set<Identifier> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Util.mapValuesLazy(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.Reference<T>> listElements() {
        return this.byId.stream();
    }

    @Override
    public Stream<HolderSet.Named<T>> getTags() {
        return this.allTags.getTags();
    }

    protected HolderSet.Named<T> getOrCreateTagForRegistration(TagKey<T> p_363833_) {
        return this.frozenTags.computeIfAbsent(p_363833_, this::createTag);
    }

    private HolderSet.Named<T> createTag(TagKey<T> p_211068_) {
        return new HolderSet.Named<T>(this, p_211068_);
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.Reference<T>> getRandom(RandomSource p_235716_) {
        return Util.getRandomSafe(this.byId, p_235716_);
    }

    @Override
    public boolean containsKey(Identifier p_452771_) {
        return this.byLocation.containsKey(p_452771_);
    }

    @Override
    public boolean containsKey(ResourceKey<T> p_175392_) {
        return this.byKey.containsKey(p_175392_);
    }

    @Override
    public Registry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        List<Identifier> list = this.byKey.entrySet().stream().filter(p_211055_ -> !((Holder.Reference)p_211055_.getValue()).isBound()).map(p_448560_ -> ((ResourceKey)p_448560_.getKey()).identifier()).sorted().toList();
        if (!list.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf(list));
        }
        if (this.unregisteredIntrusiveHolders != null && !this.unregisteredIntrusiveHolders.isEmpty()) {
            throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
        }
        if (this.allTags.isBound()) {
            throw new IllegalStateException("Tags already present before freezing");
        }
        List<Identifier> list1 = this.frozenTags.entrySet().stream().filter(p_358086_ -> !((HolderSet.Named)p_358086_.getValue()).isBound()).map(p_448561_ -> ((TagKey)p_448561_.getKey()).location()).sorted().toList();
        if (!list1.isEmpty()) {
            LOGGER.debug(MARKER, "Unbound tags in registry " + String.valueOf(this.key()) + ": " + String.valueOf(list1));
            this.bindAllUnboundTagsToEmpty();
        }
        this.allTags = TagSet.fromMap(this.frozenTags);
        this.refreshTagsInHolders();
        return this;
    }

    private void bindAllUnboundTagsToEmpty() {
        for (HolderSet.Named tag : this.frozenTags.values()) {
            if (tag.isBound()) continue;
            tag.bind(List.of());
        }
    }

    @Override
    public Holder.Reference<T> createIntrusiveHolder(T p_205915_) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(p_205915_, p_358092_ -> Holder.Reference.createIntrusive(this, p_358092_));
    }

    @Override
    public Optional<HolderSet.Named<T>> get(TagKey<T> p_365729_) {
        return this.allTags.get(p_365729_);
    }

    private Holder.Reference<T> validateAndUnwrapTagElement(TagKey<T> p_363318_, Holder<T> p_362647_) {
        if (!p_362647_.canSerializeIn(this)) {
            throw new IllegalStateException("Can't create named set " + String.valueOf(p_363318_) + " containing value " + String.valueOf(p_362647_) + " from outside registry " + String.valueOf(this));
        }
        if (p_362647_ instanceof Holder.Reference) {
            Holder.Reference reference = (Holder.Reference)p_362647_;
            return reference;
        }
        throw new IllegalStateException("Found direct holder " + String.valueOf(p_362647_) + " value in tag " + String.valueOf(p_363318_));
    }

    @Override
    public void bindTag(TagKey<T> p_361998_, List<Holder<T>> p_361891_) {
        this.validateWrite();
        this.getOrCreateTagForRegistration(p_361998_).bind(p_361891_);
    }

    void refreshTagsInHolders() {
        IdentityHashMap<Holder.Reference, List> map = new IdentityHashMap<Holder.Reference, List>();
        this.byKey.values().forEach(p_211801_ -> map.put((Holder.Reference)p_211801_, new ArrayList()));
        this.allTags.forEach((? super TagKey<T> p_358084_, ? super HolderSet.Named<T> p_358085_) -> {
            for (Holder holder : p_358085_) {
                Holder.Reference reference = this.validateAndUnwrapTagElement((TagKey<T>)p_358084_, holder);
                ((List)map.get(reference)).add(p_358084_);
            }
        });
        map.forEach(Holder.Reference::bindTags);
    }

    public void bindAllTagsToEmpty() {
        this.validateWrite();
        this.frozenTags.values().forEach(p_211792_ -> p_211792_.bind(List.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.Reference<T>> get(ResourceKey<T> p_255624_) {
                return Optional.of(this.getOrThrow(p_255624_));
            }

            @Override
            public Holder.Reference<T> getOrThrow(ResourceKey<T> p_362418_) {
                return MappedRegistry.this.getOrCreateHolderOrThrow(p_362418_);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_256277_) {
                return Optional.of(this.getOrThrow(p_256277_));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> p_365508_) {
                return MappedRegistry.this.getOrCreateTagForRegistration(p_365508_);
            }
        };
    }

    public boolean isIntrusive() {
        return this.unregisteredIntrusiveHolders != null;
    }

    public static Set<Identifier> getKnownRegistries() {
        return Collections.unmodifiableSet(KNOWN);
    }

    protected final void markKnown() {
        KNOWN.remove(this.key().identifier());
        KNOWN.add(this.key().identifier());
    }

    @Deprecated
    public void unfreeze() {
        this.frozen = false;
        this.allTags = TagSet.unbound();
    }

    @Override
    public Registry.PendingTags<T> prepareTagReload(TagLoader.LoadResult<T> p_368827_) {
        if (!this.frozen) {
            throw new IllegalStateException("Invalid method used for tag loading");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        final HashMap map = new HashMap();
        p_368827_.tags().forEach((? super K p_358090_, ? super V p_358091_) -> {
            HolderSet.Named<T> named = this.frozenTags.get(p_358090_);
            if (named == null) {
                named = this.createTag((TagKey<T>)p_358090_);
            }
            builder.put(p_358090_, named);
            map.put(p_358090_, List.copyOf(p_358091_));
        });
        final ImmutableMap immutablemap = builder.build();
        final HolderLookup.RegistryLookup.Delegate registrylookup = new HolderLookup.RegistryLookup.Delegate<T>(){

            @Override
            public HolderLookup.RegistryLookup<T> parent() {
                return MappedRegistry.this;
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> p_259486_) {
                return Optional.ofNullable((HolderSet.Named)immutablemap.get(p_259486_));
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return immutablemap.values().stream();
            }
        };
        return new Registry.PendingTags<T>(){

            @Override
            public ResourceKey<? extends Registry<? extends T>> key() {
                return MappedRegistry.this.key();
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public HolderLookup.RegistryLookup<T> lookup() {
                return registrylookup;
            }

            @Override
            public List<Holder<T>> getPending(TagKey<T> key) {
                return map.getOrDefault(key, List.of());
            }

            @Override
            public void apply() {
                immutablemap.forEach((p_363053_, p_363988_) -> {
                    List list = map.getOrDefault(p_363053_, List.of());
                    p_363988_.bind(list);
                });
                MappedRegistry.this.allTags = TagSet.fromMap(immutablemap);
                MappedRegistry.this.refreshTagsInHolders();
            }
        };
    }

    protected static interface TagSet<T> {
        public static <T> TagSet<T> unbound() {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return false;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> p_369929_) {
                    throw new IllegalStateException("Tags not bound, trying to access " + String.valueOf(p_369929_));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> p_367948_) {
                    throw new IllegalStateException("Tags not bound");
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    throw new IllegalStateException("Tags not bound");
                }
            };
        }

        public static <T> TagSet<T> fromMap(final Map<TagKey<T>, HolderSet.Named<T>> p_364506_) {
            return new TagSet<T>(){

                @Override
                public boolean isBound() {
                    return true;
                }

                @Override
                public Optional<HolderSet.Named<T>> get(TagKey<T> p_364348_) {
                    return Optional.ofNullable((HolderSet.Named)p_364506_.get(p_364348_));
                }

                @Override
                public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> p_366521_) {
                    p_364506_.forEach(p_366521_);
                }

                @Override
                public Stream<HolderSet.Named<T>> getTags() {
                    return p_364506_.values().stream();
                }
            };
        }

        public boolean isBound();

        public Optional<HolderSet.Named<T>> get(TagKey<T> var1);

        public void forEach(BiConsumer<? super TagKey<T>, ? super HolderSet.Named<T>> var1);

        public Stream<HolderSet.Named<T>> getTags();
    }
}

