/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.extensions.IForgeTagAppender;

public interface TagAppender<E, T>
extends IForgeTagAppender<E, T> {
    public TagAppender<E, T> add(E var1);

    default public TagAppender<E, T> add(E ... p_406204_) {
        return this.addAll(Arrays.stream(p_406204_));
    }

    default public TagAppender<E, T> addAll(Collection<E> p_405923_) {
        p_405923_.forEach(this::add);
        return this;
    }

    default public TagAppender<E, T> addAll(Stream<E> p_406577_) {
        p_406577_.forEach(this::add);
        return this;
    }

    public TagAppender<E, T> addOptional(E var1);

    public TagAppender<E, T> addTag(TagKey<T> var1);

    public TagAppender<E, T> addOptionalTag(TagKey<T> var1);

    public static <T> TagAppender<ResourceKey<T>, T> forBuilder(TagBuilder p_407840_) {
        return TagAppender.forBuilder(p_407840_, "unknown");
    }

    public static <T> TagAppender<ResourceKey<T>, T> forBuilder(final TagBuilder p_407840_, final String source) {
        return new TagAppender<ResourceKey<T>, T>(){

            @Override
            public TagAppender<ResourceKey<T>, T> add(ResourceKey<T> p_406023_) {
                p_407840_.addElement(p_406023_.identifier());
                return this;
            }

            @Override
            public TagAppender<ResourceKey<T>, T> addOptional(ResourceKey<T> p_409233_) {
                p_407840_.addOptionalElement(p_409233_.identifier());
                return this;
            }

            @Override
            public TagAppender<ResourceKey<T>, T> addTag(TagKey<T> p_410264_) {
                p_407840_.addTag(p_410264_.location());
                return this;
            }

            @Override
            public TagAppender<ResourceKey<T>, T> addOptionalTag(TagKey<T> p_407223_) {
                p_407840_.addOptionalTag(p_407223_.location());
                return this;
            }

            public TagBuilder getInternalBuilder() {
                return p_407840_;
            }

            public String getSourceName() {
                return source;
            }

            public TagAppender<ResourceKey<T>, T> remove(ResourceKey<T> value) {
                return this.remove(value.identifier());
            }
        };
    }

    default public <U> TagAppender<U, T> map(final Function<U, E> p_409081_) {
        final TagAppender tagappender = this;
        return new TagAppender<U, T>(){

            @Override
            public TagAppender<U, T> add(U p_409420_) {
                tagappender.add(p_409081_.apply(p_409420_));
                return this;
            }

            @Override
            public TagAppender<U, T> addOptional(U p_410494_) {
                tagappender.add(p_409081_.apply(p_410494_));
                return this;
            }

            @Override
            public TagAppender<U, T> addTag(TagKey<T> p_409457_) {
                tagappender.addTag(p_409457_);
                return this;
            }

            @Override
            public TagAppender<U, T> addOptionalTag(TagKey<T> p_409695_) {
                tagappender.addOptionalTag(p_409695_);
                return this;
            }

            public TagBuilder getInternalBuilder() {
                return tagappender.getInternalBuilder();
            }

            public String getSourceName() {
                return tagappender.getSourceName();
            }

            public TagAppender<U, T> remove(U value) {
                tagappender.remove(p_409081_.apply(value));
                return this;
            }
        };
    }
}

