/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.tags;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Util;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;

public abstract class TagsProvider<T>
implements DataProvider {
    protected final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final CompletableFuture<Void> contentsDone = new CompletableFuture();
    private final CompletableFuture<TagLookup<T>> parentProvider;
    protected final ResourceKey<? extends Registry<T>> registryKey;
    protected final Map<Identifier, TagBuilder> builders = Maps.newLinkedHashMap();
    protected final String modId;
    @Nullable
    protected final ExistingFileHelper existingFileHelper;
    private final ExistingFileHelper.IResourceType resourceType;
    private final ExistingFileHelper.IResourceType elementResourceType;

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_) {
        this(p_256596_, p_255886_, p_256513_, "vanilla", null);
    }

    protected TagsProvider(PackOutput p_256596_, ResourceKey<? extends Registry<T>> p_255886_, CompletableFuture<HolderLookup.Provider> p_256513_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this(p_256596_, p_255886_, p_256513_, CompletableFuture.completedFuture(TagLookup.empty()), modId, existingFileHelper);
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_) {
        this(p_275432_, p_275476_, p_275222_, p_275565_, "vanilla", null);
    }

    protected TagsProvider(PackOutput p_275432_, ResourceKey<? extends Registry<T>> p_275476_, CompletableFuture<HolderLookup.Provider> p_275222_, CompletableFuture<TagLookup<T>> p_275565_, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        this.pathProvider = p_275432_.createRegistryTagsPathProvider(p_275476_);
        this.registryKey = p_275476_;
        this.parentProvider = p_275565_;
        this.lookupProvider = p_275222_;
        this.modId = modId;
        this.existingFileHelper = existingFileHelper;
        this.resourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", Registries.tagsDirPath(p_275476_));
        this.elementResourceType = new ExistingFileHelper.ResourceType(PackType.SERVER_DATA, ".json", Registries.elementsDirPath(p_275476_));
    }

    @Nullable
    protected Path getPath(Identifier id) {
        return this.pathProvider.json(id);
    }

    @Override
    public String getName() {
        return "Tags for " + String.valueOf(this.registryKey.identifier()) + " mod id " + this.modId;
    }

    protected abstract void addTags(HolderLookup.Provider var1);

    @Override
    public CompletableFuture<?> run(CachedOutput p_253684_) {
        record CombinedData<T>(HolderLookup.Provider contents, TagLookup<T> parent) {
        }
        return ((CompletableFuture)((CompletableFuture)this.createContentsProvider().thenApply(p_275895_ -> {
            this.contentsDone.complete(null);
            return p_275895_;
        })).thenCombineAsync(this.parentProvider, (p_274778_, p_274779_) -> new CombinedData((HolderLookup.Provider)p_274778_, p_274779_), (Executor)Util.backgroundExecutor())).thenCompose(p_325926_ -> {
            HolderLookup.RegistryLookup registrylookup = p_325926_.contents.lookup(this.registryKey).orElseThrow(() -> {
                if (RegistryManager.ACTIVE.getRegistry(this.registryKey) != null) {
                    return new IllegalStateException("Forge registry " + String.valueOf(this.registryKey.identifier()) + " does not have support for tags");
                }
                return new IllegalStateException("Registry " + String.valueOf(this.registryKey.identifier()) + " not found");
            });
            Predicate<Identifier> predicate = p_448741_ -> registrylookup.get(ResourceKey.create(this.registryKey, p_448741_)).isPresent();
            Predicate<Identifier> predicate1 = p_448739_ -> this.builders.containsKey(p_448739_) || p_325926_.parent.contains(TagKey.create(this.registryKey, p_448739_));
            return CompletableFuture.allOf((CompletableFuture[])this.builders.entrySet().stream().map(p_325931_ -> {
                Identifier identifier = (Identifier)p_325931_.getKey();
                TagBuilder tagbuilder = (TagBuilder)p_325931_.getValue();
                List<TagEntry> list = tagbuilder.build();
                List<TagEntry> list1 = Stream.concat(list.stream(), tagbuilder.getRemoveEntries()).filter(p_274771_ -> !p_274771_.verifyIfPresent(predicate, predicate1)).filter(this::missing).toList();
                if (!list1.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s", identifier, list1.stream().map(Objects::toString).collect(Collectors.joining(","))));
                }
                Path path = this.getPath(identifier);
                if (path == null) {
                    return CompletableFuture.completedFuture(null);
                }
                return DataProvider.saveStable(p_253684_, p_325926_.contents, TagFile.CODEC, new TagFile(list, tagbuilder.isReplace(), tagbuilder.getRemoveEntries().toList()), path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected TagBuilder getOrCreateRawBuilder(TagKey<T> p_236452_) {
        return this.builders.computeIfAbsent(p_236452_.location(), p_460082_ -> {
            if (this.existingFileHelper != null) {
                this.existingFileHelper.trackGenerated(p_460082_, this.resourceType);
            }
            return TagBuilder.create();
        });
    }

    public CompletableFuture<TagLookup<T>> contentsGetter() {
        return this.contentsDone.thenApply(p_276016_ -> p_448737_ -> Optional.ofNullable(this.builders.get(p_448737_.location())));
    }

    protected CompletableFuture<HolderLookup.Provider> createContentsProvider() {
        return this.lookupProvider.thenApply(p_274768_ -> {
            this.builders.clear();
            this.addTags((HolderLookup.Provider)p_274768_);
            return p_274768_;
        });
    }

    private boolean missing(TagEntry reference) {
        if (reference.isRequired()) {
            return this.existingFileHelper == null || !this.existingFileHelper.exists(reference.getId(), reference.isTag() ? this.resourceType : this.elementResourceType);
        }
        return false;
    }

    @FunctionalInterface
    public static interface TagLookup<T>
    extends Function<TagKey<T>, Optional<TagBuilder>> {
        public static <T> TagLookup<T> empty() {
            return p_275247_ -> Optional.empty();
        }

        default public boolean contains(TagKey<T> p_275413_) {
            return ((Optional)this.apply(p_275413_)).isPresent();
        }
    }
}

