/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gizmos;

import java.util.OptionalDouble;
import net.minecraft.gizmos.Gizmo;
import net.minecraft.gizmos.GizmoPrimitives;
import net.minecraft.util.ARGB;
import net.minecraft.world.phys.Vec3;

public record TextGizmo(Vec3 pos, String text, Style style) implements Gizmo
{
    @Override
    public void emit(GizmoPrimitives $$0, float $$1) {
        Style $$3;
        if ($$1 < 1.0f) {
            Style $$2 = new Style(ARGB.multiplyAlpha(this.style.color, $$1), this.style.scale, this.style.adjustLeft);
        } else {
            $$3 = this.style;
        }
        $$0.addText(this.pos, this.text, $$3);
    }

    public record Style(int color, float scale, OptionalDouble adjustLeft) {
        public static final float DEFAULT_SCALE = 0.32f;

        public static Style whiteAndCentered() {
            return new Style(-1, 0.32f, OptionalDouble.empty());
        }

        public static Style forColorAndCentered(int $$0) {
            return new Style($$0, 0.32f, OptionalDouble.empty());
        }

        public static Style forColor(int $$0) {
            return new Style($$0, 0.32f, OptionalDouble.of(0.0));
        }

        public Style withScale(float $$0) {
            return new Style(this.color, $$0, this.adjustLeft);
        }

        public Style withLeftAlignment(float $$0) {
            return new Style(this.color, this.scale, OptionalDouble.of($$0));
        }
    }
}

