/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.internal.TextComponentMessageFormatHandler;
import org.jspecify.annotations.Nullable;

public class TranslatableContents
implements ComponentContents {
    public static final Object[] NO_ARGS = new Object[0];
    private static final Codec<Object> PRIMITIVE_ARG_CODEC = ExtraCodecs.JAVA.validate(TranslatableContents::filterAllowedArguments);
    private static final Codec<Object> ARG_CODEC = Codec.either(PRIMITIVE_ARG_CODEC, ComponentSerialization.CODEC).xmap(p_309461_ -> p_309461_.map(p_311360_ -> p_311360_, p_311088_ -> Objects.requireNonNullElse(p_311088_.tryCollapseToString(), p_311088_)), p_309556_ -> {
        Either either;
        if (p_309556_ instanceof Component) {
            Component component = (Component)p_309556_;
            either = Either.right((Object)component);
        } else {
            either = Either.left((Object)p_309556_);
        }
        return either;
    });
    public static final MapCodec<TranslatableContents> MAP_CODEC = RecordCodecBuilder.mapCodec(p_326087_ -> p_326087_.group((App)Codec.STRING.fieldOf("translate").forGetter(p_309788_ -> p_309788_.key), (App)Codec.STRING.lenientOptionalFieldOf("fallback").forGetter(p_310035_ -> Optional.ofNullable(p_310035_.fallback)), (App)ARG_CODEC.listOf().optionalFieldOf("with").forGetter(p_309865_ -> TranslatableContents.adjustArgs(p_309865_.args))).apply((Applicative)p_326087_, TranslatableContents::create));
    private static final FormattedText TEXT_PERCENT = FormattedText.of("%");
    private static final FormattedText TEXT_NULL = FormattedText.of("null");
    private final String key;
    private final @Nullable String fallback;
    private final Object[] args;
    private @Nullable Language decomposedWith;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    private static DataResult<Object> filterAllowedArguments(@Nullable Object p_310291_) {
        return !TranslatableContents.isAllowedPrimitiveArgument(p_310291_) ? DataResult.error(() -> "This value needs to be parsed as component") : DataResult.success((Object)p_310291_);
    }

    public static boolean isAllowedPrimitiveArgument(@Nullable Object p_313191_) {
        return p_313191_ instanceof Number || p_313191_ instanceof Boolean || p_313191_ instanceof String;
    }

    private static Optional<List<Object>> adjustArgs(Object[] p_310705_) {
        return p_310705_.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(p_310705_));
    }

    private static Object[] adjustArgs(Optional<List<Object>> p_309492_) {
        return p_309492_.map(p_309407_ -> p_309407_.isEmpty() ? NO_ARGS : p_309407_.toArray()).orElse(NO_ARGS);
    }

    private static TranslatableContents create(String p_311603_, Optional<String> p_311479_, Optional<List<Object>> p_312087_) {
        return new TranslatableContents(p_311603_, p_311479_.orElse(null), TranslatableContents.adjustArgs(p_312087_));
    }

    public TranslatableContents(String p_265775_, @Nullable String p_265204_, Object[] p_265752_) {
        this.key = p_265775_;
        this.fallback = p_265204_;
        this.args = p_265752_;
    }

    public MapCodec<TranslatableContents> codec() {
        return MAP_CODEC;
    }

    private void decompose() {
        Language language = Language.getInstance();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            String s = this.fallback != null ? language.getOrDefault(this.key, this.fallback) : language.getOrDefault(this.key);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.decomposeTemplate(s, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.decomposedParts = builder.build();
            }
            catch (TranslatableFormatException translatableformatexception) {
                this.decomposedParts = ImmutableList.of((Object)FormattedText.of(s));
            }
        }
    }

    private void decomposeTemplate(String p_237516_, Consumer<FormattedText> p_237517_) {
        Matcher matcher = FORMAT_PATTERN.matcher(p_237516_);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    String s = p_237516_.substring(j, k);
                    if (s.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    p_237517_.accept(FormattedText.of(s));
                }
                String s4 = matcher.group(2);
                String s1 = p_237516_.substring(k, l);
                if ("%".equals(s4) && "%%".equals(s1)) {
                    p_237517_.accept(TEXT_PERCENT);
                } else {
                    if (!"s".equals(s4)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + s1 + "'");
                    }
                    String s2 = matcher.group(1);
                    int i1 = s2 != null ? Integer.parseInt(s2) - 1 : i++;
                    p_237517_.accept(this.getArgument(i1));
                }
                j = l;
            }
            if (j == 0) {
                j = TextComponentMessageFormatHandler.handle((TranslatableContents)this, p_237517_, (Object[])this.args, (String)p_237516_);
            }
            if (j < p_237516_.length()) {
                String s3 = p_237516_.substring(j);
                if (s3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                p_237517_.accept(FormattedText.of(s3));
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new TranslatableFormatException(this, (Throwable)illegalargumentexception);
        }
    }

    private FormattedText getArgument(int p_237510_) {
        if (p_237510_ >= 0 && p_237510_ < this.args.length) {
            Object object = this.args[p_237510_];
            if (object instanceof Component) {
                Component component = (Component)object;
                return component;
            }
            return object == null ? TEXT_NULL : FormattedText.of(object.toString());
        }
        throw new TranslatableFormatException(this, p_237510_);
    }

    @Override
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> p_237521_, Style p_237522_) {
        this.decompose();
        for (FormattedText formattedtext : this.decomposedParts) {
            Optional<T> optional = formattedtext.visit(p_237521_, p_237522_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> p_237519_) {
        this.decompose();
        for (FormattedText formattedtext : this.decomposedParts) {
            Optional<T> optional = formattedtext.visit(p_237519_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack p_237512_, @Nullable Entity p_237513_, int p_237514_) throws CommandSyntaxException {
        Object[] aobject = new Object[this.args.length];
        for (int i = 0; i < aobject.length; ++i) {
            Object object = this.args[i];
            if (object instanceof Component) {
                Component component = (Component)object;
                aobject[i] = ComponentUtils.updateForEntity(p_237512_, component, p_237513_, p_237514_);
                continue;
            }
            aobject[i] = object;
        }
        return MutableComponent.create(new TranslatableContents(this.key, this.fallback, aobject));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p_237526_) {
        if (this == p_237526_) {
            return true;
        }
        if (!(p_237526_ instanceof TranslatableContents)) return false;
        TranslatableContents translatablecontents = (TranslatableContents)p_237526_;
        if (!Objects.equals(this.key, translatablecontents.key)) return false;
        if (!Objects.equals(this.fallback, translatablecontents.fallback)) return false;
        if (!Arrays.equals(this.args, translatablecontents.args)) return false;
        return true;
    }

    public int hashCode() {
        int i = Objects.hashCode(this.key);
        i = 31 * i + Objects.hashCode(this.fallback);
        return 31 * i + Arrays.hashCode(this.args);
    }

    public String toString() {
        return "translation{key='" + this.key + "'" + (String)(this.fallback != null ? ", fallback='" + this.fallback + "'" : "") + ", args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    public @Nullable String getFallback() {
        return this.fallback;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

