/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamMemberEncoder;
import net.minecraft.resources.Identifier;

public interface CustomPacketPayload {
    public Type<? extends CustomPacketPayload> type();

    public static <B extends ByteBuf, T extends CustomPacketPayload> StreamCodec<B, T> codec(StreamMemberEncoder<B, T> p_336135_, StreamDecoder<B, T> p_335771_) {
        return StreamCodec.ofMember(p_336135_, p_335771_);
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String p_331650_) {
        return new Type(Identifier.parse(p_331650_));
    }

    public static <T extends CustomPacketPayload> Type<T> createType(String namespace, String path) {
        return new Type(Identifier.fromNamespaceAndPath(namespace, path));
    }

    public static <T extends CustomPacketPayload> Type<T> createType(Identifier name) {
        return new Type(name);
    }

    public static <B extends FriendlyByteBuf> StreamCodec<B, CustomPacketPayload> codec(final FallbackProvider<B> p_329573_, List<TypeAndCodec<? super B, ?>> p_333081_) {
        final Map<Identifier, StreamCodec> map = p_333081_.stream().collect(Collectors.toUnmodifiableMap(p_448779_ -> p_448779_.type().id(), TypeAndCodec::codec));
        return new StreamCodec<B, CustomPacketPayload>(){

            private StreamCodec<? super B, ? extends CustomPacketPayload> findCodec(Identifier p_459672_) {
                StreamCodec streamcodec = (StreamCodec)map.get(p_459672_);
                return streamcodec != null ? streamcodec : p_329573_.create(p_459672_);
            }

            private <T extends CustomPacketPayload> void writeCap(B p_332252_, Type<T> p_334465_, CustomPacketPayload p_334290_) {
                ((FriendlyByteBuf)((Object)p_332252_)).writeIdentifier(p_334465_.id());
                StreamCodec streamcodec = this.findCodec(p_334465_.id);
                streamcodec.encode(p_332252_, p_334290_);
            }

            @Override
            public void encode(B p_334992_, CustomPacketPayload p_329854_) {
                this.writeCap(p_334992_, p_329854_.type(), p_329854_);
            }

            @Override
            public CustomPacketPayload decode(B p_334320_) {
                Identifier identifier = ((FriendlyByteBuf)((Object)p_334320_)).readIdentifier();
                return (CustomPacketPayload)this.findCodec(identifier).decode(p_334320_);
            }
        };
    }

    public record Type<T extends CustomPacketPayload>(Identifier id) {
    }

    public static interface FallbackProvider<B extends FriendlyByteBuf> {
        public StreamCodec<B, ? extends CustomPacketPayload> create(Identifier var1);
    }

    public record TypeAndCodec<B extends FriendlyByteBuf, T extends CustomPacketPayload>(Type<T> type, StreamCodec<B, T> codec) {
    }
}

