/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import net.minecraft.IdentifierException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jspecify.annotations.Nullable;

public final class Identifier
implements Comparable<Identifier> {
    public static final Codec<Identifier> CODEC = Codec.STRING.comapFlatMap(Identifier::read, Identifier::toString).stable();
    public static final StreamCodec<ByteBuf, Identifier> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(Identifier::parse, Identifier::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    private final String namespace;
    private final String path;

    private Identifier(String p_453419_, String p_457561_) {
        assert (Identifier.isValidNamespace(p_453419_));
        assert (Identifier.isValidPath(p_457561_));
        this.namespace = p_453419_;
        this.path = p_457561_;
    }

    private static Identifier createUntrusted(String p_458386_, String p_455185_) {
        return new Identifier(Identifier.assertValidNamespace(p_458386_, p_455185_), Identifier.assertValidPath(p_458386_, p_455185_));
    }

    public static Identifier fromNamespaceAndPath(String p_453591_, String p_452050_) {
        return Identifier.createUntrusted(p_453591_, p_452050_);
    }

    public static Identifier parse(String p_450672_) {
        return Identifier.bySeparator(p_450672_, ':');
    }

    public static Identifier withDefaultNamespace(String p_450610_) {
        return new Identifier(DEFAULT_NAMESPACE, Identifier.assertValidPath(DEFAULT_NAMESPACE, p_450610_));
    }

    public static @Nullable Identifier tryParse(String p_456562_) {
        return Identifier.tryBySeparator(p_456562_, ':');
    }

    public static @Nullable Identifier tryBuild(String p_458111_, String p_455894_) {
        return Identifier.isValidNamespace(p_458111_) && Identifier.isValidPath(p_455894_) ? new Identifier(p_458111_, p_455894_) : null;
    }

    public static Identifier bySeparator(String p_450597_, char p_457881_) {
        int i = p_450597_.indexOf(p_457881_);
        if (i >= 0) {
            String s = p_450597_.substring(i + 1);
            if (i != 0) {
                String s1 = p_450597_.substring(0, i);
                return Identifier.createUntrusted(s1, s);
            }
            return Identifier.withDefaultNamespace(s);
        }
        return Identifier.withDefaultNamespace(p_450597_);
    }

    public static @Nullable Identifier tryBySeparator(String p_458139_, char p_459073_) {
        int i = p_458139_.indexOf(p_459073_);
        if (i >= 0) {
            String s = p_458139_.substring(i + 1);
            if (!Identifier.isValidPath(s)) {
                return null;
            }
            if (i != 0) {
                String s1 = p_458139_.substring(0, i);
                return Identifier.isValidNamespace(s1) ? new Identifier(s1, s) : null;
            }
            return new Identifier(DEFAULT_NAMESPACE, s);
        }
        return Identifier.isValidPath(p_458139_) ? new Identifier(DEFAULT_NAMESPACE, p_458139_) : null;
    }

    public static DataResult<Identifier> read(String p_460941_) {
        try {
            return DataResult.success((Object)Identifier.parse(p_460941_));
        }
        catch (IdentifierException identifierexception) {
            return DataResult.error(() -> "Not a valid resource location: " + p_460941_ + " " + identifierexception.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Identifier withPath(String p_458392_) {
        return new Identifier(this.namespace, Identifier.assertValidPath(this.namespace, p_458392_));
    }

    public Identifier withPath(UnaryOperator<String> p_460135_) {
        return this.withPath((String)p_460135_.apply(this.path));
    }

    public Identifier withPrefix(String p_455609_) {
        return this.withPath(p_455609_ + this.path);
    }

    public Identifier withSuffix(String p_460571_) {
        return this.withPath(this.path + p_460571_);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    public boolean equals(Object p_458291_) {
        boolean bl;
        if (this == p_458291_) {
            return true;
        }
        if (!(p_458291_ instanceof Identifier)) {
            bl = false;
        } else {
            Identifier identifier = (Identifier)p_458291_;
            bl = this.namespace.equals(identifier.namespace) && this.path.equals(identifier.path);
        }
        return bl;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(Identifier p_452748_) {
        int i = this.path.compareTo(p_452748_.path);
        if (i == 0) {
            i = this.namespace.compareTo(p_452748_.namespace);
        }
        return i;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toShortString() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toString();
    }

    public String toLanguageKey(String p_451530_) {
        return p_451530_ + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String p_458514_, String p_455994_) {
        return p_458514_ + "." + this.toLanguageKey() + "." + p_455994_;
    }

    private static String readGreedy(StringReader p_458656_) {
        int i = p_458656_.getCursor();
        while (p_458656_.canRead() && Identifier.isAllowedInIdentifier(p_458656_.peek())) {
            p_458656_.skip();
        }
        return p_458656_.getString().substring(i, p_458656_.getCursor());
    }

    public static Identifier read(StringReader p_458258_) throws CommandSyntaxException {
        int i = p_458258_.getCursor();
        String s = Identifier.readGreedy(p_458258_);
        try {
            return Identifier.parse(s);
        }
        catch (IdentifierException identifierexception) {
            p_458258_.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)p_458258_);
        }
    }

    public static Identifier readNonEmpty(StringReader p_450362_) throws CommandSyntaxException {
        int i = p_450362_.getCursor();
        String s = Identifier.readGreedy(p_450362_);
        if (s.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)p_450362_);
        }
        try {
            return Identifier.parse(s);
        }
        catch (IdentifierException identifierexception) {
            p_450362_.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)p_450362_);
        }
    }

    public static boolean isAllowedInIdentifier(char p_453350_) {
        return p_453350_ >= '0' && p_453350_ <= '9' || p_453350_ >= 'a' && p_453350_ <= 'z' || p_453350_ == '_' || p_453350_ == ':' || p_453350_ == '/' || p_453350_ == '.' || p_453350_ == '-';
    }

    public static boolean isValidPath(String p_450971_) {
        for (int i = 0; i < p_450971_.length(); ++i) {
            if (Identifier.validPathChar(p_450971_.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String p_457130_) {
        for (int i = 0; i < p_457130_.length(); ++i) {
            if (Identifier.validNamespaceChar(p_457130_.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String p_457507_, String p_451506_) {
        if (!Identifier.isValidNamespace(p_457507_)) {
            throw new IdentifierException("Non [a-z0-9_.-] character in namespace of location: " + p_457507_ + ":" + p_451506_);
        }
        return p_457507_;
    }

    public static boolean validPathChar(char p_458266_) {
        return p_458266_ == '_' || p_458266_ == '-' || p_458266_ >= 'a' && p_458266_ <= 'z' || p_458266_ >= '0' && p_458266_ <= '9' || p_458266_ == '/' || p_458266_ == '.';
    }

    public static boolean validNamespaceChar(char p_454742_) {
        return p_454742_ == '_' || p_454742_ == '-' || p_454742_ >= 'a' && p_454742_ <= 'z' || p_454742_ >= '0' && p_454742_ <= '9' || p_454742_ == '.';
    }

    private static String assertValidPath(String p_450153_, String p_458379_) {
        if (!Identifier.isValidPath(p_458379_)) {
            throw new IdentifierException("Non [a-z0-9/._-] character in path of location: " + p_450153_ + ":" + p_458379_);
        }
        return p_458379_;
    }

    public int compareNamespaced(Identifier o) {
        int ret = this.namespace.compareTo(o.namespace);
        return ret != 0 ? ret : this.path.compareTo(o.path);
    }
}

