/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    public final List<PackEntry> fallbacks = Lists.newArrayList();
    private final PackType type;
    private final String namespace;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.type = p_10605_;
        this.namespace = p_10606_;
    }

    public void push(PackResources p_215378_) {
        this.pushInternal(p_215378_.packId(), p_215378_, null);
    }

    public void push(PackResources p_215383_, Predicate<Identifier> p_215384_) {
        this.pushInternal(p_215383_.packId(), p_215383_, p_215384_);
    }

    public void pushFilterOnly(String p_215400_, Predicate<Identifier> p_215401_) {
        this.pushInternal(p_215400_, null, p_215401_);
    }

    private void pushInternal(String p_215396_, @Nullable PackResources p_215397_, @Nullable Predicate<Identifier> p_215398_) {
        this.fallbacks.add(new PackEntry(p_215396_, p_215397_, p_215398_));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<Resource> getResource(Identifier p_456305_) {
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            IoSupplier<InputStream> iosupplier;
            PackEntry fallbackresourcemanager$packentry = this.fallbacks.get(i);
            PackResources packresources = fallbackresourcemanager$packentry.resources;
            if (packresources != null && (iosupplier = packresources.getResource(this.type, p_456305_)) != null) {
                IoSupplier<ResourceMetadata> iosupplier1 = this.createStackMetadataFinder(p_456305_, i);
                return Optional.of(FallbackResourceManager.createResource(packresources, p_456305_, iosupplier, iosupplier1));
            }
            if (!fallbackresourcemanager$packentry.isFiltered(p_456305_)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)p_456305_, (Object)fallbackresourcemanager$packentry.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static Resource createResource(PackResources p_249946_, Identifier p_457909_, IoSupplier<InputStream> p_250514_, IoSupplier<ResourceMetadata> p_251676_) {
        return new Resource(p_249946_, FallbackResourceManager.wrapForDebug(p_457909_, p_249946_, p_250514_), p_251676_);
    }

    private static IoSupplier<InputStream> wrapForDebug(Identifier p_450819_, PackResources p_251740_, IoSupplier<InputStream> p_249116_) {
        return LOGGER.isDebugEnabled() ? () -> new LeakedResourceWarningInputStream((InputStream)p_249116_.get(), p_450819_, p_251740_.packId()) : p_249116_;
    }

    @Override
    public List<Resource> getResourceStack(Identifier p_458089_) {
        Identifier identifier = FallbackResourceManager.getMetadataLocation(p_458089_);
        ArrayList<Resource> list = new ArrayList<Resource>();
        boolean flag = false;
        String s = null;
        for (int i = this.fallbacks.size() - 1; i >= 0; --i) {
            PackEntry fallbackresourcemanager$packentry = this.fallbacks.get(i);
            PackResources pack = fallbackresourcemanager$packentry.resources;
            if (pack != null) {
                List<PackResources> children = pack.getChildren();
                List<PackResources> packs = children == null ? List.of(pack) : children;
                for (PackResources packresources : packs) {
                    IoSupplier<InputStream> iosupplier = packresources.getResource(this.type, p_458089_);
                    if (iosupplier == null) continue;
                    IoSupplier<ResourceMetadata> iosupplier1 = flag ? ResourceMetadata.EMPTY_SUPPLIER : () -> {
                        IoSupplier<InputStream> iosupplier2 = packresources.getResource(this.type, identifier);
                        return iosupplier2 != null ? FallbackResourceManager.parseMetadata(iosupplier2) : ResourceMetadata.EMPTY;
                    };
                    list.add(new Resource(packresources, iosupplier, iosupplier1));
                }
            }
            if (fallbackresourcemanager$packentry.isFiltered(p_458089_)) {
                s = fallbackresourcemanager$packentry.name;
                break;
            }
            if (!fallbackresourcemanager$packentry.isFiltered(identifier)) continue;
            flag = true;
        }
        if (list.isEmpty() && s != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)p_458089_, s);
        }
        return Lists.reverse(list);
    }

    private static boolean isMetadata(Identifier p_458557_) {
        return p_458557_.getPath().endsWith(".mcmeta");
    }

    private static Identifier getIdentifierFromMetadata(Identifier p_454436_) {
        String s = p_454436_.getPath().substring(0, p_454436_.getPath().length() - ".mcmeta".length());
        return p_454436_.withPath(s);
    }

    static Identifier getMetadataLocation(Identifier p_458734_) {
        return p_458734_.withPath(p_458734_.getPath() + ".mcmeta");
    }

    @Override
    public Map<Identifier, Resource> listResources(String p_215413_, Predicate<Identifier> p_215414_) {
        record ResourceWithSourceAndIndex(PackResources packResources, IoSupplier<InputStream> resource, int packIndex) {
        }
        HashMap<Identifier, ResourceWithSourceAndIndex> map = new HashMap<Identifier, ResourceWithSourceAndIndex>();
        HashMap map1 = new HashMap();
        int i = this.fallbacks.size();
        for (int j = 0; j < i; ++j) {
            PackEntry fallbackresourcemanager$packentry = this.fallbacks.get(j);
            fallbackresourcemanager$packentry.filterAll(map.keySet());
            fallbackresourcemanager$packentry.filterAll(map1.keySet());
            PackResources packresources = fallbackresourcemanager$packentry.resources;
            if (packresources == null) continue;
            int k = j;
            packresources.listResources(this.type, this.namespace, p_215413_, (p_449180_, p_449181_) -> {
                if (FallbackResourceManager.isMetadata(p_449180_)) {
                    if (p_215414_.test(FallbackResourceManager.getIdentifierFromMetadata(p_449180_))) {
                        map1.put(p_449180_, new ResourceWithSourceAndIndex(packresources, (IoSupplier<InputStream>)p_449181_, k));
                    }
                } else if (p_215414_.test((Identifier)p_449180_)) {
                    map.put((Identifier)p_449180_, new ResourceWithSourceAndIndex(packresources, (IoSupplier<InputStream>)p_449181_, k));
                }
            });
        }
        TreeMap map2 = Maps.newTreeMap();
        map.forEach((p_449184_, p_449185_) -> {
            Identifier identifier = FallbackResourceManager.getMetadataLocation(p_449184_);
            ResourceWithSourceAndIndex fallbackresourcemanager$1resourcewithsourceandindex = (ResourceWithSourceAndIndex)map1.get(identifier);
            IoSupplier<ResourceMetadata> iosupplier = fallbackresourcemanager$1resourcewithsourceandindex != null && fallbackresourcemanager$1resourcewithsourceandindex.packIndex >= p_449185_.packIndex ? FallbackResourceManager.convertToMetadata(fallbackresourcemanager$1resourcewithsourceandindex.resource) : ResourceMetadata.EMPTY_SUPPLIER;
            map2.put(p_449184_, FallbackResourceManager.createResource(p_449185_.packResources, p_449184_, p_449185_.resource, iosupplier));
        });
        return map2;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(Identifier p_451153_, int p_215370_) {
        return () -> {
            Identifier identifier = FallbackResourceManager.getMetadataLocation(p_451153_);
            for (int i = this.fallbacks.size() - 1; i >= p_215370_; --i) {
                IoSupplier<InputStream> iosupplier;
                PackEntry fallbackresourcemanager$packentry = this.fallbacks.get(i);
                PackResources packresources = fallbackresourcemanager$packentry.resources;
                if (packresources != null && (iosupplier = packresources.getResource(this.type, identifier)) != null) {
                    return FallbackResourceManager.parseMetadata(iosupplier);
                }
                if (fallbackresourcemanager$packentry.isFiltered(identifier)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> p_250827_) {
        return () -> FallbackResourceManager.parseMetadata(p_250827_);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> p_250103_) throws IOException {
        ResourceMetadata resourcemetadata;
        try (InputStream inputstream = p_250103_.get();){
            resourcemetadata = ResourceMetadata.fromJsonStream(inputstream);
        }
        return resourcemetadata;
    }

    private static void applyPackFiltersToExistingResources(PackEntry p_215393_, Map<Identifier, EntryStack> p_215394_) {
        for (EntryStack fallbackresourcemanager$entrystack : p_215394_.values()) {
            if (p_215393_.isFiltered(fallbackresourcemanager$entrystack.fileLocation)) {
                fallbackresourcemanager$entrystack.fileSources.clear();
                continue;
            }
            if (!p_215393_.isFiltered(fallbackresourcemanager$entrystack.metadataLocation())) continue;
            fallbackresourcemanager$entrystack.metaSources.clear();
        }
    }

    private void listPackResources(PackEntry p_215388_, String p_215389_, Predicate<Identifier> p_215390_, Map<Identifier, EntryStack> p_215391_) {
        PackResources packresources = p_215388_.resources;
        if (packresources != null) {
            packresources.listResources(this.type, this.namespace, p_215389_, (p_450789_, p_248267_) -> {
                if (FallbackResourceManager.isMetadata(p_450789_)) {
                    Identifier identifier = FallbackResourceManager.getIdentifierFromMetadata(p_450789_);
                    if (!p_215390_.test(identifier)) {
                        return;
                    }
                    p_215391_.computeIfAbsent(identifier, (Function<Identifier, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.Identifier ), (Lnet/minecraft/resources/Identifier;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).metaSources.put(packresources, (IoSupplier<InputStream>)p_248267_);
                } else {
                    if (!p_215390_.test((Identifier)p_450789_)) {
                        return;
                    }
                    p_215391_.computeIfAbsent(p_450789_, (Function<Identifier, EntryStack>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.Identifier ), (Lnet/minecraft/resources/Identifier;)Lnet/minecraft/server/packs/resources/FallbackResourceManager$EntryStack;)()).fileSources.add(new ResourceWithSource(packresources, (IoSupplier<InputStream>)p_248267_));
                }
            });
        }
    }

    @Override
    public Map<Identifier, List<Resource>> listResourceStacks(String p_215416_, Predicate<Identifier> p_215417_) {
        HashMap map = Maps.newHashMap();
        for (PackEntry fallbackresourcemanager$packentry : this.fallbacks) {
            FallbackResourceManager.applyPackFiltersToExistingResources(fallbackresourcemanager$packentry, map);
            this.listPackResources(fallbackresourcemanager$packentry, p_215416_, p_215417_, map);
        }
        TreeMap treemap = Maps.newTreeMap();
        for (EntryStack fallbackresourcemanager$entrystack : map.values()) {
            if (fallbackresourcemanager$entrystack.fileSources.isEmpty()) continue;
            ArrayList<Resource> list = new ArrayList<Resource>();
            for (ResourceWithSource fallbackresourcemanager$resourcewithsource : fallbackresourcemanager$entrystack.fileSources) {
                PackResources packresources = fallbackresourcemanager$resourcewithsource.source;
                IoSupplier<InputStream> iosupplier = fallbackresourcemanager$entrystack.metaSources.get(packresources);
                IoSupplier<ResourceMetadata> iosupplier1 = iosupplier != null ? FallbackResourceManager.convertToMetadata(iosupplier) : ResourceMetadata.EMPTY_SUPPLIER;
                list.add(FallbackResourceManager.createResource(packresources, fallbackresourcemanager$entrystack.fileLocation, fallbackresourcemanager$resourcewithsource.resource, iosupplier1));
            }
            treemap.put(fallbackresourcemanager$entrystack.fileLocation, list);
        }
        return treemap;
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.fallbacks.stream().map(p_215386_ -> p_215386_.resources).filter(Objects::nonNull);
    }

    record PackEntry(String name, @Nullable PackResources resources, @Nullable Predicate<Identifier> filter) {
        public void filterAll(Collection<Identifier> p_215443_) {
            if (this.filter != null) {
                p_215443_.removeIf(this.filter);
            }
        }

        public boolean isFiltered(Identifier p_450292_) {
            return this.filter != null && this.filter.test(p_450292_);
        }
    }

    record EntryStack(Identifier fileLocation, Identifier metadataLocation, List<ResourceWithSource> fileSources, Map<PackResources, IoSupplier<InputStream>> metaSources) {
        EntryStack(Identifier p_453083_) {
            this(p_453083_, FallbackResourceManager.getMetadataLocation(p_453083_), new ArrayList<ResourceWithSource>(), (Map<PackResources, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }
    }

    record ResourceWithSource(PackResources source, IoSupplier<InputStream> resource) {
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public LeakedResourceWarningInputStream(InputStream p_10633_, Identifier p_456546_, String p_10635_) {
            super(p_10633_);
            Exception exception = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter stringwriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringwriter));
                return "Leaked resource: '" + String.valueOf(p_456546_) + "' loaded from pack: '" + p_10635_ + "'\n" + String.valueOf(stringwriter);
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

