/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;

public interface StrictQueue<T extends Runnable> {
    public @Nullable Runnable pop();

    public boolean push(T var1);

    public boolean isEmpty();

    public int size();

    public static final class FixedPriorityQueue
    implements StrictQueue<RunnableWithPriority> {
        private final Queue<Runnable>[] queues;
        private final AtomicInteger size = new AtomicInteger();

        public FixedPriorityQueue(int $$0) {
            this.queues = new Queue[$$0];
            for (int $$1 = 0; $$1 < $$0; ++$$1) {
                this.queues[$$1] = Queues.newConcurrentLinkedQueue();
            }
        }

        @Override
        public @Nullable Runnable pop() {
            for (Queue<Runnable> $$0 : this.queues) {
                Runnable $$1 = $$0.poll();
                if ($$1 == null) continue;
                this.size.decrementAndGet();
                return $$1;
            }
            return null;
        }

        @Override
        public boolean push(RunnableWithPriority $$0) {
            int $$1 = $$0.priority;
            if ($$1 >= this.queues.length || $$1 < 0) {
                throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Priority %d not supported. Expected range [0-%d]", $$1, this.queues.length - 1));
            }
            this.queues[$$1].add($$0);
            this.size.incrementAndGet();
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.size.get() == 0;
        }

        @Override
        public int size() {
            return this.size.get();
        }
    }

    public record RunnableWithPriority(int priority, Runnable task) implements Runnable
    {
        @Override
        public void run() {
            this.task.run();
        }
    }

    public static final class QueueStrictQueue
    implements StrictQueue<Runnable> {
        private final Queue<Runnable> queue;

        public QueueStrictQueue(Queue<Runnable> $$0) {
            this.queue = $$0;
        }

        @Override
        public @Nullable Runnable pop() {
            return this.queue.poll();
        }

        @Override
        public boolean push(Runnable $$0) {
            return this.queue.add($$0);
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

