/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.cow;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SpellParticleOption;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.cow.AbstractCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class MushroomCow
extends AbstractCow
implements Shearable {
    private static final EntityDataAccessor<Integer> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.INT);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    private @Nullable SuspiciousStewEffects stewEffects;
    private @Nullable UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> p_459154_, Level p_458567_) {
        super((EntityType<? extends AbstractCow>)p_459154_, p_458567_);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_455818_, LevelReader p_455238_) {
        return p_455238_.getBlockState(p_455818_.below()).is(Blocks.MYCELIUM) ? 10.0f : p_455238_.getPathfindingCostFromLightLevels(p_455818_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> p_452376_, LevelAccessor p_453400_, EntitySpawnReason p_459628_, BlockPos p_451279_, RandomSource p_460174_) {
        return p_453400_.getBlockState(p_451279_.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn(p_453400_, p_451279_);
    }

    @Override
    public void thunderHit(ServerLevel p_450942_, LightningBolt p_455463_) {
        UUID uuid = p_455463_.getUUID();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
            this.lastLightningBoltUUID = uuid;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_451836_) {
        super.defineSynchedData(p_451836_);
        p_451836_.define(DATA_TYPE, Variant.DEFAULT.id);
    }

    @Override
    public InteractionResult mobInteract(Player p_454203_, InteractionHand p_457673_) {
        ItemStack itemstack = p_454203_.getItemInHand(p_457673_);
        if (itemstack.is(Items.BOWL) && !this.isBaby()) {
            ItemStack itemstack1;
            boolean flag = false;
            if (this.stewEffects != null) {
                flag = true;
                itemstack1 = new ItemStack(Items.SUSPICIOUS_STEW);
                itemstack1.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                itemstack1 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack itemstack2 = ItemUtils.createFilledResult(itemstack, p_454203_, itemstack1, false);
            p_454203_.setItemInHand(p_457673_, itemstack2);
            SoundEvent soundevent = flag ? SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEvents.MOOSHROOM_MILK;
            this.playSound(soundevent, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == Variant.BROWN) {
            Optional<SuspiciousStewEffects> optional = this.getEffectsFromItemStack(itemstack);
            if (optional.isEmpty()) {
                return super.mobInteract(p_454203_, p_457673_);
            }
            if (this.stewEffects != null) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                itemstack.consume(1, p_454203_);
                SpellParticleOption spellparticleoption = SpellParticleOption.create(ParticleTypes.EFFECT, -1, 1.0f);
                for (int j = 0; j < 4; ++j) {
                    this.level().addParticle(spellparticleoption, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = optional.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(p_454203_, p_457673_);
    }

    @Override
    public void shear(ServerLevel p_454992_, SoundSource p_460786_, ItemStack p_454795_) {
        for (ItemStack stack : this.shearInternal(p_454992_, p_460786_, p_454795_)) {
            for (int i = 0; i < stack.getCount(); ++i) {
                this.level().addFreshEntity(new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), stack.copyWithCount(1)));
            }
        }
    }

    private List<ItemStack> shearInternal(ServerLevel p_454992_, SoundSource p_460786_, ItemStack p_454795_) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (!ForgeEventFactory.canLivingConvert((LivingEntity)this, EntityType.COW, time -> {})) {
            return ret;
        }
        p_454992_.playSound(null, this, SoundEvents.MOOSHROOM_SHEAR, p_460786_, 1.0f, 1.0f);
        this.convertTo(EntityType.COW, ConversionParams.single(this, false, false), p_458024_ -> {
            p_454992_.sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable(p_454992_, BuiltInLootTables.SHEAR_MOOSHROOM, p_454795_, (p_460709_, p_451895_) -> ret.add((ItemStack)p_451895_));
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)p_458024_);
        });
        return ret;
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput p_455928_) {
        super.addAdditionalSaveData(p_455928_);
        p_455928_.store("Type", Variant.CODEC, this.getVariant());
        p_455928_.storeNullable(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC, this.stewEffects);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput p_453974_) {
        super.readAdditionalSaveData(p_453974_);
        this.setVariant(p_453974_.read("Type", Variant.CODEC).orElse(Variant.DEFAULT));
        this.stewEffects = p_453974_.read(TAG_STEW_EFFECTS, SuspiciousStewEffects.CODEC).orElse(null);
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack p_458897_) {
        SuspiciousEffectHolder suspiciouseffectholder = SuspiciousEffectHolder.tryGet(p_458897_.getItem());
        return suspiciouseffectholder != null ? Optional.of(suspiciouseffectholder.getSuspiciousEffects()) : Optional.empty();
    }

    private void setVariant(Variant p_458325_) {
        this.entityData.set(DATA_TYPE, p_458325_.id);
    }

    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_TYPE));
    }

    @Override
    public <T> @Nullable T get(DataComponentType<? extends T> p_454953_) {
        return p_454953_ == DataComponents.MOOSHROOM_VARIANT ? MushroomCow.castComponentValue(p_454953_, this.getVariant()) : super.get(p_454953_);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_455032_) {
        this.applyImplicitComponentIfPresent(p_455032_, DataComponents.MOOSHROOM_VARIANT);
        super.applyImplicitComponents(p_455032_);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> p_450926_, T p_450646_) {
        if (p_450926_ == DataComponents.MOOSHROOM_VARIANT) {
            this.setVariant(MushroomCow.castComponentValue(DataComponents.MOOSHROOM_VARIANT, p_450646_));
            return true;
        }
        return super.applyImplicitComponent(p_450926_, p_450646_);
    }

    @Override
    public @Nullable MushroomCow getBreedOffspring(ServerLevel p_454117_, AgeableMob p_458786_) {
        MushroomCow mushroomcow = EntityType.MOOSHROOM.create(p_454117_, EntitySpawnReason.BREEDING);
        if (mushroomcow != null) {
            mushroomcow.setVariant(this.getOffspringVariant((MushroomCow)p_458786_));
        }
        return mushroomcow;
    }

    private Variant getOffspringVariant(MushroomCow p_459581_) {
        Variant mushroomcow$variant1;
        Variant mushroomcow$variant = this.getVariant();
        Variant mushroomcow$variant2 = mushroomcow$variant == (mushroomcow$variant1 = p_459581_.getVariant()) && this.random.nextInt(1024) == 0 ? (mushroomcow$variant == Variant.BROWN ? Variant.RED : Variant.BROWN) : (this.random.nextBoolean() ? mushroomcow$variant : mushroomcow$variant1);
        return mushroomcow$variant2;
    }

    public List<ItemStack> onSheared(@org.jetbrains.annotations.Nullable Player player, @NotNull ItemStack item, Level world, BlockPos pos, int fortune) {
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            this.gameEvent(GameEvent.SHEAR, player);
            return this.shearInternal(server, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, item);
        }
        return Collections.emptyList();
    }

    public static enum Variant implements StringRepresentable
    {
        RED("red", 0, Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", 1, Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final Variant DEFAULT;
        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        public static final StreamCodec<ByteBuf, Variant> STREAM_CODEC;
        private final String type;
        final int id;
        private final BlockState blockState;

        private Variant(String p_452372_, int p_457866_, BlockState p_451253_) {
            this.type = p_452372_;
            this.id = p_457866_;
            this.blockState = p_451253_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        private int id() {
            return this.id;
        }

        static Variant byId(int p_458342_) {
            return BY_ID.apply(p_458342_);
        }

        static {
            DEFAULT = RED;
            CODEC = StringRepresentable.fromEnum(Variant::values);
            BY_ID = ByIdMap.continuous(Variant::id, Variant.values(), ByIdMap.OutOfBoundsStrategy.CLAMP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Variant::id);
        }
    }
}

