/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jspecify.annotations.Nullable;

public class ThrownEnderpearl
extends ThrowableItemProjectile {
    private long ticketTimer = 0L;

    public ThrownEnderpearl(EntityType<? extends ThrownEnderpearl> p_451775_, Level p_454048_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_451775_, p_454048_);
    }

    public ThrownEnderpearl(Level p_460742_, LivingEntity p_458699_, ItemStack p_460872_) {
        super(EntityType.ENDER_PEARL, p_458699_, p_460742_, p_460872_);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwner(@Nullable EntityReference<Entity> p_452724_) {
        this.deregisterFromCurrentOwner();
        super.setOwner(p_452724_);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.registerEnderPearl(this);
        }
    }

    @Override
    public @Nullable Entity getOwner() {
        Entity entity;
        Level level;
        if (this.owner != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            entity = this.owner.getEntity(serverlevel, Entity.class);
        } else {
            entity = super.getOwner();
        }
        return entity;
    }

    private static @Nullable Entity findOwnerIncludingDeadPlayer(ServerLevel p_460869_, UUID p_460652_) {
        Entity entity = p_460869_.getEntityInAnyDimension(p_460652_);
        return entity != null ? entity : p_460869_.getServer().getPlayerList().getPlayer(p_460652_);
    }

    @Override
    protected void onHitEntity(EntityHitResult p_454744_) {
        super.onHitEntity(p_454744_);
        p_454744_.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult p_451483_) {
        super.onHit(p_451483_);
        for (int i = 0; i < 32; ++i) {
            this.level().addParticle(ParticleTypes.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (!this.isRemoved()) {
                Entity entity = this.getOwner();
                if (entity != null && ThrownEnderpearl.isAllowedToTeleportOwner(entity, serverlevel)) {
                    Vec3 vec3 = this.oldPosition();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverplayer = (ServerPlayer)entity;
                        if (serverplayer.connection.isAcceptingMessages()) {
                            ServerPlayer serverplayer1;
                            Endermite endermite;
                            EntityTeleportEvent.EnderPearl event = ForgeEventFactory.onEnderPearlLand((ServerPlayer)serverplayer, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ThrownEnderpearl)this, (float)5.0f, (HitResult)p_451483_);
                            if (event == null) {
                                this.discard();
                                return;
                            }
                            vec3 = event.getTarget();
                            if (this.random.nextFloat() < 0.05f && serverlevel.isSpawningMonsters() && (endermite = EntityType.ENDERMITE.create(serverlevel, EntitySpawnReason.TRIGGERED)) != null) {
                                endermite.snapTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                                serverlevel.addFreshEntity(endermite);
                            }
                            if (this.isOnPortalCooldown()) {
                                entity.setPortalCooldown();
                            }
                            if ((serverplayer1 = serverplayer.teleport(new TeleportTransition(serverlevel, vec3, Vec3.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING))) != null) {
                                serverplayer1.resetFallDistance();
                                serverplayer1.resetCurrentImpulseContext();
                                serverplayer1.hurtServer(serverplayer.level(), this.damageSources().enderPearl(), event.getAttackDamage());
                            }
                            this.playSound(serverlevel, vec3);
                        }
                    } else {
                        Entity entity1 = entity.teleport(new TeleportTransition(serverlevel, vec3, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
                        if (entity1 != null) {
                            entity1.resetFallDistance();
                        }
                        this.playSound(serverlevel, vec3);
                    }
                    this.discard();
                } else {
                    this.discard();
                }
            }
        }
    }

    private static boolean isAllowedToTeleportOwner(Entity p_455145_, Level p_450595_) {
        if (p_455145_.level().dimension() == p_450595_.dimension()) {
            boolean bl;
            if (!(p_455145_ instanceof LivingEntity)) {
                bl = p_455145_.isAlive();
            } else {
                LivingEntity livingentity = (LivingEntity)p_455145_;
                bl = livingentity.isAlive() && !livingentity.isSleeping();
            }
            return bl;
        }
        return p_455145_.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        block5: {
            block4: {
                var2_1 = this.level();
                if (!(var2_1 instanceof ServerLevel)) break block4;
                serverlevel = (ServerLevel)var2_1;
                j = SectionPos.blockToSectionCoord(this.position().x());
                $$3 = SectionPos.blockToSectionCoord(this.position().z());
                v0 = entity = this.owner != null ? ThrownEnderpearl.findOwnerIncludingDeadPlayer(serverlevel, this.owner.getUUID()) : null;
                if (!(entity instanceof ServerPlayer)) ** GOTO lbl-1000
                serverplayer = (ServerPlayer)entity;
                if (!entity.isAlive() && !serverplayer.wonGame && serverplayer.level().getGameRules().get(GameRules.ENDER_PEARLS_VANISH_ON_DEATH).booleanValue()) {
                    this.discard();
                } else lbl-1000:
                // 2 sources

                {
                    super.tick();
                }
                if (this.isAlive()) {
                    blockpos = BlockPos.containing(this.position());
                    if ((--this.ticketTimer <= 0L || j != SectionPos.blockToSectionCoord(blockpos.getX()) || $$3 != SectionPos.blockToSectionCoord(blockpos.getZ())) && entity instanceof ServerPlayer) {
                        serverplayer1 = (ServerPlayer)entity;
                        this.ticketTimer = serverplayer1.registerAndUpdateEnderPearlTicket(this);
                    }
                }
                break block5;
            }
            super.tick();
        }
    }

    private void playSound(Level p_453382_, Vec3 p_453690_) {
        p_453382_.playSound(null, p_453690_.x, p_453690_.y, p_453690_.z, SoundEvents.PLAYER_TELEPORT, SoundSource.PLAYERS);
    }

    @Override
    public @Nullable Entity teleport(TeleportTransition p_454458_) {
        Entity entity = super.teleport(p_454458_);
        if (entity != null) {
            entity.placePortalTicket(BlockPos.containing(entity.position()));
        }
        return entity;
    }

    @Override
    public boolean canTeleport(Level p_450310_, Level p_450589_) {
        boolean bl;
        Entity entity;
        if (p_450310_.dimension() == Level.END && p_450589_.dimension() == Level.OVERWORLD && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            bl = super.canTeleport(p_450310_, p_450589_) && serverplayer.seenCredits;
        } else {
            bl = super.canTeleport(p_450310_, p_450589_);
        }
        return bl;
    }

    @Override
    protected void onInsideBlock(BlockState p_453185_) {
        Entity entity;
        super.onInsideBlock(p_453185_);
        if (p_453185_.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.onInsideBlock(p_453185_);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason p_460801_) {
        if (p_460801_ != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(p_460801_);
    }

    @Override
    public void onAboveBubbleColumn(boolean p_455548_, BlockPos p_460769_) {
        Entity.handleOnAboveBubbleColumn(this, p_455548_, p_460769_);
    }

    @Override
    public void onInsideBubbleColumn(boolean p_455880_) {
        Entity.handleOnInsideBubbleColumn(this, p_455880_);
    }
}

