/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record AttackRange(float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
    public static final Codec<AttackRange> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("min_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::minRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("max_reach", (Object)Float.valueOf(3.0f)).forGetter(AttackRange::maxRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("min_creative_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::minCreativeRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("max_creative_reach", (Object)Float.valueOf(5.0f)).forGetter(AttackRange::maxCreativeRange), (App)ExtraCodecs.floatRange(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(AttackRange::hitboxMargin), (App)Codec.floatRange((float)0.0f, (float)2.0f).optionalFieldOf("mob_factor", (Object)Float.valueOf(1.0f)).forGetter(AttackRange::mobFactor)).apply((Applicative)$$0, AttackRange::new));
    public static final StreamCodec<ByteBuf, AttackRange> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, AttackRange::minRange, ByteBufCodecs.FLOAT, AttackRange::maxRange, ByteBufCodecs.FLOAT, AttackRange::minCreativeRange, ByteBufCodecs.FLOAT, AttackRange::maxCreativeRange, ByteBufCodecs.FLOAT, AttackRange::hitboxMargin, ByteBufCodecs.FLOAT, AttackRange::mobFactor, AttackRange::new);

    public static AttackRange defaultFor(LivingEntity $$0) {
        return new AttackRange(0.0f, (float)$$0.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), 0.0f, (float)$$0.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), 0.0f, 1.0f);
    }

    public HitResult getClosesetHit(Entity $$0, float $$1, Predicate<Entity> $$2) {
        Either<BlockHitResult, Collection<EntityHitResult>> $$3 = ProjectileUtil.getHitEntitiesAlong($$0, this, $$2, ClipContext.Block.OUTLINE);
        if ($$3.left().isPresent()) {
            return (HitResult)$$3.left().get();
        }
        Collection $$4 = (Collection)$$3.right().get();
        EntityHitResult $$5 = null;
        Vec3 $$6 = $$0.getEyePosition($$1);
        double $$7 = Double.MAX_VALUE;
        for (EntityHitResult $$8 : $$4) {
            double $$9 = $$6.distanceToSqr($$8.getLocation());
            if (!($$9 < $$7)) continue;
            $$7 = $$9;
            $$5 = $$8;
        }
        if ($$5 != null) {
            return $$5;
        }
        Vec3 $$10 = $$0.getHeadLookAngle();
        Vec3 $$11 = $$0.getEyePosition($$1).add($$10);
        return BlockHitResult.miss($$11, Direction.getApproximateNearest($$10), BlockPos.containing($$11));
    }

    public float effectiveMinRange(Entity $$0) {
        if ($$0 instanceof Player) {
            Player $$1 = (Player)$$0;
            if ($$1.isSpectator()) {
                return 0.0f;
            }
            return $$1.isCreative() ? this.minCreativeRange : this.minRange;
        }
        return this.minRange * this.mobFactor;
    }

    public float effectiveMaxRange(Entity $$0) {
        if ($$0 instanceof Player) {
            Player $$1 = (Player)$$0;
            return $$1.isCreative() ? this.maxCreativeRange : this.maxRange;
        }
        return this.maxRange * this.mobFactor;
    }

    public boolean isInRange(LivingEntity $$0, Vec3 $$1) {
        return this.isInRange($$0, $$1::distanceToSqr, 0.0);
    }

    public boolean isInRange(LivingEntity $$0, AABB $$1, double $$2) {
        return this.isInRange($$0, $$1::distanceToSqr, $$2);
    }

    private boolean isInRange(LivingEntity $$0, ToDoubleFunction<Vec3> $$1, double $$2) {
        double $$3 = Math.sqrt($$1.applyAsDouble($$0.getEyePosition()));
        double $$4 = (double)(this.effectiveMinRange($$0) - this.hitboxMargin) - $$2;
        double $$5 = (double)(this.effectiveMaxRange($$0) + this.hitboxMargin) + $$2;
        return $$3 >= $$4 && $$3 <= $$5;
    }
}

