/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;
import org.jspecify.annotations.Nullable;

public record ItemAttributeModifiers(List<Entry> modifiers) {
    public static final ItemAttributeModifiers EMPTY = new ItemAttributeModifiers(List.of());
    public static final Codec<ItemAttributeModifiers> CODEC = Entry.CODEC.listOf().xmap(ItemAttributeModifiers::new, ItemAttributeModifiers::modifiers);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemAttributeModifiers> STREAM_CODEC = StreamCodec.composite(Entry.STREAM_CODEC.apply(ByteBufCodecs.list()), ItemAttributeModifiers::modifiers, ItemAttributeModifiers::new);
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ROOT));

    public static Builder builder() {
        return new Builder();
    }

    public ItemAttributeModifiers withModifierAdded(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2) {
        ImmutableList.Builder $$3 = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        for (Entry $$4 : this.modifiers) {
            if ($$4.matches($$0, $$1.id())) continue;
            $$3.add((Object)$$4);
        }
        $$3.add((Object)new Entry($$0, $$1, $$2));
        return new ItemAttributeModifiers((List<Entry>)$$3.build());
    }

    public void forEach(EquipmentSlotGroup $$0, TriConsumer<Holder<Attribute>, AttributeModifier, Display> $$1) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.equals($$0)) continue;
            $$1.accept($$2.attribute, (Object)$$2.modifier, (Object)$$2.display);
        }
    }

    public void forEach(EquipmentSlotGroup $$0, BiConsumer<Holder<Attribute>, AttributeModifier> $$1) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.equals($$0)) continue;
            $$1.accept($$2.attribute, $$2.modifier);
        }
    }

    public void forEach(EquipmentSlot $$0, BiConsumer<Holder<Attribute>, AttributeModifier> $$1) {
        for (Entry $$2 : this.modifiers) {
            if (!$$2.slot.test($$0)) continue;
            $$1.accept($$2.attribute, $$2.modifier);
        }
    }

    public double compute(Holder<Attribute> $$0, double $$1, EquipmentSlot $$2) {
        double $$3 = $$1;
        for (Entry $$4 : this.modifiers) {
            if (!$$4.slot.test($$2) || $$4.attribute != $$0) continue;
            double $$5 = $$4.modifier.amount();
            $$3 += (switch ($$4.modifier.operation()) {
                default -> throw new MatchException(null, null);
                case AttributeModifier.Operation.ADD_VALUE -> $$5;
                case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> $$5 * $$1;
                case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> $$5 * $$3;
            });
        }
        return $$3;
    }

    public static class Builder {
        private final ImmutableList.Builder<Entry> entries = ImmutableList.builder();

        Builder() {
        }

        public Builder add(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2) {
            this.entries.add((Object)new Entry($$0, $$1, $$2));
            return this;
        }

        public Builder add(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2, Display $$3) {
            this.entries.add((Object)new Entry($$0, $$1, $$2, $$3));
            return this;
        }

        public ItemAttributeModifiers build() {
            return new ItemAttributeModifiers((List<Entry>)this.entries.build());
        }
    }

    public record Entry(Holder<Attribute> attribute, AttributeModifier modifier, EquipmentSlotGroup slot, Display display) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Attribute.CODEC.fieldOf("type").forGetter(Entry::attribute), (App)AttributeModifier.MAP_CODEC.forGetter(Entry::modifier), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(Entry::slot), (App)Display.CODEC.optionalFieldOf("display", (Object)Display.Default.INSTANCE).forGetter(Entry::display)).apply((Applicative)$$0, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(Attribute.STREAM_CODEC, Entry::attribute, AttributeModifier.STREAM_CODEC, Entry::modifier, EquipmentSlotGroup.STREAM_CODEC, Entry::slot, Display.STREAM_CODEC, Entry::display, Entry::new);

        public Entry(Holder<Attribute> $$0, AttributeModifier $$1, EquipmentSlotGroup $$2) {
            this($$0, $$1, $$2, Display.attributeModifiers());
        }

        public boolean matches(Holder<Attribute> $$0, Identifier $$1) {
            return $$0.equals(this.attribute) && this.modifier.is($$1);
        }
    }

    public static interface Display {
        public static final Codec<Display> CODEC = Type.CODEC.dispatch("type", Display::type, $$0 -> $$0.codec);
        public static final StreamCodec<RegistryFriendlyByteBuf, Display> STREAM_CODEC = Type.STREAM_CODEC.cast().dispatch(Display::type, Type::streamCodec);

        public static Display attributeModifiers() {
            return Default.INSTANCE;
        }

        public static Display hidden() {
            return Hidden.INSTANCE;
        }

        public static Display override(Component $$0) {
            return new OverrideText($$0);
        }

        public Type type();

        public void apply(Consumer<Component> var1, @Nullable Player var2, Holder<Attribute> var3, AttributeModifier var4);

        public record Default() implements Display
        {
            static final Default INSTANCE = new Default();
            static final MapCodec<Default> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Default> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.DEFAULT;
            }

            @Override
            public void apply(Consumer<Component> $$0, @Nullable Player $$1, Holder<Attribute> $$2, AttributeModifier $$3) {
                double $$8;
                double $$4 = $$3.amount();
                boolean $$5 = false;
                if ($$1 != null) {
                    if ($$3.is(Item.BASE_ATTACK_DAMAGE_ID)) {
                        $$4 += $$1.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
                        $$5 = true;
                    } else if ($$3.is(Item.BASE_ATTACK_SPEED_ID)) {
                        $$4 += $$1.getAttributeBaseValue(Attributes.ATTACK_SPEED);
                        $$5 = true;
                    }
                }
                if ($$3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || $$3.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL) {
                    double $$6 = $$4 * 100.0;
                } else if ($$2.is(Attributes.KNOCKBACK_RESISTANCE)) {
                    double $$7 = $$4 * 10.0;
                } else {
                    $$8 = $$4;
                }
                if ($$5) {
                    $$0.accept(CommonComponents.space().append(Component.translatable("attribute.modifier.equals." + $$3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format($$8), Component.translatable($$2.value().getDescriptionId()))).withStyle(ChatFormatting.DARK_GREEN));
                } else if ($$4 > 0.0) {
                    $$0.accept(Component.translatable("attribute.modifier.plus." + $$3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format($$8), Component.translatable($$2.value().getDescriptionId())).withStyle($$2.value().getStyle(true)));
                } else if ($$4 < 0.0) {
                    $$0.accept(Component.translatable("attribute.modifier.take." + $$3.operation().id(), ATTRIBUTE_MODIFIER_FORMAT.format(-$$8), Component.translatable($$2.value().getDescriptionId())).withStyle($$2.value().getStyle(false)));
                }
            }
        }

        public record Hidden() implements Display
        {
            static final Hidden INSTANCE = new Hidden();
            static final MapCodec<Hidden> CODEC = MapCodec.unit((Object)INSTANCE);
            static final StreamCodec<RegistryFriendlyByteBuf, Hidden> STREAM_CODEC = StreamCodec.unit(INSTANCE);

            @Override
            public Type type() {
                return Type.HIDDEN;
            }

            @Override
            public void apply(Consumer<Component> $$0, @Nullable Player $$1, Holder<Attribute> $$2, AttributeModifier $$3) {
            }
        }

        public record OverrideText(Component component) implements Display
        {
            static final MapCodec<OverrideText> CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)ComponentSerialization.CODEC.fieldOf("value").forGetter(OverrideText::component)).apply((Applicative)$$0, OverrideText::new));
            static final StreamCodec<RegistryFriendlyByteBuf, OverrideText> STREAM_CODEC = StreamCodec.composite(ComponentSerialization.STREAM_CODEC, OverrideText::component, OverrideText::new);

            @Override
            public Type type() {
                return Type.OVERRIDE;
            }

            @Override
            public void apply(Consumer<Component> $$0, @Nullable Player $$1, Holder<Attribute> $$2, AttributeModifier $$3) {
                $$0.accept(this.component);
            }
        }

        public static enum Type implements StringRepresentable
        {
            DEFAULT("default", 0, Default.CODEC, Default.STREAM_CODEC),
            HIDDEN("hidden", 1, Hidden.CODEC, Hidden.STREAM_CODEC),
            OVERRIDE("override", 2, OverrideText.CODEC, OverrideText.STREAM_CODEC);

            static final Codec<Type> CODEC;
            private static final IntFunction<Type> BY_ID;
            static final StreamCodec<ByteBuf, Type> STREAM_CODEC;
            private final String name;
            private final int id;
            final MapCodec<? extends Display> codec;
            private final StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec;

            private Type(String $$0, int $$1, MapCodec<? extends Display> $$2, StreamCodec<RegistryFriendlyByteBuf, ? extends Display> $$3) {
                this.name = $$0;
                this.id = $$1;
                this.codec = $$2;
                this.streamCodec = $$3;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private int id() {
                return this.id;
            }

            private StreamCodec<RegistryFriendlyByteBuf, ? extends Display> streamCodec() {
                return this.streamCodec;
            }

            static {
                CODEC = StringRepresentable.fromEnum(Type::values);
                BY_ID = ByIdMap.continuous(Type::id, Type.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
                STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Type::id);
            }
        }
    }
}

