/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.item.component.PiercingWeapon;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public record KineticWeapon(int contactCooldownTicks, int delayTicks, Optional<Condition> dismountConditions, Optional<Condition> knockbackConditions, Optional<Condition> damageConditions, float forwardMovement, float damageMultiplier, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final int HIT_FEEDBACK_TICKS = 10;
    public static final Codec<KineticWeapon> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("contact_cooldown_ticks", (Object)10).forGetter(KineticWeapon::contactCooldownTicks), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("delay_ticks", (Object)0).forGetter(KineticWeapon::delayTicks), (App)Condition.CODEC.optionalFieldOf("dismount_conditions").forGetter(KineticWeapon::dismountConditions), (App)Condition.CODEC.optionalFieldOf("knockback_conditions").forGetter(KineticWeapon::knockbackConditions), (App)Condition.CODEC.optionalFieldOf("damage_conditions").forGetter(KineticWeapon::damageConditions), (App)Codec.FLOAT.optionalFieldOf("forward_movement", (Object)Float.valueOf(0.0f)).forGetter(KineticWeapon::forwardMovement), (App)Codec.FLOAT.optionalFieldOf("damage_multiplier", (Object)Float.valueOf(1.0f)).forGetter(KineticWeapon::damageMultiplier), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(KineticWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(KineticWeapon::hitSound)).apply((Applicative)$$0, KineticWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, KineticWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, KineticWeapon::contactCooldownTicks, ByteBufCodecs.VAR_INT, KineticWeapon::delayTicks, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::dismountConditions, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::knockbackConditions, Condition.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::damageConditions, ByteBufCodecs.FLOAT, KineticWeapon::forwardMovement, ByteBufCodecs.FLOAT, KineticWeapon::damageMultiplier, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::sound, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), KineticWeapon::hitSound, KineticWeapon::new);

    public static Vec3 getMotion(Entity $$0) {
        if (!($$0 instanceof Player) && $$0.isPassenger()) {
            $$0 = $$0.getRootVehicle();
        }
        return $$0.getKnownSpeed().scale(20.0);
    }

    public void makeSound(Entity $$0) {
        this.sound.ifPresent($$1 -> $$0.level().playSound($$0, $$0.getX(), $$0.getY(), $$0.getZ(), (Holder<SoundEvent>)$$1, $$0.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeLocalHitSound(Entity $$0) {
        this.hitSound.ifPresent($$1 -> $$0.level().playLocalSound($$0, (SoundEvent)$$1.value(), $$0.getSoundSource(), 1.0f, 1.0f));
    }

    public int computeDamageUseDuration() {
        return this.delayTicks + this.damageConditions.map(Condition::maxDurationTicks).orElse(0);
    }

    public void damageEntities(ItemStack $$02, int $$12, LivingEntity $$2, EquipmentSlot $$3) {
        int $$4 = $$02.getUseDuration($$2) - $$12;
        if ($$4 < this.delayTicks) {
            return;
        }
        $$4 -= this.delayTicks;
        Vec3 $$5 = $$2.getLookAngle();
        double $$6 = $$5.dot(KineticWeapon.getMotion($$2));
        float $$7 = $$2 instanceof Player ? 1.0f : 0.2f;
        AttackRange $$8 = $$2.entityAttackRange();
        double $$9 = $$2.getAttributeBaseValue(Attributes.ATTACK_DAMAGE);
        boolean $$10 = false;
        for (EntityHitResult $$11 : (Collection)ProjectileUtil.getHitEntitiesAlong($$2, $$8, $$1 -> PiercingWeapon.canHitEntity($$2, $$1), ClipContext.Block.COLLIDER).map($$0 -> List.of(), $$0 -> $$0)) {
            boolean $$19;
            boolean $$14;
            Entity $$122 = $$11.getEntity();
            if ($$122 instanceof EnderDragonPart) {
                EnderDragonPart $$13 = (EnderDragonPart)((Object)$$122);
                $$122 = $$13.parentMob;
            }
            if ($$14 = $$2.wasRecentlyStabbed($$122, this.contactCooldownTicks)) continue;
            $$2.rememberStabbedEntity($$122);
            double $$15 = $$5.dot(KineticWeapon.getMotion($$122));
            double $$16 = Math.max(0.0, $$6 - $$15);
            boolean $$17 = this.dismountConditions.isPresent() && this.dismountConditions.get().test($$4, $$6, $$16, $$7);
            boolean $$18 = this.knockbackConditions.isPresent() && this.knockbackConditions.get().test($$4, $$6, $$16, $$7);
            boolean bl = $$19 = this.damageConditions.isPresent() && this.damageConditions.get().test($$4, $$6, $$16, $$7);
            if (!$$17 && !$$18 && !$$19) continue;
            float $$20 = (float)$$9 + (float)Mth.floor($$16 * (double)this.damageMultiplier);
            $$10 |= $$2.stabAttack($$3, $$122, $$20, $$19, $$18, $$17);
        }
        if ($$10) {
            $$2.level().broadcastEntityEvent($$2, (byte)2);
            if ($$2 instanceof ServerPlayer) {
                ServerPlayer $$21 = (ServerPlayer)$$2;
                CriteriaTriggers.SPEAR_MOBS_TRIGGER.trigger($$21, $$2.stabbedEntities($$0 -> $$0 instanceof LivingEntity));
            }
        }
    }

    public record Condition(int maxDurationTicks, float minSpeed, float minRelativeSpeed) {
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("max_duration_ticks").forGetter(Condition::maxDurationTicks), (App)Codec.FLOAT.optionalFieldOf("min_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minSpeed), (App)Codec.FLOAT.optionalFieldOf("min_relative_speed", (Object)Float.valueOf(0.0f)).forGetter(Condition::minRelativeSpeed)).apply((Applicative)$$0, Condition::new));
        public static final StreamCodec<ByteBuf, Condition> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, Condition::maxDurationTicks, ByteBufCodecs.FLOAT, Condition::minSpeed, ByteBufCodecs.FLOAT, Condition::minRelativeSpeed, Condition::new);

        public boolean test(int $$0, double $$1, double $$2, double $$3) {
            return $$0 <= this.maxDurationTicks && $$1 >= (double)this.minSpeed * $$3 && $$2 >= (double)this.minRelativeSpeed * $$3;
        }

        public static Optional<Condition> ofAttackerSpeed(int $$0, float $$1) {
            return Optional.of(new Condition($$0, $$1, 0.0f));
        }

        public static Optional<Condition> ofRelativeSpeed(int $$0, float $$1) {
            return Optional.of(new Condition($$0, 0.0f, $$1));
        }
    }
}

