/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.component.AttackRange;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.EntityHitResult;

public record PiercingWeapon(boolean dealsKnockback, boolean dismounts, Optional<Holder<SoundEvent>> sound, Optional<Holder<SoundEvent>> hitSound) {
    public static final Codec<PiercingWeapon> CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.BOOL.optionalFieldOf("deals_knockback", (Object)true).forGetter(PiercingWeapon::dealsKnockback), (App)Codec.BOOL.optionalFieldOf("dismounts", (Object)false).forGetter(PiercingWeapon::dismounts), (App)SoundEvent.CODEC.optionalFieldOf("sound").forGetter(PiercingWeapon::sound), (App)SoundEvent.CODEC.optionalFieldOf("hit_sound").forGetter(PiercingWeapon::hitSound)).apply((Applicative)$$0, PiercingWeapon::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PiercingWeapon> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, PiercingWeapon::dealsKnockback, ByteBufCodecs.BOOL, PiercingWeapon::dismounts, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::sound, SoundEvent.STREAM_CODEC.apply(ByteBufCodecs::optional), PiercingWeapon::hitSound, PiercingWeapon::new);

    public void makeSound(Entity $$0) {
        this.sound.ifPresent($$1 -> $$0.level().playSound($$0, $$0.getX(), $$0.getY(), $$0.getZ(), (Holder<SoundEvent>)$$1, $$0.getSoundSource(), 1.0f, 1.0f));
    }

    public void makeHitSound(Entity $$0) {
        this.hitSound.ifPresent($$1 -> $$0.level().playSound(null, $$0.getX(), $$0.getY(), $$0.getZ(), (Holder<SoundEvent>)$$1, $$0.getSoundSource(), 1.0f, 1.0f));
    }

    public static boolean canHitEntity(Entity $$0, Entity $$1) {
        if ($$1.isInvulnerable() || !$$1.isAlive()) {
            return false;
        }
        if ($$1 instanceof Interaction) {
            return true;
        }
        if (!$$1.canBeHitByProjectile()) {
            return false;
        }
        if ($$1 instanceof Player) {
            Player $$3;
            Player $$2 = (Player)$$1;
            if ($$0 instanceof Player && !($$3 = (Player)$$0).canHarmPlayer($$2)) {
                return false;
            }
        }
        return !$$0.isPassengerOfSameVehicle($$1);
    }

    public void attack(LivingEntity $$02, EquipmentSlot $$12) {
        float $$2 = (float)$$02.getAttributeValue(Attributes.ATTACK_DAMAGE);
        AttackRange $$3 = $$02.entityAttackRange();
        boolean $$4 = false;
        for (EntityHitResult $$5 : (Collection)ProjectileUtil.getHitEntitiesAlong($$02, $$3, $$1 -> PiercingWeapon.canHitEntity($$02, $$1), ClipContext.Block.COLLIDER).map($$0 -> List.of(), $$0 -> $$0)) {
            $$4 |= $$02.stabAttack($$12, $$5.getEntity(), $$2, true, this.dealsKnockback, this.dismounts);
        }
        $$02.onAttack();
        $$02.lungeForwardMaybe();
        if ($$4) {
            this.makeHitSound($$02);
        }
        this.makeSound($$02);
        $$02.swing(InteractionHand.MAIN_HAND, false);
    }
}

