/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import net.minecraft.world.entity.player.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public abstract sealed class ResolvableProfile
implements TooltipProvider {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create($$0 -> $$0.group((App)Codec.mapEither(ExtraCodecs.STORED_GAME_PROFILE, Partial.MAP_CODEC).forGetter(ResolvableProfile::unpack), (App)PlayerSkin.Patch.MAP_CODEC.forGetter(ResolvableProfile::skinPatch)).apply((Applicative)$$0, ResolvableProfile::create));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, ResolvableProfile::createUnresolved);
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.either(ByteBufCodecs.GAME_PROFILE, Partial.STREAM_CODEC), ResolvableProfile::unpack, PlayerSkin.Patch.STREAM_CODEC, ResolvableProfile::skinPatch, ResolvableProfile::create);
    protected final GameProfile partialProfile;
    protected final PlayerSkin.Patch skinPatch;

    private static ResolvableProfile create(Either<GameProfile, Partial> $$0, PlayerSkin.Patch $$13) {
        return (ResolvableProfile)$$0.map($$1 -> new Static((Either<GameProfile, Partial>)Either.left((Object)$$1), $$13), $$12 -> {
            if (!$$12.properties.isEmpty() || $$12.id.isPresent() == $$12.name.isPresent()) {
                return new Static((Either<GameProfile, Partial>)Either.right((Object)$$12), $$13);
            }
            return $$12.name.map($$1 -> new Dynamic((Either<String, UUID>)Either.left((Object)$$1), $$13)).orElseGet(() -> new Dynamic((Either<String, UUID>)Either.right((Object)$$0.id.get()), $$13));
        });
    }

    public static ResolvableProfile createResolved(GameProfile $$0) {
        return new Static((Either<GameProfile, Partial>)Either.left((Object)$$0), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(String $$0) {
        return new Dynamic((Either<String, UUID>)Either.left((Object)$$0), PlayerSkin.Patch.EMPTY);
    }

    public static ResolvableProfile createUnresolved(UUID $$0) {
        return new Dynamic((Either<String, UUID>)Either.right((Object)$$0), PlayerSkin.Patch.EMPTY);
    }

    protected abstract Either<GameProfile, Partial> unpack();

    protected ResolvableProfile(GameProfile $$0, PlayerSkin.Patch $$1) {
        this.partialProfile = $$0;
        this.skinPatch = $$1;
    }

    public abstract CompletableFuture<GameProfile> resolveProfile(ProfileResolver var1);

    public GameProfile partialProfile() {
        return this.partialProfile;
    }

    public PlayerSkin.Patch skinPatch() {
        return this.skinPatch;
    }

    static GameProfile createPartialProfile(Optional<String> $$0, Optional<UUID> $$1, PropertyMap $$2) {
        String $$3 = $$0.orElse("");
        UUID $$4 = $$1.orElseGet(() -> $$0.map(UUIDUtil::createOfflinePlayerUUID).orElse(Util.NIL_UUID));
        return new GameProfile($$4, $$3, $$2);
    }

    public abstract Optional<String> name();

    public static final class Static
    extends ResolvableProfile {
        public static final Static EMPTY = new Static((Either<GameProfile, Partial>)Either.right((Object)Partial.EMPTY), PlayerSkin.Patch.EMPTY);
        private final Either<GameProfile, Partial> contents;

        Static(Either<GameProfile, Partial> $$02, PlayerSkin.Patch $$1) {
            super((GameProfile)$$02.map($$0 -> $$0, Partial::createProfile), $$1);
            this.contents = $$02;
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver $$0) {
            return CompletableFuture.completedFuture(this.partialProfile);
        }

        @Override
        protected Either<GameProfile, Partial> unpack() {
            return this.contents;
        }

        @Override
        public Optional<String> name() {
            return (Optional)this.contents.map($$0 -> Optional.of($$0.name()), $$0 -> $$0.name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object $$0) {
            if (this == $$0) return true;
            if (!($$0 instanceof Static)) return false;
            Static $$1 = (Static)$$0;
            if (!this.contents.equals($$1.contents)) return false;
            if (!this.skinPatch.equals($$1.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int $$0 = 31 + this.contents.hashCode();
            $$0 = 31 * $$0 + this.skinPatch.hashCode();
            return $$0;
        }

        @Override
        public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2, DataComponentGetter $$3) {
        }
    }

    public static final class Dynamic
    extends ResolvableProfile {
        private static final Component DYNAMIC_TOOLTIP = Component.translatable("component.profile.dynamic").withStyle(ChatFormatting.GRAY);
        private final Either<String, UUID> nameOrId;

        Dynamic(Either<String, UUID> $$0, PlayerSkin.Patch $$1) {
            super(ResolvableProfile.createPartialProfile($$0.left(), $$0.right(), PropertyMap.EMPTY), $$1);
            this.nameOrId = $$0;
        }

        @Override
        public Optional<String> name() {
            return this.nameOrId.left();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object $$0) {
            if (this == $$0) return true;
            if (!($$0 instanceof Dynamic)) return false;
            Dynamic $$1 = (Dynamic)$$0;
            if (!this.nameOrId.equals($$1.nameOrId)) return false;
            if (!this.skinPatch.equals($$1.skinPatch)) return false;
            return true;
        }

        public int hashCode() {
            int $$0 = 31 + this.nameOrId.hashCode();
            $$0 = 31 * $$0 + this.skinPatch.hashCode();
            return $$0;
        }

        @Override
        protected Either<GameProfile, Partial> unpack() {
            return Either.right((Object)new Partial(this.nameOrId.left(), this.nameOrId.right(), PropertyMap.EMPTY));
        }

        @Override
        public CompletableFuture<GameProfile> resolveProfile(ProfileResolver $$0) {
            return CompletableFuture.supplyAsync(() -> $$0.fetchByNameOrId(this.nameOrId).orElse(this.partialProfile), Util.nonCriticalIoPool());
        }

        @Override
        public void addToTooltip(Item.TooltipContext $$0, Consumer<Component> $$1, TooltipFlag $$2, DataComponentGetter $$3) {
            $$1.accept(DYNAMIC_TOOLTIP);
        }
    }

    protected record Partial(Optional<String> name, Optional<UUID> id, PropertyMap properties) {
        public static final Partial EMPTY = new Partial(Optional.empty(), Optional.empty(), PropertyMap.EMPTY);
        static final MapCodec<Partial> MAP_CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(Partial::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(Partial::id), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)PropertyMap.EMPTY).forGetter(Partial::properties)).apply((Applicative)$$0, Partial::new));
        public static final StreamCodec<ByteBuf, Partial> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.PLAYER_NAME.apply(ByteBufCodecs::optional), Partial::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), Partial::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, Partial::properties, Partial::new);

        private GameProfile createProfile() {
            return ResolvableProfile.createPartialProfile(this.name, this.id, this.properties);
        }
    }
}

