/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.inventory.SlotRanges;
import net.minecraft.world.item.slot.SlotCollection;
import net.minecraft.world.item.slot.SlotSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextArg;

public class RangeSlotSource
implements SlotSource {
    public static final MapCodec<RangeSlotSource> MAP_CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)LootContextArg.ENTITY_OR_BLOCK.fieldOf("source").forGetter($$0 -> $$0.source), (App)SlotRanges.CODEC.fieldOf("slots").forGetter($$0 -> $$0.slotRange)).apply((Applicative)$$02, RangeSlotSource::new));
    private final LootContextArg<Object> source;
    private final SlotRange slotRange;

    private RangeSlotSource(LootContextArg<Object> $$0, SlotRange $$1) {
        this.source = $$0;
        this.slotRange = $$1;
    }

    public MapCodec<RangeSlotSource> codec() {
        return MAP_CODEC;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return Set.of(this.source.contextParam());
    }

    @Override
    public final SlotCollection provide(LootContext $$0) {
        Object $$1 = this.source.get($$0);
        if ($$1 instanceof SlotProvider) {
            SlotProvider $$2 = (SlotProvider)$$1;
            return $$2.getSlotsFromRange(this.slotRange.slots());
        }
        return SlotCollection.EMPTY;
    }
}

