/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;

public interface SlotCollection {
    public static final SlotCollection EMPTY = Stream::empty;

    public Stream<ItemStack> itemCopies();

    default public SlotCollection filter(Predicate<ItemStack> $$0) {
        return new Filtered(this, $$0);
    }

    default public SlotCollection flatMap(Function<ItemStack, ? extends SlotCollection> $$0) {
        return new FlatMapped(this, $$0);
    }

    default public SlotCollection limit(int $$0) {
        return new Limited(this, $$0);
    }

    public static SlotCollection of(SlotAccess $$0) {
        return () -> Stream.of($$0.get().copy());
    }

    public static SlotCollection of(Collection<? extends SlotAccess> $$0) {
        return switch ($$0.size()) {
            case 0 -> EMPTY;
            case 1 -> SlotCollection.of($$0.iterator().next());
            default -> () -> $$0.stream().map(SlotAccess::get).map(ItemStack::copy);
        };
    }

    public static SlotCollection concat(SlotCollection $$0, SlotCollection $$1) {
        return () -> Stream.concat($$0.itemCopies(), $$1.itemCopies());
    }

    public static SlotCollection concat(List<? extends SlotCollection> $$0) {
        return switch ($$0.size()) {
            case 0 -> EMPTY;
            case 1 -> $$0.getFirst();
            case 2 -> SlotCollection.concat($$0.get(0), $$0.get(1));
            default -> () -> $$0.stream().flatMap(SlotCollection::itemCopies);
        };
    }

    public record Filtered(SlotCollection slots, Predicate<ItemStack> filter) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().filter(this.filter);
        }

        @Override
        public SlotCollection filter(Predicate<ItemStack> $$0) {
            return new Filtered(this.slots, this.filter.and($$0));
        }
    }

    public record FlatMapped(SlotCollection slots, Function<ItemStack, ? extends SlotCollection> mapper) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().map(this.mapper).flatMap(SlotCollection::itemCopies);
        }
    }

    public record Limited(SlotCollection slots, int limit) implements SlotCollection
    {
        @Override
        public Stream<ItemStack> itemCopies() {
            return this.slots.itemCopies().limit(this.limit);
        }

        @Override
        public SlotCollection limit(int $$0) {
            return new Limited(this.slots, Math.min(this.limit, $$0));
        }
    }
}

