/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.slot.ContentsSlotSource;
import net.minecraft.world.item.slot.EmptySlotSource;
import net.minecraft.world.item.slot.FilteredSlotSource;
import net.minecraft.world.item.slot.GroupSlotSource;
import net.minecraft.world.item.slot.LimitSlotSource;
import net.minecraft.world.item.slot.RangeSlotSource;
import net.minecraft.world.item.slot.SlotCollection;
import net.minecraft.world.item.slot.SlotSource;
import net.minecraft.world.level.storage.loot.LootContext;

public interface SlotSources {
    public static final Codec<SlotSource> TYPED_CODEC = BuiltInRegistries.SLOT_SOURCE_TYPE.byNameCodec().dispatch(SlotSource::codec, $$0 -> $$0);
    public static final Codec<SlotSource> CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, GroupSlotSource.INLINE_CODEC));

    public static MapCodec<? extends SlotSource> bootstrap(Registry<MapCodec<? extends SlotSource>> $$0) {
        Registry.register($$0, "group", GroupSlotSource.MAP_CODEC);
        Registry.register($$0, "filtered", FilteredSlotSource.MAP_CODEC);
        Registry.register($$0, "limit_slots", LimitSlotSource.MAP_CODEC);
        Registry.register($$0, "slot_range", RangeSlotSource.MAP_CODEC);
        Registry.register($$0, "contents", ContentsSlotSource.MAP_CODEC);
        return Registry.register($$0, "empty", EmptySlotSource.MAP_CODEC);
    }

    public static Function<LootContext, SlotCollection> group(Collection<? extends SlotSource> $$02) {
        List<? extends SlotSource> $$12 = List.copyOf($$02);
        return switch ($$12.size()) {
            case 0 -> $$0 -> SlotCollection.EMPTY;
            case 1 -> $$12.getFirst()::provide;
            case 2 -> {
                SlotSource $$2 = $$12.get(0);
                SlotSource $$3 = $$12.get(1);
                yield $$2 -> SlotCollection.concat($$2.provide((LootContext)$$2), $$3.provide((LootContext)$$2));
            }
            default -> $$1 -> {
                ArrayList<SlotCollection> $$2 = new ArrayList<SlotCollection>();
                for (SlotSource $$3 : $$12) {
                    $$2.add($$3.provide((LootContext)$$1));
                }
                return SlotCollection.concat($$2);
            };
        };
    }
}

