/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;

public record BiomeSpecialEffects(int waterColor, Optional<Integer> foliageColorOverride, Optional<Integer> dryFoliageColorOverride, Optional<Integer> grassColorOverride, GrassColorModifier grassColorModifier) {
    public static final Codec<BiomeSpecialEffects> CODEC = RecordCodecBuilder.create(p_449881_ -> p_449881_.group((App)ExtraCodecs.STRING_RGB_COLOR.fieldOf("water_color").forGetter(BiomeSpecialEffects::waterColor), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("foliage_color").forGetter(BiomeSpecialEffects::foliageColorOverride), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("dry_foliage_color").forGetter(BiomeSpecialEffects::dryFoliageColorOverride), (App)ExtraCodecs.STRING_RGB_COLOR.optionalFieldOf("grass_color").forGetter(BiomeSpecialEffects::grassColorOverride), (App)GrassColorModifier.CODEC.optionalFieldOf("grass_color_modifier", (Object)GrassColorModifier.NONE).forGetter(BiomeSpecialEffects::grassColorModifier)).apply((Applicative)p_449881_, BiomeSpecialEffects::new));

    public BiomeSpecialEffectsBuilder copy() {
        return BiomeSpecialEffectsBuilder.copyOf((BiomeSpecialEffects)this);
    }

    public static enum GrassColorModifier implements StringRepresentable,
    IExtensibleEnum
    {
        NONE("none"){

            @Override
            public int modifyColor(double p_48081_, double p_48082_, int p_48083_) {
                return p_48083_;
            }
        }
        ,
        DARK_FOREST("dark_forest"){

            @Override
            public int modifyColor(double p_48089_, double p_48090_, int p_48091_) {
                return (p_48091_ & 0xFEFEFE) + 2634762 >> 1;
            }
        }
        ,
        SWAMP("swamp"){

            @Override
            public int modifyColor(double p_48097_, double p_48098_, int p_48099_) {
                double d0 = Biome.BIOME_INFO_NOISE.getValue(p_48097_ * 0.0225, p_48098_ * 0.0225, false);
                return d0 < -0.1 ? 5011004 : 6975545;
            }
        };

        private final String name;
        public static final Codec<GrassColorModifier> CODEC;
        private static final Map<String, GrassColorModifier> BY_NAME;
        private ColorModifier delegate;

        public int modifyColor(double p_48065_, double p_48066_, int p_48067_) {
            return this.delegate.modifyGrassColor(p_48065_, p_48066_, p_48067_);
        }

        private GrassColorModifier(String p_48058_) {
            this.name = p_48058_;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private GrassColorModifier(String name, ColorModifier delegate) {
            this(name);
            this.delegate = delegate;
        }

        public static GrassColorModifier create(String name, String id, ColorModifier delegate) {
            throw new IllegalStateException("Enum not extended");
        }

        public void init() {
            BY_NAME.put(this.getName(), this);
        }

        public static GrassColorModifier byName(String name) {
            return BY_NAME.get(name);
        }

        static {
            CODEC = IExtensibleEnum.createCodecForExtensibleEnum(GrassColorModifier::values, GrassColorModifier::byName);
            BY_NAME = Arrays.stream(GrassColorModifier.values()).collect(Collectors.toMap(GrassColorModifier::getName, grassColorModifier -> grassColorModifier));
        }

        @FunctionalInterface
        public static interface ColorModifier {
            public int modifyGrassColor(double var1, double var3, int var5);
        }
    }

    public static class Builder {
        protected OptionalInt waterColor = OptionalInt.empty();
        protected Optional<Integer> foliageColorOverride = Optional.empty();
        protected Optional<Integer> dryFoliageColorOverride = Optional.empty();
        protected Optional<Integer> grassColorOverride = Optional.empty();
        protected GrassColorModifier grassColorModifier = GrassColorModifier.NONE;

        public static BiomeSpecialEffectsBuilder create() {
            return BiomeSpecialEffectsBuilder.create();
        }

        public Builder waterColor(int p_48035_) {
            this.waterColor = OptionalInt.of(p_48035_);
            return this;
        }

        public Builder foliageColorOverride(int p_48044_) {
            this.foliageColorOverride = Optional.of(p_48044_);
            return this;
        }

        public Builder dryFoliageColorOverride(int p_394617_) {
            this.dryFoliageColorOverride = Optional.of(p_394617_);
            return this;
        }

        public Builder grassColorOverride(int p_48046_) {
            this.grassColorOverride = Optional.of(p_48046_);
            return this;
        }

        public Builder grassColorModifier(GrassColorModifier p_48032_) {
            this.grassColorModifier = p_48032_;
            return this;
        }

        public BiomeSpecialEffects build() {
            return new BiomeSpecialEffects(this.waterColor.orElseThrow(() -> new IllegalStateException("Missing 'water' color.")), this.foliageColorOverride, this.dryFoliageColorOverride, this.grassColorOverride, this.grassColorModifier);
        }
    }
}

