/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SideChainPart;

public interface SideChainPartBlock {
    public SideChainPart getSideChainPart(BlockState var1);

    public BlockState setSideChainPart(BlockState var1, SideChainPart var2);

    public Direction getFacing(BlockState var1);

    public boolean isConnectable(BlockState var1);

    public int getMaxChainLength();

    default public List<BlockPos> getAllBlocksConnectedTo(LevelAccessor $$0, BlockPos $$1) {
        BlockState $$2 = $$0.getBlockState($$1);
        if (!this.isConnectable($$2)) {
            return List.of();
        }
        Neighbors $$3 = this.getNeighbors($$0, $$1, this.getFacing($$2));
        LinkedList<BlockPos> $$4 = new LinkedList<BlockPos>();
        $$4.add($$1);
        this.addBlocksConnectingTowards($$3::left, SideChainPart.LEFT, $$4::addFirst);
        this.addBlocksConnectingTowards($$3::right, SideChainPart.RIGHT, $$4::addLast);
        return $$4;
    }

    private void addBlocksConnectingTowards(IntFunction<Neighbor> $$0, SideChainPart $$1, Consumer<BlockPos> $$2) {
        for (int $$3 = 1; $$3 < this.getMaxChainLength(); ++$$3) {
            Neighbor $$4 = $$0.apply($$3);
            if ($$4.connectsTowards($$1)) {
                $$2.accept($$4.pos());
            }
            if ($$4.isUnconnectableOrChainEnd()) break;
        }
    }

    default public void updateNeighborsAfterPoweringDown(LevelAccessor $$0, BlockPos $$1, BlockState $$2) {
        Neighbors $$3 = this.getNeighbors($$0, $$1, this.getFacing($$2));
        $$3.left().disconnectFromRight();
        $$3.right().disconnectFromLeft();
    }

    default public void updateSelfAndNeighborsOnPoweringUp(LevelAccessor $$0, BlockPos $$1, BlockState $$2, BlockState $$3) {
        if (!this.isConnectable($$2)) {
            return;
        }
        if (this.isBeingUpdatedByNeighbor($$2, $$3)) {
            return;
        }
        Neighbors $$4 = this.getNeighbors($$0, $$1, this.getFacing($$2));
        SideChainPart $$5 = SideChainPart.UNCONNECTED;
        int $$6 = $$4.left().isConnectable() ? this.getAllBlocksConnectedTo($$0, $$4.left().pos()).size() : 0;
        int $$7 = $$4.right().isConnectable() ? this.getAllBlocksConnectedTo($$0, $$4.right().pos()).size() : 0;
        int $$8 = 1;
        if (this.canConnect($$6, $$8)) {
            $$5 = $$5.whenConnectedToTheLeft();
            $$4.left().connectToTheRight();
            $$8 += $$6;
        }
        if (this.canConnect($$7, $$8)) {
            $$5 = $$5.whenConnectedToTheRight();
            $$4.right().connectToTheLeft();
        }
        this.setPart($$0, $$1, $$5);
    }

    private boolean canConnect(int $$0, int $$1) {
        return $$0 > 0 && $$1 + $$0 <= this.getMaxChainLength();
    }

    private boolean isBeingUpdatedByNeighbor(BlockState $$0, BlockState $$1) {
        boolean $$2 = this.getSideChainPart($$0).isConnected();
        boolean $$3 = this.isConnectable($$1) && this.getSideChainPart($$1).isConnected();
        return $$2 || $$3;
    }

    private Neighbors getNeighbors(LevelAccessor $$0, BlockPos $$1, Direction $$2) {
        return new Neighbors(this, $$0, $$2, $$1, new HashMap<BlockPos, Neighbor>());
    }

    default public void setPart(LevelAccessor $$0, BlockPos $$1, SideChainPart $$2) {
        BlockState $$3 = $$0.getBlockState($$1);
        if (this.getSideChainPart($$3) != $$2) {
            $$0.setBlock($$1, this.setSideChainPart($$3, $$2), 3);
        }
    }

    public record Neighbors(SideChainPartBlock block, LevelAccessor level, Direction facing, BlockPos center, Map<BlockPos, Neighbor> cache) {
        private boolean isConnectableToThisBlock(BlockState $$0) {
            return this.block.isConnectable($$0) && this.block.getFacing($$0) == this.facing;
        }

        private Neighbor createNewNeighbor(BlockPos $$0) {
            BlockState $$1 = this.level.getBlockState($$0);
            SideChainPart $$2 = this.isConnectableToThisBlock($$1) ? this.block.getSideChainPart($$1) : null;
            return $$2 == null ? new EmptyNeighbor($$0) : new SideChainNeighbor(this.level, this.block, $$0, $$2);
        }

        private Neighbor getOrCreateNeighbor(Direction $$0, Integer $$1) {
            return this.cache.computeIfAbsent(this.center.relative($$0, (int)$$1), this::createNewNeighbor);
        }

        public Neighbor left(int $$0) {
            return this.getOrCreateNeighbor(this.facing.getClockWise(), $$0);
        }

        public Neighbor right(int $$0) {
            return this.getOrCreateNeighbor(this.facing.getCounterClockWise(), $$0);
        }

        public Neighbor left() {
            return this.left(1);
        }

        public Neighbor right() {
            return this.right(1);
        }
    }

    public static sealed interface Neighbor
    permits EmptyNeighbor, SideChainNeighbor {
        public BlockPos pos();

        public boolean isConnectable();

        public boolean isUnconnectableOrChainEnd();

        public boolean connectsTowards(SideChainPart var1);

        default public void connectToTheRight() {
        }

        default public void connectToTheLeft() {
        }

        default public void disconnectFromRight() {
        }

        default public void disconnectFromLeft() {
        }
    }

    public record SideChainNeighbor(LevelAccessor level, SideChainPartBlock block, BlockPos pos, SideChainPart part) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return true;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return this.part.isChainEnd();
        }

        @Override
        public boolean connectsTowards(SideChainPart $$0) {
            return this.part.isConnectionTowards($$0);
        }

        @Override
        public void connectToTheRight() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheRight());
        }

        @Override
        public void connectToTheLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenConnectedToTheLeft());
        }

        @Override
        public void disconnectFromRight() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheRight());
        }

        @Override
        public void disconnectFromLeft() {
            this.block.setPart(this.level, this.pos, this.part.whenDisconnectedFromTheLeft());
        }
    }

    public record EmptyNeighbor(BlockPos pos) implements Neighbor
    {
        @Override
        public boolean isConnectable() {
            return false;
        }

        @Override
        public boolean isUnconnectableOrChainEnd() {
            return true;
        }

        @Override
        public boolean connectsTowards(SideChainPart $$0) {
            return false;
        }
    }
}

