/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleMap;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import org.jspecify.annotations.Nullable;

public class GameRules {
    public static final GameRule<Boolean> ADVANCE_TIME = GameRules.registerBoolean("advance_time", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ADVANCE_WEATHER = GameRules.registerBoolean("advance_weather", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ALLOW_ENTERING_NETHER_USING_PORTALS = GameRules.registerBoolean("allow_entering_nether_using_portals", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> BLOCK_DROPS = GameRules.registerBoolean("block_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> BLOCK_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("block_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> COMMAND_BLOCKS_WORK = GameRules.registerBoolean("command_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> COMMAND_BLOCK_OUTPUT = GameRules.registerBoolean("command_block_output", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> DROWNING_DAMAGE = GameRules.registerBoolean("drowning_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ELYTRA_MOVEMENT_CHECK = GameRules.registerBoolean("elytra_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENDER_PEARLS_VANISH_ON_DEATH = GameRules.registerBoolean("ender_pearls_vanish_on_death", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENTITY_DROPS = GameRules.registerBoolean("entity_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> FALL_DAMAGE = GameRules.registerBoolean("fall_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> FIRE_DAMAGE = GameRules.registerBoolean("fire_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> FIRE_SPREAD_RADIUS_AROUND_PLAYER = GameRules.registerInteger("fire_spread_radius_around_player", GameRuleCategory.UPDATES, 128, -1);
    public static final GameRule<Boolean> FORGIVE_DEAD_PLAYERS = GameRules.registerBoolean("forgive_dead_players", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> FREEZE_DAMAGE = GameRules.registerBoolean("freeze_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> GLOBAL_SOUND_EVENTS = GameRules.registerBoolean("global_sound_events", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> IMMEDIATE_RESPAWN = GameRules.registerBoolean("immediate_respawn", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> KEEP_INVENTORY = GameRules.registerBoolean("keep_inventory", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LAVA_SOURCE_CONVERSION = GameRules.registerBoolean("lava_source_conversion", GameRuleCategory.UPDATES, false);
    public static final GameRule<Boolean> LIMITED_CRAFTING = GameRules.registerBoolean("limited_crafting", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LOCATOR_BAR = GameRules.registerBoolean("locator_bar", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> LOG_ADMIN_COMMANDS = GameRules.registerBoolean("log_admin_commands", GameRuleCategory.CHAT, true);
    public static final GameRule<Integer> MAX_BLOCK_MODIFICATIONS = GameRules.registerInteger("max_block_modifications", GameRuleCategory.MISC, 32768, 1);
    public static final GameRule<Integer> MAX_COMMAND_FORKS = GameRules.registerInteger("max_command_forks", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_COMMAND_SEQUENCE_LENGTH = GameRules.registerInteger("max_command_sequence_length", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_ENTITY_CRAMMING = GameRules.registerInteger("max_entity_cramming", GameRuleCategory.MOBS, 24, 0);
    public static final GameRule<Integer> MAX_MINECART_SPEED = GameRules.registerInteger("max_minecart_speed", GameRuleCategory.MISC, 8, 1, 1000, FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS));
    public static final GameRule<Integer> MAX_SNOW_ACCUMULATION_HEIGHT = GameRules.registerInteger("max_snow_accumulation_height", GameRuleCategory.UPDATES, 1, 0, 8);
    public static final GameRule<Boolean> MOB_DROPS = GameRules.registerBoolean("mob_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("mob_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_GRIEFING = GameRules.registerBoolean("mob_griefing", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> NATURAL_HEALTH_REGENERATION = GameRules.registerBoolean("natural_health_regeneration", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> PLAYER_MOVEMENT_CHECK = GameRules.registerBoolean("player_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.registerInteger("players_nether_portal_creative_delay", GameRuleCategory.PLAYER, 0, 0);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.registerInteger("players_nether_portal_default_delay", GameRuleCategory.PLAYER, 80, 0);
    public static final GameRule<Integer> PLAYERS_SLEEPING_PERCENTAGE = GameRules.registerInteger("players_sleeping_percentage", GameRuleCategory.PLAYER, 100, 0);
    public static final GameRule<Boolean> PROJECTILES_CAN_BREAK_BLOCKS = GameRules.registerBoolean("projectiles_can_break_blocks", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> PVP = GameRules.registerBoolean("pvp", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> RAIDS = GameRules.registerBoolean("raids", GameRuleCategory.MOBS, true);
    public static final GameRule<Integer> RANDOM_TICK_SPEED = GameRules.registerInteger("random_tick_speed", GameRuleCategory.UPDATES, 3, 0);
    public static final GameRule<Boolean> REDUCED_DEBUG_INFO = GameRules.registerBoolean("reduced_debug_info", GameRuleCategory.MISC, false);
    public static final GameRule<Integer> RESPAWN_RADIUS = GameRules.registerInteger("respawn_radius", GameRuleCategory.PLAYER, 10, 0);
    public static final GameRule<Boolean> SEND_COMMAND_FEEDBACK = GameRules.registerBoolean("send_command_feedback", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_ADVANCEMENT_MESSAGES = GameRules.registerBoolean("show_advancement_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_DEATH_MESSAGES = GameRules.registerBoolean("show_death_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SPAWNER_BLOCKS_WORK = GameRules.registerBoolean("spawner_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> SPAWN_MOBS = GameRules.registerBoolean("spawn_mobs", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_MONSTERS = GameRules.registerBoolean("spawn_monsters", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PATROLS = GameRules.registerBoolean("spawn_patrols", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PHANTOMS = GameRules.registerBoolean("spawn_phantoms", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WANDERING_TRADERS = GameRules.registerBoolean("spawn_wandering_traders", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WARDENS = GameRules.registerBoolean("spawn_wardens", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPECTATORS_GENERATE_CHUNKS = GameRules.registerBoolean("spectators_generate_chunks", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> SPREAD_VINES = GameRules.registerBoolean("spread_vines", GameRuleCategory.UPDATES, true);
    public static final GameRule<Boolean> TNT_EXPLODES = GameRules.registerBoolean("tnt_explodes", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> TNT_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("tnt_explosion_drop_decay", GameRuleCategory.DROPS, false);
    public static final GameRule<Boolean> UNIVERSAL_ANGER = GameRules.registerBoolean("universal_anger", GameRuleCategory.MOBS, false);
    public static final GameRule<Boolean> WATER_SOURCE_CONVERSION = GameRules.registerBoolean("water_source_conversion", GameRuleCategory.UPDATES, true);
    private final GameRuleMap rules;

    public static Codec<GameRules> codec(FeatureFlagSet $$02) {
        return GameRuleMap.CODEC.xmap($$1 -> new GameRules($$02, (GameRuleMap)$$1), $$0 -> $$0.rules);
    }

    public GameRules(FeatureFlagSet $$0, GameRuleMap $$1) {
        this($$0);
        this.rules.setFromIf($$1, this.rules::has);
    }

    public GameRules(FeatureFlagSet $$0) {
        this.rules = GameRuleMap.of(BuiltInRegistries.GAME_RULE.filterFeatures($$0).listElements().map(Holder::value));
    }

    public Stream<GameRule<?>> availableRules() {
        return this.rules.keySet().stream();
    }

    public <T> T get(GameRule<T> $$0) {
        T $$1 = this.rules.get($$0);
        if ($$1 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return $$1;
    }

    public <T> void set(GameRule<T> $$0, T $$1, @Nullable MinecraftServer $$2) {
        if (!this.rules.has($$0)) {
            throw new IllegalArgumentException("Tried to set invalid game rule");
        }
        this.rules.set($$0, $$1);
        if ($$2 != null) {
            $$2.onGameRuleChanged($$0, $$1);
        }
    }

    public GameRules copy(FeatureFlagSet $$0) {
        return new GameRules($$0, this.rules);
    }

    public void setAll(GameRules $$0, @Nullable MinecraftServer $$1) {
        this.setAll($$0.rules, $$1);
    }

    public void setAll(GameRuleMap $$0, @Nullable MinecraftServer $$1) {
        $$0.keySet().forEach($$2 -> this.setFromOther($$0, (GameRule)$$2, $$1));
    }

    private <T> void setFromOther(GameRuleMap $$0, GameRule<T> $$1, @Nullable MinecraftServer $$2) {
        this.set($$1, Objects.requireNonNull($$0.get($$1)), $$2);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor $$0) {
        this.rules.keySet().forEach($$1 -> {
            $$0.visit($$1);
            $$1.callVisitor($$0);
        });
    }

    private static GameRule<Boolean> registerBoolean(String $$02, GameRuleCategory $$1, boolean $$2) {
        return GameRules.register($$02, $$1, GameRuleType.BOOL, BoolArgumentType.bool(), Codec.BOOL, $$2, FeatureFlagSet.of(), GameRuleTypeVisitor::visitBoolean, $$0 -> $$0 != false ? 1 : 0);
    }

    private static GameRule<Integer> registerInteger(String $$0, GameRuleCategory $$1, int $$2, int $$3) {
        return GameRules.registerInteger($$0, $$1, $$2, $$3, Integer.MAX_VALUE, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String $$0, GameRuleCategory $$1, int $$2, int $$3, int $$4) {
        return GameRules.registerInteger($$0, $$1, $$2, $$3, $$4, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String $$02, GameRuleCategory $$1, int $$2, int $$3, int $$4, FeatureFlagSet $$5) {
        return GameRules.register($$02, $$1, GameRuleType.INT, IntegerArgumentType.integer((int)$$3, (int)$$4), Codec.intRange((int)$$3, (int)$$4), $$2, $$5, GameRuleTypeVisitor::visitInteger, $$0 -> $$0);
    }

    private static <T> GameRule<T> register(String $$0, GameRuleCategory $$1, GameRuleType $$2, ArgumentType<T> $$3, Codec<T> $$4, T $$5, FeatureFlagSet $$6, VisitorCaller<T> $$7, ToIntFunction<T> $$8) {
        return Registry.register(BuiltInRegistries.GAME_RULE, $$0, new GameRule<T>($$1, $$2, $$3, $$7, $$4, $$8, $$5, $$6));
    }

    public static GameRule<?> bootstrap(Registry<GameRule<?>> $$0) {
        return ADVANCE_TIME;
    }

    public <T> String getAsString(GameRule<T> $$0) {
        return $$0.serialize(this.get($$0));
    }

    public static interface VisitorCaller<T> {
        public void call(GameRuleTypeVisitor var1, GameRule<T> var2);
    }
}

