/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderwaterMagmaFeature
extends Feature<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> $$0) {
        super($$0);
    }

    @Override
    public boolean place(FeaturePlaceContext<UnderwaterMagmaConfiguration> $$0) {
        Vec3i $$7;
        WorldGenLevel $$12 = $$0.level();
        BlockPos $$22 = $$0.origin();
        UnderwaterMagmaConfiguration $$3 = $$0.config();
        RandomSource $$4 = $$0.random();
        OptionalInt $$5 = UnderwaterMagmaFeature.getFloorY($$12, $$22, $$3);
        if ($$5.isEmpty()) {
            return false;
        }
        BlockPos $$6 = $$22.atY($$5.getAsInt());
        BoundingBox $$8 = BoundingBox.fromCorners($$6.subtract($$7 = new Vec3i($$3.placementRadiusAroundFloor, $$3.placementRadiusAroundFloor, $$3.placementRadiusAroundFloor)), $$6.offset($$7));
        return BlockPos.betweenClosedStream($$8).filter($$2 -> $$4.nextFloat() < $$1.placementProbabilityPerValidPosition).filter($$1 -> this.isValidPlacement($$12, (BlockPos)$$1)).mapToInt($$1 -> {
            $$12.setBlock((BlockPos)$$1, Blocks.MAGMA_BLOCK.defaultBlockState(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt getFloorY(WorldGenLevel $$02, BlockPos $$1, UnderwaterMagmaConfiguration $$2) {
        Predicate<BlockState> $$3 = $$0 -> $$0.is(Blocks.WATER);
        Predicate<BlockState> $$4 = $$0 -> !$$0.is(Blocks.WATER);
        Optional<Column> $$5 = Column.scan($$02, $$1, $$2.floorSearchRange, $$3, $$4);
        return $$5.map(Column::getFloor).orElseGet(OptionalInt::empty);
    }

    private boolean isValidPlacement(WorldGenLevel $$0, BlockPos $$1) {
        if (UnderwaterMagmaFeature.isWaterOrAir($$0.getBlockState($$1)) || this.isVisibleFromOutside($$0, $$1.below(), Direction.UP)) {
            return false;
        }
        for (Direction $$2 : Direction.Plane.HORIZONTAL) {
            if (!this.isVisibleFromOutside($$0, $$1.relative($$2), $$2.getOpposite())) continue;
            return false;
        }
        return true;
    }

    private static boolean isWaterOrAir(BlockState $$0) {
        return $$0.is(Blocks.WATER) || $$0.isAir();
    }

    private boolean isVisibleFromOutside(LevelAccessor $$0, BlockPos $$1, Direction $$2) {
        BlockState $$3 = $$0.getBlockState($$1);
        VoxelShape $$4 = $$3.getFaceOcclusionShape($$2);
        return $$4 == Shapes.empty() || !Block.isShapeFullBlock($$4);
    }
}

